/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.storage;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class ObjectEntryWriter
implements AutoCloseable {
    private static final String EMPTY_ENTRY = "{}";
    private final OutputStream ouputStream;
    private final BufferedWriter writer;
    private boolean isEmpty = true;
    private boolean isEofWritten;
    private boolean isClosed;

    public ObjectEntryWriter(OutputStream ouputStream) {
        this.ouputStream = ouputStream;
        this.writer = new BufferedWriter(new OutputStreamWriter(ouputStream));
    }

    public void write(ObjectEntry objectEntry) throws IOException {
        ParametersChecker.checkParameter("", new String[0]);
        this.ensureNotClosed();
        this.ensureNotEof();
        if (!this.isEmpty) {
            this.writer.append("\n");
        }
        this.isEmpty = false;
        this.writer.write(JsonHandler.unprettyPrint(objectEntry));
    }

    public void writeEof() throws IOException {
        this.ensureNotClosed();
        this.ensureNotEof();
        if (!this.isEmpty) {
            this.writer.append("\n");
        }
        this.isEmpty = false;
        this.writer.write(EMPTY_ENTRY);
        this.isEofWritten = true;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.isEmpty) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.ouputStream.close();
    }

    private void ensureNotClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("Closed stream");
        }
    }

    private void ensureNotEof() throws IOException {
        if (this.isEofWritten) {
            throw new IOException("Cannot append after EOF");
        }
    }
}

