/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.processing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import fr.gouv.vitam.common.model.processing.LifecycleState;
import fr.gouv.vitam.common.model.processing.Step;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkFlow {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="identifier")
    private String identifier;
    @JsonProperty(value="typeProc")
    private String typeProc;
    @JsonProperty(value="comment")
    private String comment;
    private LifecycleState lifecycleLog;
    protected List<Step> steps;

    public WorkFlow() {
    }

    @JsonCreator
    public WorkFlow(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="identifier") String identifier, @JsonProperty(value="typeProc") String typeProc, @JsonProperty(value="comment") String comment, @JsonProperty(value="lifecycleLog") LifecycleState lifecycleLog, @JsonProperty(value="steps") List<Step> steps) {
        this.id = id;
        this.name = name;
        this.identifier = identifier;
        this.typeProc = typeProc;
        this.comment = comment;
        this.lifecycleLog = (LifecycleState)((Object)MoreObjects.firstNonNull((Object)((Object)lifecycleLog), (Object)((Object)LifecycleState.TEMPORARY)));
        this.steps = steps;
        if (steps == null) {
            this.steps = new ArrayList<Step>();
        }
        this.steps.forEach(step -> step.defaultLifecycleLog(this.lifecycleLog));
    }

    public static WorkFlow of(String id, String identifier, String evTypeProc) {
        WorkFlow workFlow = new WorkFlow();
        workFlow.setId(id);
        workFlow.setIdentifier(identifier);
        workFlow.setTypeProc(evTypeProc);
        return workFlow;
    }

    public String getId() {
        if (this.id == null) {
            return "";
        }
        return this.id;
    }

    public WorkFlow setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public WorkFlow setName(String name) {
        this.name = name;
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public WorkFlow setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String getTypeProc() {
        if (this.typeProc == null) {
            return "";
        }
        return this.typeProc;
    }

    public WorkFlow setTypeProc(String typeProc) {
        this.typeProc = typeProc;
        return this;
    }

    public String getComment() {
        if (this.comment == null) {
            return "";
        }
        return this.comment;
    }

    public List<Step> getSteps() {
        if (this.steps == null) {
            return Collections.emptyList();
        }
        return this.steps;
    }

    public WorkFlow setSteps(List<Step> steps) {
        this.steps = steps;
        return this;
    }

    public WorkFlow setComment(String comments) {
        this.comment = comments;
        return this;
    }

    public String toString() {
        return String.format("ID=%s\nname=%s\nidentifier=%s\ntypeProc=%s\ncomments=%s\nlifecycleLog=%s\n", new Object[]{this.getId(), this.getName(), this.getIdentifier(), this.getTypeProc(), this.getComment(), this.getLifecycleLog()});
    }

    public LifecycleState getLifecycleLog() {
        return this.lifecycleLog;
    }

    public WorkFlow setLifecycleLog(LifecycleState lifecycleLog) {
        this.lifecycleLog = lifecycleLog;
        return this;
    }
}

