/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import fr.gouv.vitam.common.logging.LogbackLogger;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import javax.management.RuntimeErrorException;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLoggerFactory;

public final class LogbackLoggerFactory
extends VitamLoggerFactory {
    static final String ROOT = "ROOT";

    public LogbackLoggerFactory(VitamLogLevel level) {
        super(level);
        this.seLevelSpecific(currentLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogbackLoggerFactory(boolean failIfNOP) {
        super(null);
        assert (failIfNOP);
        final StringBuilder buf = new StringBuilder();
        PrintStream err = System.err;
        try {
            System.setErr(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                    buf.append((char)b);
                }
            }, true, "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeErrorException(new Error(e));
        }
        try {
            if (LoggerFactory.getILoggerFactory() instanceof NOPLoggerFactory) {
                throw new NoClassDefFoundError(buf.toString());
            }
            err.print(buf.toString());
            err.flush();
        }
        finally {
            System.setErr(err);
            this.seLevelSpecific(currentLevel);
        }
    }

    static void loggerSetLevel(Logger logger, VitamLogLevel level) {
        switch (level) {
            case TRACE: {
                logger.setLevel(Level.TRACE);
                break;
            }
            case DEBUG: {
                logger.setLevel(Level.DEBUG);
                break;
            }
            case INFO: {
                logger.setLevel(Level.INFO);
                break;
            }
            case WARN: {
                logger.setLevel(Level.WARN);
                break;
            }
            case ERROR: {
                logger.setLevel(Level.ERROR);
                break;
            }
            default: {
                logger.setLevel(Level.WARN);
            }
        }
    }

    @Override
    protected void seLevelSpecific(VitamLogLevel level) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)ROOT);
        LogbackLoggerFactory.loggerSetLevel(logger, level);
    }

    @Override
    public VitamLogger newInstance(String name) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)name);
        return new LogbackLogger(logger);
    }

    static VitamLogLevel loggerGetLevel(Logger logger) {
        if (logger.isTraceEnabled()) {
            return VitamLogLevel.TRACE;
        }
        if (logger.isDebugEnabled()) {
            return VitamLogLevel.DEBUG;
        }
        if (logger.isInfoEnabled()) {
            return VitamLogLevel.INFO;
        }
        if (logger.isWarnEnabled()) {
            return VitamLogLevel.WARN;
        }
        if (logger.isErrorEnabled()) {
            return VitamLogLevel.ERROR;
        }
        return null;
    }

    @Override
    protected VitamLogLevel getLevelSpecific() {
        Logger logger = (Logger)LoggerFactory.getLogger((String)ROOT);
        return LogbackLoggerFactory.loggerGetLevel(logger);
    }
}

