/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.logging;

import fr.gouv.vitam.common.logging.JdkLogger;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JdkLoggerFactory
extends VitamLoggerFactory {
    public JdkLoggerFactory(VitamLogLevel level) {
        super(level);
        this.seLevelSpecific(currentLevel);
    }

    @Override
    public VitamLogger newInstance(String name) {
        Logger logger = Logger.getLogger(name);
        if (currentLevel == VitamLogLevel.DEBUG || currentLevel == VitamLogLevel.TRACE) {
            JdkLoggerFactory.loggerSetLevel(logger, currentLevel);
        }
        return new JdkLogger(logger);
    }

    static void loggerSetLevel(Logger logger, VitamLogLevel level) {
        Level jdklevel;
        switch (level) {
            case TRACE: {
                jdklevel = Level.FINEST;
                break;
            }
            case DEBUG: {
                jdklevel = Level.FINE;
                break;
            }
            case INFO: {
                jdklevel = Level.INFO;
                break;
            }
            case WARN: {
                jdklevel = Level.WARNING;
                break;
            }
            case ERROR: {
                jdklevel = Level.SEVERE;
                break;
            }
            default: {
                jdklevel = Level.WARNING;
            }
        }
        logger.setLevel(jdklevel);
    }

    @Override
    protected void seLevelSpecific(VitamLogLevel level) {
        Logger logger = Logger.getLogger("global");
        JdkLoggerFactory.loggerSetLevel(logger, level);
    }

    static VitamLogLevel loggerGetLevel(Logger logger) {
        if (logger.isLoggable(Level.FINEST)) {
            return VitamLogLevel.TRACE;
        }
        if (logger.isLoggable(Level.FINE)) {
            return VitamLogLevel.DEBUG;
        }
        if (logger.isLoggable(Level.INFO)) {
            return VitamLogLevel.INFO;
        }
        if (logger.isLoggable(Level.WARNING)) {
            return VitamLogLevel.WARN;
        }
        if (logger.isLoggable(Level.SEVERE)) {
            return VitamLogLevel.ERROR;
        }
        return null;
    }

    @Override
    protected VitamLogLevel getLevelSpecific() {
        Logger logger = Logger.getLogger("global");
        return JdkLoggerFactory.loggerGetLevel(logger);
    }
}

