/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.stream.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public final class JsonHandler {
    public static final String JSON_SET_FOR_ACTION_DSL_REGEX = "[.]";
    public static final TypeReference<JsonNode> JSON_NODE_TYPE_REFERENCE = new TypeReference<JsonNode>(){};
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(JsonHandler.class);
    private static final String OBJECT = "object";
    private static final String REG_EXP_JSONPATH_SEPARATOR = "\\.";
    private static final JsonFactory JSONFACTORY = new JsonFactory();
    private static final ObjectMapper OBJECT_MAPPER = JsonHandler.buildObjectMapper();
    private static final ObjectMapper OBJECT_MAPPER_UNPRETTY = JsonHandler.buildObjectMapper();
    private static final ObjectMapper OBJECT_MAPPER_LOWER_CAMEL_CASE;
    private static final ObjectMapper STRICT_OBJECT_MAPPER;

    private JsonHandler() {
    }

    private static ObjectMapper buildObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper(JSONFACTORY);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.UPPER_CAMEL_CASE);
        objectMapper.configOverride(Map.class).setIncludeAsProperty(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.USE_DEFAULTS, (JsonInclude.Include)JsonInclude.Include.ALWAYS));
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        objectMapper.configure(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS, true);
        objectMapper.configure(JsonWriteFeature.ESCAPE_NON_ASCII.mappedFeature(), true);
        objectMapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(false));
        return objectMapper;
    }

    public static JsonNodeFactory getFactory() {
        return OBJECT_MAPPER.getNodeFactory();
    }

    public static ObjectNode createObjectNode() {
        return OBJECT_MAPPER.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return OBJECT_MAPPER.createArrayNode();
    }

    public static ArrayNode createStringArrayNode(String ... values) {
        ArrayNode arrayNode = JsonHandler.createArrayNode();
        for (String value : values) {
            arrayNode.add(value);
        }
        return arrayNode;
    }

    public static ArrayNode createStringArrayNode(Collection<String> values) {
        ArrayNode arrayNode = JsonHandler.createArrayNode();
        for (String value : values) {
            arrayNode.add(value);
        }
        return arrayNode;
    }

    public static JsonNode createNullNode() {
        return OBJECT_MAPPER.nullNode();
    }

    public static JsonNode getFromString(String value) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("value", value);
            return OBJECT_MAPPER.readTree(value);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static byte[] fromPojoToBytes(Object value) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("value", value);
            return OBJECT_MAPPER.writeValueAsBytes(value);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static void validate(String value) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("value", value);
            JsonNode on = OBJECT_MAPPER.readTree(value);
            if (!on.isObject()) {
                throw new InvalidParseOperationException("Invalid Json value ");
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static JsonGenerator createJsonGenerator(OutputStream os) throws IOException {
        return JSONFACTORY.createGenerator(os);
    }

    public static JsonParser createJsonParser(InputStream in) throws IOException {
        return JSONFACTORY.createParser(in);
    }

    public static JsonNode getFromFile(File file) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("File", file);
            return OBJECT_MAPPER.readTree(file);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static JsonNode getFromReader(Reader reader) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("reader", reader);
            return OBJECT_MAPPER.readTree(reader);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static JsonNode getFromInputStream(InputStream stream) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("InputStream", stream);
            return OBJECT_MAPPER.readTree(stream);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static JsonNode getFromInputStream(InputStream stream1, InputStream stream2) throws InvalidParseOperationException {
        ParametersChecker.checkParameter("InputStream 1", stream1);
        if (stream2 == null) {
            return JsonHandler.getFromInputStream(stream1);
        }
        return JsonHandler.merge(JsonHandler.getFromInputStream(stream1), JsonHandler.getFromInputStream(stream2));
    }

    private static JsonNode merge(JsonNode mainNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = mainNode.get(fieldName);
            if (jsonNode != null && jsonNode.isObject()) {
                JsonHandler.merge(jsonNode, updateNode.get(fieldName));
                continue;
            }
            if (!(mainNode instanceof ObjectNode)) continue;
            JsonNode value = updateNode.get(fieldName);
            ((ObjectNode)mainNode).set(fieldName, value);
        }
        return mainNode;
    }

    public static <T> T getFromString(String value, Class<T> clasz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("value or class", value, clasz);
            return (T)OBJECT_MAPPER.readValue(value, clasz);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> T getFromInputStreamAsTypeReference(InputStream inputStream, TypeReference<T> clasz) throws InvalidParseOperationException, InvalidFormatException {
        try {
            ParametersChecker.checkParameter("value or class", inputStream, clasz);
            if (JSON_NODE_TYPE_REFERENCE.getType() == clasz.getType()) {
                return (T)OBJECT_MAPPER.readTree(inputStream);
            }
            return (T)OBJECT_MAPPER.readValue(inputStream, clasz);
        }
        catch (InvalidFormatException e) {
            throw new InvalidFormatException(null, e.toString(), (Object)inputStream, clasz.getClass());
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> T getFromStringAsTypeReference(String value, TypeReference<T> clasz) throws InvalidParseOperationException, InvalidFormatException {
        try {
            ParametersChecker.checkParameter("value or class", value, clasz);
            if (JSON_NODE_TYPE_REFERENCE.getType() == clasz.getType()) {
                return (T)OBJECT_MAPPER.readTree(value);
            }
            return (T)OBJECT_MAPPER.readValue(value, clasz);
        }
        catch (InvalidFormatException e) {
            throw new InvalidFormatException(null, e.toString(), (Object)value, clasz.getClass());
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> T getFromString(String value, Class<?> clasz, Class<?> parameterClazz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("value, class or parameterClazz", value, clasz, parameterClazz);
            JavaType type = OBJECT_MAPPER.getTypeFactory().constructParametricType(clasz, new Class[]{parameterClazz});
            return (T)OBJECT_MAPPER.readValue(value, type);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> T getFromStringLowerCamelCase(String value, Class<T> clasz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("value or class", value, clasz);
            return (T)OBJECT_MAPPER_LOWER_CAMEL_CASE.readValue(value, clasz);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static JsonNode getFromBytes(byte[] value) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("value", new Object[]{value});
            return OBJECT_MAPPER.readTree(value);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> T getFromFile(File file, Class<T> clasz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("File or class", file, clasz);
            return (T)OBJECT_MAPPER.readValue(file, clasz);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> T getFromFileAsTypeReference(File file, TypeReference<T> valueTypeRef) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("File or class", file, valueTypeRef);
            if (JSON_NODE_TYPE_REFERENCE.getType() == valueTypeRef.getType()) {
                return (T)OBJECT_MAPPER.readTree(file);
            }
            return (T)OBJECT_MAPPER.readValue(file, valueTypeRef);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> T getFromFileLowerCamelCase(File file, Class<T> clasz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("File or class", file, clasz);
            return (T)OBJECT_MAPPER_LOWER_CAMEL_CASE.readValue(file, clasz);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> T getFromJsonNode(JsonNode jsonNode, Class<T> clazz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("JsonNode or class", jsonNode, clazz);
            return (T)OBJECT_MAPPER.treeToValue((TreeNode)jsonNode, clazz);
        }
        catch (JsonProcessingException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> T getFromJsonNode(JsonNode jsonNode, Class<?> clasz, Class<?> parameterClazz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("value, class or parameterClazz", jsonNode, clasz, parameterClazz);
            JavaType type = OBJECT_MAPPER.getTypeFactory().constructParametricType(clasz, new Class[]{parameterClazz});
            ObjectReader reader = OBJECT_MAPPER.readerFor(type);
            return (T)reader.readValue(jsonNode);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> T getFromJsonNodeLowerCamelCase(JsonNode jsonNode, Class<T> clasz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("JsonNode or class", jsonNode, clasz);
            return (T)OBJECT_MAPPER_LOWER_CAMEL_CASE.treeToValue((TreeNode)jsonNode, clasz);
        }
        catch (JsonProcessingException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> T getFromJsonNode(JsonNode jsonNode, TypeReference<T> clazz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("JsonNode or class", jsonNode, clazz);
            ObjectReader objectReader = OBJECT_MAPPER.readerFor(clazz);
            return (T)objectReader.readValue(jsonNode);
        }
        catch (IOException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> T getFromStrictJsonNode(JsonNode jsonNode, TypeReference<T> clazz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("JsonNode or class", jsonNode, clazz);
            ObjectReader objectReader = STRICT_OBJECT_MAPPER.readerFor(clazz);
            return (T)objectReader.readValue(jsonNode);
        }
        catch (IOException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> List<T> getFromJsonNodeList(List<JsonNode> jsonNodes, Class<T> clazz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("JsonNode or class", jsonNodes, clazz);
            ArrayList<Object> result = new ArrayList<Object>();
            for (JsonNode jsonNode : jsonNodes) {
                result.add(OBJECT_MAPPER.treeToValue((TreeNode)jsonNode, clazz));
            }
            return result;
        }
        catch (JsonProcessingException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> List<T> getFromJsonNodeList(List<JsonNode> jsonNodes, TypeReference<T> clazz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("JsonNode or class", jsonNodes, clazz);
            ObjectReader objectReader = OBJECT_MAPPER.readerFor(clazz);
            ArrayList<Object> result = new ArrayList<Object>();
            for (JsonNode jsonNode : jsonNodes) {
                result.add(objectReader.readValue(jsonNode));
            }
            return result;
        }
        catch (IOException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static JsonNode toJsonNode(Object object) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter(OBJECT, object);
            return (JsonNode)OBJECT_MAPPER.convertValue(object, JsonNode.class);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static String writeAsString(Object object) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter(OBJECT, object);
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static String prettyPrint(Object object) {
        try {
            ParametersChecker.checkParameter(OBJECT, object);
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            LOGGER.info(e);
            return "{}";
        }
    }

    public static String unprettyPrint(Object object) {
        try {
            ParametersChecker.checkParameter(OBJECT, object);
            return OBJECT_MAPPER_UNPRETTY.writeValueAsString(object);
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            LOGGER.info(e);
            return "{}";
        }
    }

    public static void writeAsFile(Object object, File file) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("object or file", object, file);
            OBJECT_MAPPER.writeValue(file, object);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static void writeAsOutputStream(Object object, OutputStream outputStream) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("object or file", object, outputStream);
            OBJECT_MAPPER.writeValue(outputStream, object);
            outputStream.flush();
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static InputStream writeToInpustream(Object object) throws InvalidParseOperationException {
        return new ByteArrayInputStream(JsonHandler.writeAsString(object).getBytes(StandardCharsets.UTF_8));
    }

    public static void checkNullOrEmpty(String message, JsonNode ... nodes) {
        if (nodes != null) {
            for (JsonNode jsonNode : nodes) {
                if (jsonNode != null && jsonNode.size() != 0) continue;
                throw new IllegalArgumentException(message);
            }
        } else {
            throw new IllegalArgumentException(message);
        }
    }

    public static Map.Entry<String, JsonNode> checkUnicity(String nodeName, JsonNode node) throws InvalidParseOperationException {
        if (node == null || node.isMissingNode()) {
            throw new InvalidParseOperationException("The current Node is missing(empty): " + nodeName + ":" + node);
        }
        if (node.isValueNode()) {
            throw new InvalidParseOperationException("The current Node is a simple value and should not: " + nodeName + ":" + node);
        }
        int size = node.size();
        if (size > 1) {
            throw new InvalidParseOperationException("More than one element in current Node: " + nodeName + ":" + node);
        }
        if (size == 0) {
            throw new InvalidParseOperationException("Not enough element (0) in current Node: " + nodeName + ":" + node);
        }
        Iterator iterator = node.fields();
        return (Map.Entry)iterator.next();
    }

    public static Map.Entry<String, JsonNode> checkLaxUnicity(String nodeName, final JsonNode node) throws InvalidParseOperationException {
        if (node == null || node.isMissingNode()) {
            throw new InvalidParseOperationException("The current Node is missing(empty): " + nodeName + ":" + node);
        }
        if (node.isValueNode()) {
            return new Map.Entry<String, JsonNode>(){

                @Override
                public JsonNode setValue(JsonNode value) {
                    throw new IllegalArgumentException("Cannot set Value");
                }

                @Override
                public JsonNode getValue() {
                    return node;
                }

                @Override
                public String getKey() {
                    return null;
                }
            };
        }
        int size = node.size();
        if (size > 1) {
            throw new InvalidParseOperationException("More than one element in current Node: " + nodeName + ":" + node);
        }
        if (size == 0) {
            throw new InvalidParseOperationException("Not enough element (0) in current Node: " + nodeName + ":" + node);
        }
        Iterator iterator = node.fields();
        return (Map.Entry)iterator.next();
    }

    public static Map<String, Object> getMapFromString(String value) throws InvalidParseOperationException {
        if (value != null && !value.isEmpty()) {
            HashMap info;
            try {
                info = (HashMap)OBJECT_MAPPER.readValue(value, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                throw new InvalidParseOperationException(e);
            }
            if (info == null) {
                info = new HashMap();
            }
            return info;
        }
        return new HashMap<String, Object>();
    }

    public static Map<String, String> getMapStringFromString(String value) throws InvalidParseOperationException {
        if (value != null && !value.isEmpty()) {
            HashMap info;
            try {
                info = (HashMap)OBJECT_MAPPER.readValue(value, (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (IOException e) {
                throw new InvalidParseOperationException(e);
            }
            if (info == null) {
                info = new HashMap();
            }
            return info;
        }
        return new HashMap<String, String>();
    }

    public static Map<String, Object> getMapFromInputStream(InputStream inputStream) throws InvalidParseOperationException {
        HashMap info;
        ParametersChecker.checkParameter("InputStream", inputStream);
        try {
            info = (HashMap)OBJECT_MAPPER.readValue(ByteStreams.toByteArray((InputStream)inputStream), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new InvalidParseOperationException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            }
        }
        if (info == null) {
            info = new HashMap();
        }
        return info;
    }

    public static <T> Map<String, T> getMapFromInputStream(InputStream inputStream, Class<T> parameterClazz) throws InvalidParseOperationException {
        HashMap info;
        ParametersChecker.checkParameter("InputStream", inputStream);
        try {
            JavaType type = OBJECT_MAPPER.getTypeFactory().constructParametricType(Map.class, new Class[]{String.class, parameterClazz});
            info = (HashMap)OBJECT_MAPPER.readValue(ByteStreams.toByteArray((InputStream)inputStream), type);
        }
        catch (IOException e) {
            throw new InvalidParseOperationException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            }
        }
        if (info == null) {
            info = new HashMap();
        }
        return info;
    }

    public static <T> T getFromInputStream(InputStream inputStream, Class<T> clasz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("InputStream or class", inputStream, clasz);
            Object object = OBJECT_MAPPER.readValue(ByteStreams.toByteArray((InputStream)inputStream), clasz);
            return (T)object;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
        finally {
            StreamUtils.closeSilently(inputStream);
        }
    }

    public static <T> T getFromInputStreamLowerCamelCase(InputStream inputStream, TypeReference<T> typeReference) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("InputStream or class", inputStream, typeReference);
            return (T)OBJECT_MAPPER_LOWER_CAMEL_CASE.readValue(IOUtils.toByteArray((InputStream)inputStream), typeReference);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static <T> T getFromInputStream(InputStream inputStream, Class<T> clasz, Class<?> ... parameterClazz) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("InputStream, class or parameterClazz", inputStream, clasz, parameterClazz);
            JavaType type = OBJECT_MAPPER.getTypeFactory().constructParametricType(clasz, (Class[])parameterClazz);
            Object object = OBJECT_MAPPER.readValue(ByteStreams.toByteArray((InputStream)inputStream), type);
            return (T)object;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidParseOperationException(e);
        }
        finally {
            StreamUtils.closeSilently(inputStream);
        }
    }

    public static ArrayNode getSubArrayNode(ArrayNode array, int offset, int limit) {
        int i;
        ArrayNode subResult = JsonHandler.createArrayNode();
        Iterator iterator = array.elements();
        for (i = 0; i < offset && iterator.hasNext(); ++i) {
            iterator.next();
        }
        for (i = offset; i < offset + limit && iterator.hasNext(); ++i) {
            subResult.add((JsonNode)iterator.next());
        }
        return subResult;
    }

    public static JsonNode getNodeByPath(JsonNode node, String fieldPath, boolean deepCopy) {
        String[] fieldNamePath = fieldPath.split(JSON_SET_FOR_ACTION_DSL_REGEX);
        String lastNodeName = fieldNamePath[fieldNamePath.length - 1];
        JsonNode parentNode = JsonHandler.getParentNodeByPath(node, fieldPath, deepCopy);
        if (parentNode == null) {
            return null;
        }
        JsonNode lastNode = parentNode.get(lastNodeName);
        if (lastNode == null) {
            return null;
        }
        return deepCopy ? lastNode.deepCopy() : lastNode;
    }

    public static JsonNode getParentNodeByPath(JsonNode node, String fieldPath, boolean deepCopy) {
        String[] fieldNamePath = fieldPath.split(JSON_SET_FOR_ACTION_DSL_REGEX);
        JsonNode currentLevelNode = node;
        int len = fieldNamePath.length - 1;
        for (int i = 0; i < len; ++i) {
            JsonNode nextLevel = currentLevelNode.get(fieldNamePath[i]);
            if (nextLevel == null) {
                return null;
            }
            currentLevelNode = nextLevel;
        }
        return deepCopy ? currentLevelNode.deepCopy() : currentLevelNode;
    }

    public static void setNodeInPath(ObjectNode node, String nodePath, JsonNode value, boolean canCreate) throws InvalidParseOperationException {
        String[] fieldNamePath = nodePath.split(JSON_SET_FOR_ACTION_DSL_REGEX);
        String lastNodeName = fieldNamePath[fieldNamePath.length - 1];
        ObjectNode currentLevelNode = node;
        int len = fieldNamePath.length - 1;
        for (int i = 0; i < len; ++i) {
            JsonNode childNode = currentLevelNode.get(fieldNamePath[i]);
            if (childNode != null && !childNode.isObject()) {
                throw new InvalidParseOperationException("The node  '" + fieldNamePath[i] + "' is not an object ");
            }
            ObjectNode nextLevel = (ObjectNode)childNode;
            if (nextLevel == null) {
                if (canCreate) {
                    currentLevelNode.set(fieldNamePath[i], (JsonNode)JsonHandler.createObjectNode());
                    nextLevel = (ObjectNode)currentLevelNode.get(fieldNamePath[i]);
                } else {
                    throw new InvalidParseOperationException("can not find node '" + fieldNamePath[i] + "' in " + nodePath);
                }
            }
            currentLevelNode = nextLevel;
        }
        currentLevelNode.set(lastNodeName, value);
    }

    public static String getLastFieldName(String nodePath) {
        return nodePath.substring(nodePath.lastIndexOf(46) + 1);
    }

    public static List<JsonNode> toArrayList(ArrayNode arrayNode) {
        return Lists.newArrayList((Iterator)arrayNode.iterator());
    }

    public static boolean isEmpty(String jsonString) throws InvalidParseOperationException {
        JsonNode node = JsonHandler.getFromString(jsonString);
        return node.isEmpty(null);
    }

    public static JsonNode findNode(JsonNode rootNode, String path) {
        if (rootNode == null || Strings.isNullOrEmpty((String)path)) {
            return MissingNode.getInstance();
        }
        String[] nodeNames = path.split(REG_EXP_JSONPATH_SEPARATOR);
        JsonNode currentNode = rootNode;
        for (String nodeName : nodeNames) {
            if (!(currentNode = currentNode.path(nodeName)).isMissingNode()) continue;
            return currentNode;
        }
        return currentNode;
    }

    public static boolean isNullOrEmpty(JsonNode jsonNode) {
        if (jsonNode == null) {
            return true;
        }
        return !jsonNode.fieldNames().hasNext();
    }

    public static byte[] writeValueAsBytes(JsonNode json) throws InvalidParseOperationException {
        try {
            ParametersChecker.checkParameter("json", json);
            return OBJECT_MAPPER.writeValueAsBytes((Object)json);
        }
        catch (IOException e) {
            throw new InvalidParseOperationException(e);
        }
    }

    public static void removeFieldFromNode(JsonNode sourceNode, String fieldToExclude, JsonNode nodeValue) {
        if (nodeValue instanceof ObjectNode) {
            JsonNode var = sourceNode.findParent(fieldToExclude);
            if (!JsonHandler.isNullOrEmpty(var)) {
                ((ObjectNode)var).remove(fieldToExclude);
            }
        } else if (nodeValue instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)nodeValue;
            for (int i = 0; i < array.size(); ++i) {
                JsonHandler.removeFieldFromNode(sourceNode, fieldToExclude, array.get(i));
            }
        } else if (!sourceNode.path(fieldToExclude).isMissingNode()) {
            ((ObjectNode)sourceNode.findParent(fieldToExclude)).remove(fieldToExclude);
        }
    }

    public static boolean isTextNodeNullOrEmpty(JsonNode jsonNode) {
        return jsonNode != null && jsonNode.isTextual() && !jsonNode.asText().trim().isEmpty();
    }

    static {
        OBJECT_MAPPER_UNPRETTY.disable(SerializationFeature.INDENT_OUTPUT);
        OBJECT_MAPPER_LOWER_CAMEL_CASE = JsonHandler.buildObjectMapper();
        OBJECT_MAPPER_LOWER_CAMEL_CASE.setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE);
        OBJECT_MAPPER_LOWER_CAMEL_CASE.disable(SerializationFeature.INDENT_OUTPUT);
        STRICT_OBJECT_MAPPER = JsonHandler.buildObjectMapper();
        STRICT_OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        STRICT_OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, true);
        STRICT_OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, true);
        STRICT_OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true);
        STRICT_OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, true);
        STRICT_OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true);
        STRICT_OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, false);
        STRICT_OBJECT_MAPPER.configure(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS, false);
    }
}

