/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Difference<T> {
    private static final String empty = "EMPTY";
    @JsonProperty(value="Name")
    public final String name;
    @JsonProperty(value="Changes")
    public final List<DiffNode<T>> changes;

    public Difference(String name, List<DiffNode<T>> changes) {
        this.name = name;
        this.changes = changes;
    }

    public Difference(String name) {
        this.name = name;
        this.changes = new ArrayList<DiffNode<T>>();
    }

    public static Difference empty() {
        return new Difference(empty, Collections.emptyList());
    }

    public String getName() {
        return this.name;
    }

    public boolean hasNoDifference() {
        return this.changes.stream().allMatch(DiffNode::isEmpty);
    }

    public boolean hasDifference() {
        return !this.hasNoDifference();
    }

    public boolean add(String key, T oldValue, T newValue) {
        return this.changes.add(new DiffNode<T>(key, oldValue, newValue));
    }

    public boolean addAll(Collection<DiffNode<T>> diffNodes) {
        return this.changes.addAll(diffNodes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Difference that = (Difference)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.changes, that.changes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.changes);
    }

    public static class DiffNode<T> {
        public final String metadataName;
        public final T oldMetadataValue;
        public final T newMetadataValue;

        public DiffNode(String metadataName, T oldMetadataValue, T newMetadataValue) {
            this.metadataName = metadataName;
            this.oldMetadataValue = oldMetadataValue;
            this.newMetadataValue = newMetadataValue;
        }

        public static DiffNode empty() {
            return new DiffNode<Object>(null, null, null);
        }

        @JsonIgnore
        public boolean isEmpty() {
            return this.metadataName == null && this.oldMetadataValue == null && this.newMetadataValue == null;
        }

        @JsonIgnore
        public boolean isNotEmpty() {
            return !this.isEmpty();
        }

        public String getMetadataName() {
            return this.metadataName;
        }

        public T getOldMetadataValue() {
            return this.oldMetadataValue;
        }

        public T getNewMetadataValue() {
            return this.newMetadataValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiffNode diffNode = (DiffNode)o;
            return Objects.equals(this.metadataName, diffNode.metadataName) && Objects.equals(this.oldMetadataValue, diffNode.oldMetadataValue) && Objects.equals(this.newMetadataValue, diffNode.newMetadataValue);
        }

        public int hashCode() {
            return Objects.hash(this.metadataName, this.oldMetadataValue, this.newMetadataValue);
        }
    }
}

