/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.i18n;

import fr.gouv.vitam.common.i18n.Messages;
import fr.gouv.vitam.common.model.StatusCode;
import java.util.Locale;
import java.util.Map;

public class VitamLogbookMessages {
    private static final String DEFAULT_PROPERTY_FILENAME = "vitam-logbook-messages";
    private static final VitamLogbookMessages VITAM_MESSAGES = new VitamLogbookMessages();
    private static final String SEPARATOR = ".";
    private static final String LIFECYCLE = "LFC";
    private static final String STARTED = "STARTED";
    final Messages messages;

    private VitamLogbookMessages() {
        this(DEFAULT_PROPERTY_FILENAME);
    }

    private VitamLogbookMessages(String propertyFilename) {
        this(propertyFilename, Messages.DEFAULT_LOCALE);
    }

    private VitamLogbookMessages(String propertyFilename, Locale locale) {
        this.messages = new Messages(propertyFilename, locale);
    }

    public static Map<String, String> getAllMessages() {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getAllMessages();
    }

    public static final String getLabelOp(String stepOrHandler) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(stepOrHandler, new Object[0]);
    }

    public static final String getLabelLfc(String stepOrHandler) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(VitamLogbookMessages.getEventTypeLfc(stepOrHandler), new Object[0]);
    }

    public static final String getEventTypeStarted(String stepOrHandler) {
        return stepOrHandler + ".STARTED";
    }

    public static final String getEventTypeLfc(String stepOrHandler) {
        return "LFC." + stepOrHandler;
    }

    public static final String getSubTaskEventTypeLfc(String stepOrHandler, String subTaskName) {
        return "LFC." + stepOrHandler + SEPARATOR + subTaskName;
    }

    public static final String getSubTaskEventTypeOp(String stepOrHandler, String subTaskName) {
        return stepOrHandler + SEPARATOR + subTaskName;
    }

    public static final String getLabelOp(String stepOrHandler, String transaction) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(stepOrHandler + SEPARATOR + transaction, new Object[0]);
    }

    public static final String getLabelLfc(String stepOrHandler, String transaction) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(VitamLogbookMessages.getEventTypeLfc(stepOrHandler) + SEPARATOR + transaction, new Object[0]);
    }

    public static final String getOutcomeDetail(String stepOrHandler, StatusCode code) {
        return stepOrHandler + SEPARATOR + code;
    }

    public static final String getOutcomeDetailLfc(String stepOrHandler, StatusCode code) {
        return VitamLogbookMessages.getEventTypeLfc(stepOrHandler) + SEPARATOR + code;
    }

    public static final String getOutcomeDetail(String stepOrHandler, String transaction, StatusCode code) {
        return stepOrHandler + SEPARATOR + transaction + SEPARATOR + code;
    }

    public static final String getOutcomeDetailLfc(String stepOrHandler, String transaction, String detailedOutcome, StatusCode code) {
        return VitamLogbookMessages.getEventTypeLfc(stepOrHandler) + SEPARATOR + transaction + SEPARATOR + detailedOutcome + SEPARATOR + code;
    }

    public static final String getOutcomeDetailLfc(String stepOrHandler, String transaction, StatusCode code) {
        return VitamLogbookMessages.getEventTypeLfc(stepOrHandler) + SEPARATOR + transaction + SEPARATOR + code;
    }

    public static final String getCodeOp(String stepOrHandler, StatusCode code) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(VitamLogbookMessages.getOutcomeDetail(stepOrHandler, code), new Object[0]);
    }

    public static final String getCodeLfc(String stepOrHandler, StatusCode code) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(VitamLogbookMessages.getOutcomeDetailLfc(stepOrHandler, code), new Object[0]);
    }

    public static final String getCodeOp(String stepOrHandler, String transaction, StatusCode code) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(VitamLogbookMessages.getOutcomeDetail(stepOrHandler, transaction, code), new Object[0]);
    }

    public static final String getCodeLfc(String stepOrHandler, String transaction, StatusCode code) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(VitamLogbookMessages.getOutcomeDetailLfc(stepOrHandler, transaction, code), new Object[0]);
    }

    public static final String getCodeOp(String stepOrHandler, StatusCode code, Object ... args) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(VitamLogbookMessages.getOutcomeDetail(stepOrHandler, code), args);
    }

    public static final String getCodeLfc(String stepOrHandler, StatusCode code, Object ... args) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(VitamLogbookMessages.getOutcomeDetailLfc(stepOrHandler, code), args);
    }

    public static final String getCodeOp(String stepOrHandler, String transaction, StatusCode code, Object ... args) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(VitamLogbookMessages.getOutcomeDetail(stepOrHandler, transaction, code), args);
    }

    public static final String getCodeLfc(String stepOrHandler, String transaction, StatusCode code, Object ... args) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(VitamLogbookMessages.getOutcomeDetailLfc(stepOrHandler, transaction, code), args);
    }

    public static final String getCodeLfc(String stepOrHandler, String transaction, String detailedOutcome, StatusCode code, Object ... args) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(VitamLogbookMessages.getOutcomeDetailLfc(stepOrHandler, transaction, detailedOutcome, code), args);
    }

    public static final String getFromFullCodeKey(String completeCodeKey) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(completeCodeKey, new Object[0]);
    }

    public static final String getFromFullCodeKey(String completeCodeKey, Object ... args) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.getStringNotEmpty(completeCodeKey, args);
    }

    public static final String getSeparator() {
        return SEPARATOR;
    }

    public static final boolean containsKey(String key) {
        return VitamLogbookMessages.VITAM_MESSAGES.messages.containsKey(key);
    }
}

