/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.guid;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.common.BaseXx;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.guid.GUID;
import java.util.Arrays;

abstract class GUIDAbstract
implements GUID {
    public static final String ARK = "ark:/";
    @JsonIgnore
    final byte[] guid;

    GUIDAbstract(int size) {
        this.guid = new byte[size];
    }

    @JsonIgnore
    GUIDAbstract setBytes(byte[] bytes, int size) throws InvalidGuidOperationException {
        if (bytes == null) {
            throw new InvalidGuidOperationException("Empty argument");
        }
        if (bytes.length != size) {
            throw new InvalidGuidOperationException("Attempted to parse malformed GUID: (" + bytes.length + ") " + Arrays.toString(bytes));
        }
        System.arraycopy(bytes, 0, this.guid, 0, size);
        return this;
    }

    @Override
    @JsonIgnore
    public String toBase32() {
        return BaseXx.getBase32(this.guid);
    }

    @Override
    @JsonIgnore
    public String toBase64() {
        return BaseXx.getBase64UrlWithoutPadding(this.guid);
    }

    @Override
    @JsonIgnore
    public String toHex() {
        return BaseXx.getBase16(this.guid);
    }

    @Override
    @JsonIgnore
    public String toArk() {
        return ARK + this.getTenantId() + '/' + this.toArkName();
    }

    @Override
    @JsonGetter(value="id")
    public String getId() {
        return this.toString();
    }

    @Override
    public String toString() {
        return this.toBase32();
    }

    @Override
    @JsonIgnore
    public byte[] getBytes() {
        return Arrays.copyOf(this.guid, this.guid.length);
    }

    @Override
    @JsonIgnore
    public int hashCode() {
        return Arrays.hashCode(this.guid);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof GUIDAbstract)) {
            return false;
        }
        return this == o || Arrays.equals(this.guid, ((GUIDAbstract)o).guid);
    }
}

