/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.error;

import fr.gouv.vitam.common.error.DomainName;
import fr.gouv.vitam.common.error.ServiceName;
import javax.ws.rs.core.Response;

public enum VitamCode {
    TEST(ServiceName.VITAM, DomainName.TEST, "00", Response.Status.INTERNAL_SERVER_ERROR, "message or message key and parameter %s"),
    GLOBAL_INTERNAL_SERVER_ERROR(ServiceName.VITAM, DomainName.NETWORK, "00", Response.Status.INTERNAL_SERVER_ERROR, "Internal Server Error"),
    GLOBAL_EMPTY_QUERY(ServiceName.VITAM, DomainName.ILLEGAL, "00", Response.Status.FORBIDDEN, "No search query specified, this is mandatory"),
    GLOBAL_INVALID_DSL(ServiceName.VITAM, DomainName.BUSINESS, "01", Response.Status.BAD_REQUEST, "Dsl query is not valid."),
    UNAUTHORIZED_PARAMETER_DSL(ServiceName.VITAM, DomainName.BUSINESS, "02", Response.Status.BAD_REQUEST, "DSL parameter is unauthorized."),
    INTERNAL_SECURITY_UNAUTHORIZED(ServiceName.VITAM, DomainName.SECURITY, "00", Response.Status.UNAUTHORIZED, "Internal Security Filter Unauthorized"),
    STORAGE_MISSING_HEADER(ServiceName.STORAGE, DomainName.ILLEGAL, "00", Response.Status.PRECONDITION_FAILED, "Header are missing"),
    STORAGE_BAD_REQUEST(ServiceName.STORAGE, DomainName.ILLEGAL, "01", Response.Status.PRECONDITION_FAILED, "Storage Engine received a bad request "),
    STORAGE_STRATEGY_NOT_FOUND(ServiceName.STORAGE, DomainName.STORAGE, "02", Response.Status.NOT_FOUND, "No suitable strategy found to be able to store data"),
    STORAGE_OFFER_NOT_FOUND(ServiceName.STORAGE, DomainName.STORAGE, "03", Response.Status.NOT_FOUND, "No suitable offer found to be able to read or store data"),
    STORAGE_OBJECT_NOT_FOUND(ServiceName.STORAGE, DomainName.STORAGE, "04", Response.Status.NOT_FOUND, "Object with id %s not found in all strategy"),
    STORAGE_CANT_STORE_OBJECT(ServiceName.STORAGE, DomainName.STORAGE, "05", Response.Status.INTERNAL_SERVER_ERROR, "Could not store object with id '%s' on offers '%s'"),
    STORAGE_LOGBOOK_CANNOT_LOG(ServiceName.STORAGE, DomainName.STORAGE, "06", Response.Status.INTERNAL_SERVER_ERROR, "Operation couldnt be logged in the storage logbook"),
    STORAGE_CLIENT_UNKNOWN(ServiceName.STORAGE, DomainName.ILLEGAL, "07", Response.Status.INTERNAL_SERVER_ERROR, "Storage client type unknown"),
    STORAGE_CLIENT_STORAGE_TYPE(ServiceName.STORAGE, DomainName.ILLEGAL, "08", Response.Status.INTERNAL_SERVER_ERROR, "Type of storage object cannot be %s"),
    STORAGE_CLIENT_ALREADY_EXISTS(ServiceName.STORAGE, DomainName.ILLEGAL, "09", Response.Status.CONFLICT, "%s"),
    STORAGE_DRIVER_MAPPER_FILE_CONTENT(ServiceName.STORAGE, DomainName.IO, "10", Response.Status.INTERNAL_SERVER_ERROR, "Cannot retrieve file content for driver %s, that's an error !"),
    STORAGE_DRIVER_MAPPING_SAVE(ServiceName.STORAGE, DomainName.IO, "11", Response.Status.INTERNAL_SERVER_ERROR, "Cannot save driver %s mapping !"),
    STORAGE_DRIVER_MAPPING_INITIALIZE(ServiceName.STORAGE, DomainName.IO, "12", Response.Status.INTERNAL_SERVER_ERROR, "Cannot initialize FileDriverMapper, error on configuration file, please check it"),
    STORAGE_DRIVER_OBJECT_ALREADY_EXISTS(ServiceName.STORAGE, DomainName.ILLEGAL, "13", Response.Status.CONFLICT, "Cannot override an existing object (%s)"),
    STORAGE_CONTAINER_NOT_FOUND(ServiceName.STORAGE, DomainName.STORAGE, "14", Response.Status.NOT_FOUND, "Container with name %s not found in all strategy"),
    STORAGE_GET_OFFER_LOG_ERROR(ServiceName.STORAGE, DomainName.STORAGE, "15", Response.Status.INTERNAL_SERVER_ERROR, "Cannot retrieve objects stored on container"),
    STORAGE_NOT_FOUND(ServiceName.STORAGE, DomainName.STORAGE, "16", Response.Status.NOT_FOUND, "Storage not found"),
    STORAGE_TECHNICAL_INTERNAL_ERROR(ServiceName.STORAGE, DomainName.STORAGE, "17", Response.Status.INTERNAL_SERVER_ERROR, "Storage technical error"),
    STORAG_EMPTY_PARAMTER(ServiceName.STORAGE, DomainName.STORAGE, "18", Response.Status.PRECONDITION_FAILED, "No offer identifier specified, this is mandatory"),
    STORAGE_INCONSISTENT_STATE(ServiceName.STORAGE, DomainName.STORAGE, "19", Response.Status.CONFLICT, "Inconsistent state"),
    STORAGE_GET_READ_ORDER_ERROR(ServiceName.STORAGE, DomainName.STORAGE, "20", Response.Status.INTERNAL_SERVER_ERROR, "Cannot retrieve read order request"),
    STORAGE_CREATE_READ_ORDER_ERROR(ServiceName.STORAGE, DomainName.STORAGE, "21", Response.Status.INTERNAL_SERVER_ERROR, "Cannot create read order request"),
    STORAGE_INVALID_ADMIN_TENANT(ServiceName.STORAGE, DomainName.STORAGE, "22", Response.Status.BAD_REQUEST, "Expected admin tenant"),
    STORAGE_INVALID_TENANT_LIST(ServiceName.STORAGE, DomainName.STORAGE, "23", Response.Status.BAD_REQUEST, "Missing or invalid tenant list"),
    STORAGE_ILLEGAL_OPERATION(ServiceName.STORAGE, DomainName.STORAGE, "24", Response.Status.NOT_ACCEPTABLE, "Illegal operation"),
    STORAGE_OFFER_EXCEPTION_RANK(ServiceName.STORAGE, DomainName.STORAGE, "25", Response.Status.NOT_FOUND, "A duplicated or missing rank have been detected in offers configuration."),
    STORAGE_ILLEGAL_WRITE_ON_SECONDARY_SITE(ServiceName.VITAM, DomainName.STORAGE, "24", Response.Status.UNAUTHORIZED, "Illegal Write API invocation on secondary site"),
    WORKSPACE_NOT_ACCEPTABLE_FILES(ServiceName.WORKSPACE, DomainName.STORAGE, "14", Response.Status.NOT_ACCEPTABLE, "File or folder name not authorized"),
    WORKSPACE_BAD_REQUEST(ServiceName.WORKSPACE, DomainName.STORAGE, "15", Response.Status.BAD_REQUEST, "Bad request"),
    WORKER_FORMAT_IDENTIFIER_NOT_FOUND(ServiceName.WORKER, DomainName.IO, "00", Response.Status.NOT_FOUND, "Format identifier %s not found"),
    WORKER_FORMAT_IDENTIFIER_IMPLEMENTATION_NOT_FOUND(ServiceName.WORKER, DomainName.IO, "01", Response.Status.NOT_FOUND, "Format identifier %s implementation not found"),
    WORKER_FORMAT_IDENTIFIER_TECHNICAL_INTERNAL_ERROR(ServiceName.WORKER, DomainName.IO, "02", Response.Status.INTERNAL_SERVER_ERROR, "Format identifier internal error"),
    WORKFLOW_DEFINITION_ERROR(ServiceName.PROCESSING, DomainName.VALIDATION, "00", Response.Status.INTERNAL_SERVER_ERROR, "Find workflow definitions in error"),
    WORKFLOW_PROCESSES_ERROR(ServiceName.PROCESSING, DomainName.VALIDATION, "01", Response.Status.INTERNAL_SERVER_ERROR, "Find workflow processes in error"),
    CONTRACT_VALIDATION_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "08", Response.Status.BAD_REQUEST, "Request validation error"),
    PROFILE_VALIDATION_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "09", Response.Status.BAD_REQUEST, "Request profile validation error"),
    PROFILE_FILE_IMPORT_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "10", Response.Status.BAD_REQUEST, "Request profile file import error"),
    CONTRACT_NOT_FOUND_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "11", Response.Status.BAD_REQUEST, "Contract not found for update"),
    CONTEXT_VALIDATION_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "12", Response.Status.BAD_REQUEST, "Request context validation error"),
    AGENCIES_VALIDATION_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "13", Response.Status.BAD_REQUEST, "Request agency validation error"),
    PRESERVATION_VALIDATION_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "50", Response.Status.BAD_REQUEST, "Request griffin validation error"),
    PRESERVATION_INTERNAL_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "51", Response.Status.INTERNAL_SERVER_ERROR, "Request griffin validation error"),
    SECURITY_PROFILE_VALIDATION_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "14", Response.Status.BAD_REQUEST, "Security profile request validation error"),
    ARCHIVE_UNIT_PROFILE_VALIDATION_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "15", Response.Status.BAD_REQUEST, "Request archive unit profile validation error"),
    ARCHIVE_UNIT_PROFILE_FILE_IMPORT_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "16", Response.Status.BAD_REQUEST, "Request archive unit profile file import error"),
    ONTOLOGY_IMPORT_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "17", Response.Status.BAD_REQUEST, "Ontology file import error"),
    ONTOLOGY_VALIDATION_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "18", Response.Status.BAD_REQUEST, "Request ontology validation error"),
    CTR_SHEMA_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "19", Response.Status.BAD_REQUEST, "Json Schema validation error"),
    ONTOLOGY_CHECK_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "20", Response.Status.BAD_REQUEST, "Ontology check mode error"),
    REFERENTIAL_REPOSITORY_DATABASE_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.DATABASE, "15", Response.Status.INTERNAL_SERVER_ERROR, "DatabaseException while accessing database through repository service"),
    REFERENTIAL_NOT_FOUND(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.DATABASE, "03", Response.Status.NOT_FOUND, "Referential not found"),
    ACCESS_EXTERNAL_SELECT_UNITS_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "00", Response.Status.BAD_REQUEST, "Access external client error in selectUnits method."),
    COLLECT_EXTERNAL_SELECT_UNITS_ERROR(ServiceName.COLLECT_EXTERNAL_ACCESS, DomainName.IO, "00", Response.Status.BAD_REQUEST, "Collect external client error in selectUnits method."),
    ACCESS_EXTERNAL_SELECT_UNIT_BY_ID_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "01", Response.Status.BAD_REQUEST, "Access external client error in selectUnitbyId method."),
    ACCESS_EXTERNAL_UPDATE_UNIT_BY_ID_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "02", Response.Status.BAD_REQUEST, "Access external client error in updateUnitbyId method."),
    ACCESS_EXTERNAL_SELECT_OBJECTS_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "49", Response.Status.BAD_REQUEST, "Access external client error in selectObjects method."),
    ACCESS_EXTERNAL_SELECT_OBJECT_BY_ID_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "03", Response.Status.BAD_REQUEST, "Access external client error in selectObjectById method."),
    ACCESS_EXTERNAL_SELECT_OPERATION_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "04", Response.Status.BAD_REQUEST, "Access external client error in selectOperation method."),
    ACCESS_EXTERNAL_SELECT_OPERATION_BY_ID_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "05", Response.Status.BAD_REQUEST, "Access external client error in selectOperationbyId method."),
    ACCESS_EXTERNAL_SELECT_UNIT_LIFECYCLE_BY_ID_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "06", Response.Status.BAD_REQUEST, "Access external client error in selectUnitLifeCycleById method."),
    ACCESS_EXTERNAL_SELECT_UNIT_LIFECYCLE_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "07", Response.Status.BAD_REQUEST, "Access external client error in selectUnitLifeCycle method."),
    ACCESS_EXTERNAL_SELECT_OBJECT_GROUP_LIFECYCLE_BY_ID_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "08", Response.Status.BAD_REQUEST, "Access external client error in selectObjectGroupLifeCycleById method."),
    ACCESS_EXTERNAL_SELECT_OBJECT_GROUP_LIFECYCLE_PERMISSION(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "16", Response.Status.UNAUTHORIZED, "Unauthorized to access objects group lifecycle"),
    ACCESS_EXTERNAL_SELECT_UNIT_LIFECYCLE_PERMISSION(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "17", Response.Status.UNAUTHORIZED, "Unauthorized to access archive units lifecycle"),
    ACCESS_EXTERNAL_GET_ACCESSION_REGISTER_SUMMARY_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "09", Response.Status.BAD_REQUEST, "Access external client error in getAccessionRegisterSummary method."),
    ACCESS_EXTERNAL_GET_ACCESSION_REGISTER_DETAIL_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "10", Response.Status.BAD_REQUEST, "Access external client error in getAccessionRegisterSummary method."),
    ACCESS_EXTERNAL_CHECK_TRACEABILITY_OPERATION_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "11", Response.Status.BAD_REQUEST, "Access external client error in checkTraceabilityOperation method."),
    ACCESS_EXTERNAL_SERVER_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "12", Response.Status.INTERNAL_SERVER_ERROR, "Access external server error."),
    ACCESS_EXTERNAL_CLIENT_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "13", Response.Status.INTERNAL_SERVER_ERROR, "Access external client not found."),
    ACCESS_EXTERNAL_GET_ACCESSION_REGISTER_SYMBOLIC_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "66", Response.Status.BAD_REQUEST, "Access external client error in getAccessionRegisterSymbolic method."),
    ACCESS_EXTERNAL_GET_GET_GRIFFIN_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "67", Response.Status.BAD_REQUEST, "Access external client in getting griffin."),
    ACCESS_EXTERNAL_MASS_UPDATE_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "40", Response.Status.BAD_REQUEST, "Access external client error in the mass update units method."),
    ACCESS_EXTERNAL_MASS_UPDATE_UNITS_NOT_FOUND(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "41", Response.Status.NOT_FOUND, "Access external client error mass update units not found."),
    ACCESS_EXTERNAL_GET_ACCESS_LOG(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "42", Response.Status.BAD_REQUEST, "Access external client error in getAccessLog method."),
    ACCESS_INTERNAL_MASS_UPDATE_UNITS_CHECK_RULES(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "42", Response.Status.BAD_REQUEST, "Access internal error while check mass update units on rules"),
    INTERNAL_SECURITY_MASS_UPDATE_AUTHORIZATION_REJECTED(ServiceName.VITAM, DomainName.SECURITY, "43", Response.Status.UNAUTHORIZED, "Internal Security Filter Mass Update of units Unauthorized"),
    INTERNAL_SECURITY_MASS_UPDATE_MANAGEMENT_UNAUTHORIZED(ServiceName.VITAM, DomainName.SECURITY, "44", Response.Status.UNAUTHORIZED, "Update management data is Unauthorized"),
    INTERNAL_SECURITY_MASS_UPDATE_GRAPH_UNAUTHORIZED(ServiceName.VITAM, DomainName.SECURITY, "45", Response.Status.UNAUTHORIZED, "Update graph is Unauthorized"),
    INTERNAL_SECURITY_MASS_UPDATE_INTERNAL_DATA_UNAUTHORIZED(ServiceName.VITAM, DomainName.SECURITY, "46", Response.Status.UNAUTHORIZED, "Update internal data is Unauthorized"),
    ADMIN_EXTERNAL_FIND_DOCUMENT_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "14", Response.Status.BAD_REQUEST, "Admin external client error in findDocuments method."),
    ADMIN_EXTERNAL_FIND_DOCUMENT_BY_ID_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "15", Response.Status.BAD_REQUEST, "Admin external client error in findDocumentById method."),
    ADMIN_EXTERNAL_CHECK_DOCUMENT_BAD_REQUEST(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "16", Response.Status.BAD_REQUEST, "Admin external bad request error in checkDocument method."),
    ADMIN_EXTERNAL_CHECK_DOCUMENT_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "17", Response.Status.INTERNAL_SERVER_ERROR, "Admin external internal server error in checkDocument method."),
    ADMIN_EXTERNAL_CHECK_DOCUMENT_NOT_FOUND(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "18", Response.Status.NOT_FOUND, "Admin external not found error in checkDocument method."),
    ACCESS_EXTERNAL_SELECT_DATA_OBJECT_BY_UNIT_ID_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "19", Response.Status.BAD_REQUEST, "Access external client error in getDataObjectByUnitId method."),
    ADMIN_EXTERNAL_BAD_REQUEST(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "20", Response.Status.BAD_REQUEST, "Admin external bad request error"),
    ADMIN_EXTERNAL_PRECONDITION_FAILED(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "21", Response.Status.PRECONDITION_FAILED, "Admin external precondition failed error"),
    ADMIN_EXTERNAL_NOT_FOUND(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "22", Response.Status.NOT_FOUND, "Admin external not found error"),
    ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "23", Response.Status.INTERNAL_SERVER_ERROR, "Admin external internal server error"),
    ADMIN_EXTERNAL_UPDATE_PROFILE_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "24", Response.Status.BAD_REQUEST, "Admin external client error in updateProfile method."),
    ADMIN_EXTERNAL_UPDATE_CONTEXT_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "25", Response.Status.BAD_REQUEST, "Admin external client error in updateContext method."),
    ADMIN_EXTERNAL_UPDATE_SECURITY_PROFILE_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "26", Response.Status.BAD_REQUEST, "Admin external client error in updateSecurityProfile method."),
    ADMIN_EXTERNAL_UPDATE_ACCESS_CONTRACT_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "27", Response.Status.BAD_REQUEST, "Admin external client error in updateAccessContract method."),
    ADMIN_EXTERNAL_UPDATE_INGEST_CONTRACT_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "28", Response.Status.BAD_REQUEST, "Admin external client error in updateIngestContract method."),
    ADMIN_EXTERNAL_UNAUTHORIZED(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "29", Response.Status.UNAUTHORIZED, "Admin external client error unauthorized method by access contract."),
    ADMIN_EXTERNAL_CONFLICT(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "51", Response.Status.CONFLICT, "Admin external client error already existing object"),
    ADMIN_EXTERNAL_FORBIDDEN(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "52", Response.Status.FORBIDDEN, "Admin external client error forbidden action"),
    ADMIN_EXTERNAL_UPDATE_ONTOLOGY_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "37", Response.Status.BAD_REQUEST, "Admin external client error in updateOntology method."),
    ADMIN_EXTERNAL_UPDATE_MANAGEMENT_CONTRACT_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "39", Response.Status.BAD_REQUEST, "Admin external client error in updateManagementContract method."),
    ACCESS_EXTERNAL_UNIT_NOT_FOUND(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "50", Response.Status.NOT_FOUND, "Access external client error unit not found."),
    ACCESS_EXTERNAL_CONTEXT_NOT_FOUND(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "30", Response.Status.NOT_FOUND, "Access external client error, context not found"),
    ACCESS_EXTERNAL_PROFILE_NOT_FOUND(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "31", Response.Status.NOT_FOUND, "Access external client error, profile not found"),
    ACCESS_EXTERNAL_SECURITY_PROFILE_NOT_FOUND(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "32", Response.Status.NOT_FOUND, "Access external client error, security profile not found"),
    ACCESS_EXTERNAL_UNIT_TRACREABILITY_AUDIT(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "33", Response.Status.BAD_REQUEST, "Access external client error. Unit traceability audit service "),
    ACCESS_EXTERNAL_OBJECT_GROUP_TRACREABILITY_AUDIT(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "34", Response.Status.BAD_REQUEST, "Access external client error. Object group traceability audit service "),
    ACCESS_EXTERNAL_INVALID_JSON(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "35", Response.Status.BAD_REQUEST, "Access external client error. JSON is invalid"),
    ACCESS_EXTERNAL_ONTOLOGY_NOT_FOUND(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "36", Response.Status.BAD_REQUEST, "Access external client error. Ontology not found "),
    ACCESS_EXTERNAL_SELECT_UNITS_WITH_INHERITED_RULES_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "38", Response.Status.BAD_REQUEST, "Access external client error in selectUnitsWithInheritedRules method."),
    ACCESS_EXTERNAL_BULK_ATOMIC_UPDATE_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "53", Response.Status.BAD_REQUEST, "Access external client error in the bulk atomic update units method."),
    ACCESS_EXTERNAL_CREATE_OBJECT_ACCESS_REQUEST(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "55", Response.Status.BAD_REQUEST, "Access external client error while creating object Access Request."),
    ACCESS_EXTERNAL_CHECK_OBJECT_ACCESS_REQUEST_STATUSES(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "56", Response.Status.BAD_REQUEST, "Access external client error while checking Access Request statuses."),
    ACCESS_EXTERNAL_REMOVE_OBJECT_ACCESS_REQUEST(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "57", Response.Status.BAD_REQUEST, "Access external client error while removing Access Request."),
    ACCESS_INTERNAL_UPDATE_UNIT_CHECK_RULES(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "01", Response.Status.BAD_REQUEST, "Access internal error while check update on rules"),
    ACCESS_INTERNAL_UPDATE_UNIT_DELETE_CATEGORY_INHERITANCE(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "02", Response.Status.BAD_REQUEST, "Access internal error while check update on rules: Can't delete rule category that prevent inheritance"),
    ACCESS_INTERNAL_UPDATE_UNIT_UPDATE_RULE_END_DATE(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "03", Response.Status.BAD_REQUEST, "Access internal error while check update on rules: Can't update rule with a given EndDate"),
    ACCESS_INTERNAL_UPDATE_UNIT_UPDATE_BAD_FORMAT(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "39", Response.Status.BAD_REQUEST, "Bad format ! You can either do {\"#management.CategoryRule.Rules\":[...]} or {\"#management.CategoryRule\":{\"Rules\":[...]}}"),
    ACCESS_INTERNAL_UPDATE_UNIT_UPDATE_RULE_FINAL_ACTION(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "04", Response.Status.BAD_REQUEST, "Access internal error while check update on rules: Can't update rule with a wrong FinalAction"),
    ACCESS_INTERNAL_UPDATE_UNIT_UPDATE_RULE_EXIST(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "05", Response.Status.BAD_REQUEST, "Access internal error while check update on rules: Can't update rule with an unknow RuleID"),
    ACCESS_INTERNAL_UPDATE_UNIT_UPDATE_RULE_CATEGORY(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "06", Response.Status.BAD_REQUEST, "Access internal error while check update on rules: Can't update rule with a wrong category"),
    ACCESS_INTERNAL_UPDATE_UNIT_CREATE_RULE_END_DATE(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "07", Response.Status.BAD_REQUEST, "Access internal error while check update on rules: Can't create rule with a given EndDate"),
    ACCESS_INTERNAL_UPDATE_UNIT_CREATE_RULE_FINAL_ACTION(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "08", Response.Status.BAD_REQUEST, "Access internal error while check update on rules: Can't create rule with a wrong FinalAction"),
    ACCESS_INTERNAL_UPDATE_UNIT_CREATE_RULE_EXIST(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "09", Response.Status.BAD_REQUEST, "Access internal error while check update on rules: Can't create rule with an unknow RuleID"),
    ACCESS_INTERNAL_UPDATE_UNIT_CREATE_RULE_CATEGORY(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "10", Response.Status.BAD_REQUEST, "Access internal error while check update on rules: Can't create rule with a wrong category"),
    ACCESS_INTERNAL_UPDATE_UNIT_CREATE_RULE_START_DATE(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "11", Response.Status.BAD_REQUEST, "Access internal error while check update on rules: Can't create rule with a startDate > 9000"),
    ACCESS_INTERNAL_UPDATE_UNIT_UPDATE_RULE_START_DATE(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "12", Response.Status.BAD_REQUEST, "Access internal error while check update on rules: Can't update rule with a startDate > 9000"),
    ACCESS_INTERNAL_DIP_ERROR(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "13", Response.Status.BAD_REQUEST, "Access internal client error in DIP service"),
    UPDATE_UNIT_PERMISSION(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "14", Response.Status.UNAUTHORIZED, "Unauthorized to update archive units"),
    UPDATE_UNIT_DESC_PERMISSION(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "15", Response.Status.UNAUTHORIZED, "Unauthorized to update other than descriptive metadata in archive units"),
    UPDATE_UNIT_RULES_CONSISTENCY(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "18", Response.Status.UNAUTHORIZED, "Unauthorized to update rules: Bad ID or wrong category"),
    UPDATE_UNIT_RULES_PROPERTY_CONSISTENCY(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "19", Response.Status.UNAUTHORIZED, "Unauthorized to update rules: Incorrect value for a property"),
    UPDATE_UNIT_MANAGEMENT_METADATA_CONSISTENCY(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "20", Response.Status.UNAUTHORIZED, "Unauthorized to update management metadata: Incorrect property value"),
    UPDATE_UNIT_RULES_QUERY_CONSISTENCY(ServiceName.INTERNAL_ACCESS, DomainName.BUSINESS, "21", Response.Status.BAD_REQUEST, "Request incorrect: Illegal use of properties"),
    INGEST_EXTERNAL_ILLEGAL_ARGUMENT(ServiceName.EXTERNAL_INGEST, DomainName.IO, "00", Response.Status.PRECONDITION_FAILED, "Ingest external illegal argument"),
    INGEST_EXTERNAL_PRECONDITION_FAILED(ServiceName.EXTERNAL_INGEST, DomainName.IO, "01", Response.Status.PRECONDITION_FAILED, "Ingest external precondition failed"),
    INGEST_EXTERNAL_NOT_FOUND(ServiceName.EXTERNAL_INGEST, DomainName.IO, "02", Response.Status.NOT_FOUND, "Ingest external not found"),
    INGEST_EXTERNAL_UNAUTHORIZED(ServiceName.EXTERNAL_INGEST, DomainName.IO, "03", Response.Status.UNAUTHORIZED, "Ingest external unauthorized"),
    INGEST_EXTERNAL_BAD_REQUEST(ServiceName.EXTERNAL_INGEST, DomainName.IO, "04", Response.Status.BAD_REQUEST, "Ingest external bad request"),
    INGEST_EXTERNAL_INTERNAL_SERVER_ERROR(ServiceName.EXTERNAL_INGEST, DomainName.IO, "05", Response.Status.INTERNAL_SERVER_ERROR, "Ingest external internal server error"),
    INGEST_EXTERNAL_INTERNAL_CLIENT_ERROR(ServiceName.EXTERNAL_INGEST, DomainName.IO, "06", Response.Status.INTERNAL_SERVER_ERROR, "Ingest external internal client error"),
    INGEST_EXTERNAL_UPLOAD_ERROR(ServiceName.EXTERNAL_INGEST, DomainName.IO, "07", Response.Status.BAD_REQUEST, "Ingest external client error in upload method."),
    INGEST_EXTERNAL_EXECUTE_OPERATION_PROCESS_ERROR(ServiceName.EXTERNAL_INGEST, DomainName.IO, "08", Response.Status.BAD_REQUEST, "Ingest external client error in executeOperationProcess method."),
    INGEST_EXTERNAL_GET_OPERATION_PROCESS_DETAIL_ERROR(ServiceName.EXTERNAL_INGEST, DomainName.IO, "09", Response.Status.BAD_REQUEST, "Ingest external client error in getOperationProcessExecutionDetails method."),
    INGEST_EXTERNAL_LOCAL_UPLOAD_FILE_HANDLING_ERROR(ServiceName.EXTERNAL_INGEST, DomainName.IO, "10", Response.Status.BAD_REQUEST, "File error during local ingest attempt."),
    INGEST_EXTERNAL_LOCAL_UPLOAD_FILE_SECURITY_ALERT(ServiceName.EXTERNAL_INGEST, DomainName.IO, "11", Response.Status.BAD_REQUEST, "Security alert during local ingest attempt."),
    METADATA_INDEXATION_ERROR(ServiceName.METADATA, DomainName.DATABASE, "00", Response.Status.INTERNAL_SERVER_ERROR, "Indexation error"),
    METADATA_SWITCH_INDEX_ERROR(ServiceName.METADATA, DomainName.DATABASE, "01", Response.Status.INTERNAL_SERVER_ERROR, "Switch index error"),
    METADATA_REPOSITORY_DATABASE_ERROR(ServiceName.METADATA, DomainName.DATABASE, "02", Response.Status.INTERNAL_SERVER_ERROR, "DatabaseException while accessing database through repository service"),
    METADATA_NOT_FOUND(ServiceName.METADATA, DomainName.DATABASE, "03", Response.Status.NOT_FOUND, "Metadata not found"),
    METADATA_INTERNAL_SERVER_ERROR(ServiceName.METADATA, DomainName.DATABASE, "04", Response.Status.INTERNAL_SERVER_ERROR, "Metadata internal server error"),
    DATA_CONSISTENCY_AUDIT_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.DATABASE, "05", Response.Status.BAD_REQUEST, "Access external client error in auditDataConsistency method."),
    LOGBOOK_EXTERNAL_INTERNAL_SERVER_ERROR(ServiceName.LOGBOOK, DomainName.NETWORK, "O0", Response.Status.INTERNAL_SERVER_ERROR, "Logbook client error"),
    LOGBOOK_EXTERNAL_BAD_REQUEST(ServiceName.LOGBOOK, DomainName.BUSINESS, "O1", Response.Status.BAD_REQUEST, "Logbook operation is not correct"),
    LOGBOOK_EXTERNAL_CONFLICT(ServiceName.LOGBOOK, DomainName.ILLEGAL, "O2", Response.Status.CONFLICT, "Logbook operation already exists"),
    ACCESS_EXTERNAL_REVERT_UPDATE_ERROR(ServiceName.EXTERNAL_ACCESS, DomainName.IO, "47", Response.Status.BAD_REQUEST, "Access external client error in the revert update units method."),
    SCHEMA_CHECK_ERROR(ServiceName.FUNCTIONAL_ADMINISTRATION, DomainName.VALIDATION, "48", Response.Status.BAD_REQUEST, "Schema check mode error");

    private final ServiceName service;
    private final DomainName domain;
    private final String item;
    private final Response.Status status;
    private final String message;

    private VitamCode(ServiceName service, DomainName domain, String item, Response.Status status, String message) {
        this.service = service;
        this.domain = domain;
        this.item = item;
        this.status = status;
        this.message = message;
    }

    public ServiceName getService() {
        return this.service;
    }

    public DomainName getDomain() {
        return this.domain;
    }

    public String getItem() {
        return this.item;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }
}

