/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.collection;

import fr.gouv.vitam.common.collection.CloseableIterable;
import fr.gouv.vitam.common.collection.CloseableIterator;
import java.util.Iterator;
import java.util.function.Function;

public final class CloseableIteratorUtils {
    private CloseableIteratorUtils() {
    }

    public static <T, R> CloseableIterator<R> map(final CloseableIterator<T> closeableIterator, final Function<? super T, ? extends R> mapper) {
        return new CloseableIterator<R>(){

            @Override
            public boolean hasNext() {
                return closeableIterator.hasNext();
            }

            @Override
            public R next() {
                return mapper.apply(closeableIterator.next());
            }

            @Override
            public void close() {
                closeableIterator.close();
            }
        };
    }

    public static <E> CloseableIterator<E> toCloseableIterator(Iterator<E> iterator) {
        return new CloseableIteratorWrapper<E>(iterator);
    }

    public static <E> CloseableIterator<E> toCloseableIterator(Iterable<E> iterable) {
        return new CloseableIteratorWrapper<E>(iterable.iterator());
    }

    public static <E> CloseableIterable<E> toCloseableIterable(final CloseableIterator<E> closeableIterator) {
        return new CloseableIterable<E>(){

            @Override
            public void close() {
                closeableIterator.close();
            }

            @Override
            public Iterator<E> iterator() {
                return closeableIterator;
            }
        };
    }

    private static class CloseableIteratorWrapper<E>
    implements CloseableIterator<E> {
        private final Iterator<E> iterator;

        private CloseableIteratorWrapper(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void close() {
        }
    }
}

