/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class StringUtils {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final String CDATA_TAG_UNESCAPED = "<![CDATA[";
    private static final String CDATA_TAG_ESCAPED = "&lt;![CDATA[";
    private static final String ENTITY_TAG_UNESCAPED = "<!ENTITY";
    private static final String ENTITY_TAG_ESCAPED = "&lt;!ENTITY";
    private static final String SCRIPT_TAG_UNESCAPED = "<script>";
    private static final String SCRIPT_TAG_ESCAPED = "&lt;script&gt;";
    private static final String TAG_START = "\\<\\w+((\\s+\\w+(\\s*\\=\\s*(?:\".*?\"|'.*?'|[^'\"\\>\\s]+))?)+\\s*|\\s*)\\>";
    private static final String TAG_END = "\\</\\w+\\>";
    private static final String TAG_SELF_CLOSING = "\\<\\w+((\\s+\\w+(\\s*\\=\\s*(?:\".*?\"|'.*?'|[^'\"\\>\\s]+))?)+\\s*|\\s*)/\\>";
    private static final String HTML_ENTITY = "&[a-zA-Z][a-zA-Z0-9]+;";
    public static final Pattern HTML_PATTERN = Pattern.compile("(\\<\\w+((\\s+\\w+(\\s*\\=\\s*(?:\".*?\"|'.*?'|[^'\"\\>\\s]+))?)+\\s*|\\s*)\\>.*\\</\\w+\\>)|(\\<\\w+((\\s+\\w+(\\s*\\=\\s*(?:\".*?\"|'.*?'|[^'\"\\>\\s]+))?)+\\s*|\\s*)/\\>)|(&[a-zA-Z][a-zA-Z0-9]+;)", 32);
    public static final Pattern UNPRINTABLE_PATTERN = Pattern.compile("[\\p{Cntrl}&&[^\r\n\t]]");
    public static final List<String> RULES = new ArrayList<String>();

    private StringUtils() {
    }

    public static String checkSanityString(String value) throws InvalidParseOperationException {
        StringUtils.checkSanityString(new String[]{value});
        return value;
    }

    public static void checkSanityString(String ... strings) throws InvalidParseOperationException {
        for (String field : strings) {
            if (UNPRINTABLE_PATTERN.matcher(field).find()) {
                throw new InvalidParseOperationException("Invalid input bytes");
            }
            for (String rule : RULES) {
                if (field == null || rule == null || !field.contains(rule)) continue;
                throw new InvalidParseOperationException("Invalid tag sanity check");
            }
        }
    }

    public static final byte[] getRandom(int length) {
        if (length <= 0) {
            return new byte[0];
        }
        byte[] result = new byte[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(RANDOM.nextInt(95) + 32);
        }
        return result;
    }

    public static final byte[] getBytesFromArraysToString(String bytesString) {
        ParametersChecker.checkParameter("Should not be null or empty", bytesString);
        String[] strings = bytesString.replace("[", "").replace("]", "").split(", ");
        byte[] result = new byte[strings.length];
        try {
            for (int i = 0; i < result.length; ++i) {
                result[i] = (byte)(Integer.parseInt(strings[i]) & 0xFF);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    public static final String getClassName(Object object) {
        Class<?> clasz = object.getClass();
        String name = clasz.getSimpleName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        name = clasz.getName();
        int pos = name.lastIndexOf(46);
        if (pos < 0) {
            return name;
        }
        return name.substring(pos + 1);
    }

    public static final String substringBetween(String source, String start, String end) {
        return org.apache.commons.lang3.StringUtils.substringBetween((String)source, (String)start, (String)end);
    }

    public static final String substringBeforeLast(String source, String separator) {
        return org.apache.commons.lang3.StringUtils.substringBeforeLast((String)source, (String)separator);
    }

    public static String getStringFromInputStream(InputStream is) throws IOException {
        String content;
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(is));){
            content = buffer.lines().collect(Collectors.joining());
        }
        return content;
    }

    static {
        RULES.add(CDATA_TAG_UNESCAPED);
        RULES.add(CDATA_TAG_ESCAPED);
        RULES.add(ENTITY_TAG_UNESCAPED);
        RULES.add(ENTITY_TAG_ESCAPED);
        RULES.add(SCRIPT_TAG_UNESCAPED);
        RULES.add(SCRIPT_TAG_ESCAPED);
    }
}

