/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common;

import com.google.common.base.Strings;
import fr.gouv.vitam.common.parameter.VitamParameter;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ParametersChecker {
    private static final String MANDATORY_PARAMETER = " is mandatory parameter";

    private ParametersChecker() {
    }

    public static void checkParameter(String errorMessage, String ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        for (String parameter : parameters) {
            if (!Strings.isNullOrEmpty((String)parameter) && !parameter.trim().isEmpty()) continue;
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkParameterDefault(String errorMessage, String ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(errorMessage + MANDATORY_PARAMETER);
        }
        for (String parameter : parameters) {
            if (!Strings.isNullOrEmpty((String)parameter) && !parameter.trim().isEmpty()) continue;
            throw new IllegalArgumentException(errorMessage + MANDATORY_PARAMETER);
        }
    }

    public static boolean isNotEmpty(String ... parameters) {
        if (parameters == null) {
            return false;
        }
        for (String parameter : parameters) {
            if (!Strings.isNullOrEmpty((String)parameter) && !parameter.trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static void checkParameterDefault(String errorMessage, Object ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(errorMessage + MANDATORY_PARAMETER);
        }
        for (Object parameter : parameters) {
            if (parameter != null) continue;
            throw new IllegalArgumentException(errorMessage + MANDATORY_PARAMETER);
        }
    }

    public static void checkParameterNullOnly(String errorMessage, String ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        for (String parameter : parameters) {
            if (parameter != null) continue;
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkParameter(String errorMessage, Object ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        for (Object parameter : parameters) {
            if (parameter != null) continue;
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkDateParam(String errorMessage, String date) {
        if (date == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        try {
            LocalDate.parse(date);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkValue(String name, long variable, long minValue) {
        if (variable < minValue) {
            throw new IllegalArgumentException("Parameter " + name + " is less than " + minValue);
        }
    }

    public static <T extends Enum<T>> void checkNullOrEmptyParameter(T key, String value, Set<T> mandatories) {
        ParametersChecker.checkParameter("Key parameter", key);
        if (mandatories.contains(key)) {
            ParametersChecker.checkParameter(key.name(), value);
        }
    }

    public static <T extends Enum<T>> void checkNullOrEmptyParameters(Map<T, String> parameters, Set<T> mandatories) {
        ParametersChecker.checkParameter("Check Or null parameter", parameters, mandatories);
        for (Enum key : mandatories) {
            if (!Strings.isNullOrEmpty((String)parameters.get(key))) continue;
            throw new IllegalArgumentException(key + " parameter cannot be null or empty");
        }
    }

    public static <T extends VitamParameter> void checkNullOrEmptyParameters(T parameter) {
        ParametersChecker.checkParameter("Check Or null parameter", parameter);
        ParametersChecker.checkNullOrEmptyParameters(parameter.getMapParameters(), parameter.getMandatoriesParameters());
    }

    public static <T extends VitamParameter> void checkNullOrEmptyParameters(T ... parameters) {
        ParametersChecker.checkParameter("Check Or null parameter", parameters);
        for (T parameter : parameters) {
            ParametersChecker.checkNullOrEmptyParameters(parameter.getMapParameters(), parameter.getMandatoriesParameters());
        }
    }

    public static <T> List<T> checkNullOrEmptyParameters(String errorMessage, List<T> parameters) {
        return Optional.ofNullable(parameters).filter(list -> !list.isEmpty() && list.stream().noneMatch(Objects::isNull)).orElseThrow(() -> new IllegalArgumentException(errorMessage));
    }
}

