/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common;

import com.google.common.io.BaseEncoding;
import fr.gouv.vitam.common.ParametersChecker;

public final class BaseXx {
    private static final String ARGUMENT_NULL_NOT_ALLOWED = "argument null not allowed";
    private static final BaseEncoding BASE64_URL_WITHOUT_PADDING = BaseEncoding.base64Url().omitPadding();
    private static final BaseEncoding BASE64_URL_WITH_PADDING = BaseEncoding.base64Url();
    private static final BaseEncoding BASE64 = BaseEncoding.base64();
    private static final BaseEncoding BASE32 = BaseEncoding.base32().lowerCase().omitPadding();
    private static final BaseEncoding BASE16 = BaseEncoding.base16().lowerCase().omitPadding();

    private BaseXx() {
    }

    public static final String getBase16(byte[] bytes) {
        ParametersChecker.checkParameter(ARGUMENT_NULL_NOT_ALLOWED, new Object[]{bytes});
        return BASE16.encode(bytes);
    }

    public static final String getBase32(byte[] bytes) {
        ParametersChecker.checkParameter(ARGUMENT_NULL_NOT_ALLOWED, new Object[]{bytes});
        return BASE32.encode(bytes);
    }

    public static final String getBase64UrlWithoutPadding(byte[] bytes) {
        ParametersChecker.checkParameter(ARGUMENT_NULL_NOT_ALLOWED, new Object[]{bytes});
        return BASE64_URL_WITHOUT_PADDING.encode(bytes);
    }

    public static final String getBase64UrlWithPadding(byte[] bytes) {
        ParametersChecker.checkParameter(ARGUMENT_NULL_NOT_ALLOWED, new Object[]{bytes});
        return BASE64_URL_WITH_PADDING.encode(bytes);
    }

    public static final String getBase64(byte[] bytes) {
        ParametersChecker.checkParameter(ARGUMENT_NULL_NOT_ALLOWED, new Object[]{bytes});
        return BASE64.encode(bytes);
    }

    public static final byte[] getFromBase16(String base16) {
        ParametersChecker.checkParameter(ARGUMENT_NULL_NOT_ALLOWED, base16);
        return BASE16.decode((CharSequence)base16);
    }

    public static final byte[] getFromBase32(String base32) {
        ParametersChecker.checkParameter(ARGUMENT_NULL_NOT_ALLOWED, base32);
        return BASE32.decode((CharSequence)base32);
    }

    public static final byte[] getFromBase64UrlWithoutPadding(String base64) {
        ParametersChecker.checkParameter(ARGUMENT_NULL_NOT_ALLOWED, base64);
        return BASE64_URL_WITHOUT_PADDING.decode((CharSequence)base64);
    }

    public static final byte[] getFromBase64UrlPadding(String base64Padding) {
        ParametersChecker.checkParameter(ARGUMENT_NULL_NOT_ALLOWED, base64Padding);
        return BASE64_URL_WITH_PADDING.decode((CharSequence)base64Padding);
    }

    public static final byte[] getFromBase64(String base64Padding) {
        ParametersChecker.checkParameter(ARGUMENT_NULL_NOT_ALLOWED, base64Padding);
        return BASE64.decode((CharSequence)base64Padding);
    }
}

