/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.rest;

import fr.gouv.vitam.common.server.application.GenericExceptionMapper;
import fr.gouv.vitam.common.server.application.resources.AdminStatusResource;
import fr.gouv.vitam.common.server.application.resources.VitamServiceRegistry;
import fr.gouv.vitam.common.serverv2.ConfigurationApplication;
import fr.gouv.vitam.common.storage.cas.container.api.ContentAddressableStorage;
import fr.gouv.vitam.common.storage.constants.StorageProvider;
import fr.gouv.vitam.common.storage.swift.Swift;
import fr.gouv.vitam.storage.offers.rest.AdminOfferSwiftMigrationResource;
import fr.gouv.vitam.storage.offers.rest.OfferCommonApplication;
import fr.gouv.vitam.storage.offers.tape.rest.AdminTapeResource;
import fr.gouv.vitam.storage.offers.tape.rest.TapeCatalogResource;
import java.util.HashSet;
import java.util.Set;

public class AdminOfferApplication
extends ConfigurationApplication {
    private final Set<Object> singletons;

    public AdminOfferApplication() {
        OfferCommonApplication offerCommonApplication = OfferCommonApplication.getInstance();
        ContentAddressableStorage contentAddressableStorage = offerCommonApplication.getContentAddressableStorage();
        this.singletons = new HashSet<Object>();
        this.singletons.add(new GenericExceptionMapper());
        this.singletons.add(new AdminStatusResource(new VitamServiceRegistry()));
        if (StorageProvider.TAPE_LIBRARY.getValue().equalsIgnoreCase(offerCommonApplication.getStorageConfiguration().getProvider())) {
            this.singletons.add(new AdminTapeResource());
            this.singletons.add(new TapeCatalogResource());
        }
        if (contentAddressableStorage instanceof Swift) {
            this.singletons.add((Object)new AdminOfferSwiftMigrationResource((Swift)contentAddressableStorage));
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

