/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.core;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.storage.ContainerInformation;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectContent;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectListingListener;
import fr.gouv.vitam.common.stream.MultiplexedStreamReader;
import fr.gouv.vitam.storage.driver.model.StorageBulkMetadataResult;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutResult;
import fr.gouv.vitam.storage.driver.model.StorageMetadataResult;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface DefaultOfferService {
    public static final String STORAGE_CONF_FILE_NAME = "default-storage.conf";

    @VisibleForTesting
    public String getObjectDigest(String var1, String var2, DigestType var3) throws ContentAddressableStorageException;

    public ObjectContent getObject(String var1, String var2) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageException;

    public String createAccessRequest(String var1, List<String> var2) throws ContentAddressableStorageException;

    public Map<String, AccessRequestStatus> checkAccessRequestStatuses(List<String> var1, boolean var2) throws ContentAddressableStorageException;

    public void removeAccessRequest(String var1, boolean var2) throws ContentAddressableStorageException;

    public boolean checkObjectAvailability(String var1, List<String> var2) throws ContentAddressableStorageException;

    public String createObject(String var1, String var2, InputStream var3, DataCategory var4, long var5, DigestType var7) throws ContentAddressableStorageException;

    public StorageBulkPutResult bulkPutObjects(String var1, List<String> var2, MultiplexedStreamReader var3, DataCategory var4, DigestType var5) throws ContentAddressableStorageException, IOException;

    public boolean isObjectExist(String var1, String var2) throws ContentAddressableStorageException;

    public ContainerInformation getCapacity(String var1) throws ContentAddressableStorageException;

    public void deleteObject(String var1, String var2, DataCategory var3) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageException;

    public StorageMetadataResult getMetadata(String var1, String var2, boolean var3) throws ContentAddressableStorageException;

    public List<OfferLog> getOfferLogs(String var1, Long var2, int var3, Order var4) throws ContentAddressableStorageException;

    public void listObjects(String var1, ObjectListingListener var2) throws IOException, ContentAddressableStorageException;

    public void compactOfferLogs() throws Exception;

    public StorageBulkMetadataResult getBulkMetadata(String var1, List<String> var2, Boolean var3) throws ContentAddressableStorageException;
}

