/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.core;

import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.storage.cas.container.api.ContentAddressableStorage;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutResultEntry;
import fr.gouv.vitam.storage.offers.core.NonUpdatableContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class BackgroundObjectDigestValidator {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BackgroundObjectDigestValidator.class);
    private final AlertService alertService = new AlertServiceImpl();
    private final ContentAddressableStorage defaultStorage;
    private final ExecutorService executor;
    private final String containerName;
    private final DigestType digestType;
    private final int tenantId;
    private final String requestId;
    private final List<StorageBulkPutResultEntry> writtenObjects = Collections.synchronizedList(new ArrayList());
    private final AtomicBoolean conflictsReported = new AtomicBoolean(false);
    private final AtomicBoolean technicalExceptionsReported = new AtomicBoolean(false);

    public BackgroundObjectDigestValidator(ContentAddressableStorage defaultStorage, String containerName, DigestType digestType) {
        this.tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        this.requestId = VitamThreadUtils.getVitamSession().getRequestId();
        this.defaultStorage = defaultStorage;
        this.containerName = containerName;
        this.digestType = digestType;
        this.executor = Executors.newFixedThreadPool(1, (ThreadFactory)VitamThreadFactory.getInstance());
    }

    public void addWrittenObjectToCheck(String objectName, String objectDigest, long size) {
        this.executor.submit(() -> this.checkObjectDigestTask(objectName, objectDigest, size));
    }

    public void addExistingWormObjectToCheck(String objectName, String objectDigest, long size) {
        this.executor.submit(() -> this.checkRewritableObjectDigestTask(objectName, objectDigest, size));
    }

    private void checkObjectDigestTask(String objectId, String objectDigest, long size) {
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(this.tenantId));
        VitamThreadUtils.getVitamSession().setRequestId(this.requestId);
        try {
            this.writtenObjects.add(new StorageBulkPutResultEntry(objectId, objectDigest, size));
            this.defaultStorage.checkObjectDigestAndStoreDigest(this.containerName, objectId, objectDigest, this.digestType, size);
            LOGGER.debug("Digest validation / persistence succeeded for Object {}/{}", (Object)this.containerName, (Object)objectId);
        }
        catch (ContentAddressableStorageException e) {
            LOGGER.error("Could not compute digest of object " + this.containerName + "/" + objectId, (Throwable)e);
            this.technicalExceptionsReported.set(true);
        }
        catch (RuntimeException e) {
            LOGGER.error("Unexpected error occurred during digest validation or persistence of object " + this.containerName + "/" + objectId, (Throwable)e);
            this.technicalExceptionsReported.set(true);
        }
    }

    private void checkRewritableObjectDigestTask(String objectId, String objectDigest, long size) {
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(this.tenantId));
        VitamThreadUtils.getVitamSession().setRequestId(this.requestId);
        try {
            String actualObjectDigest = this.defaultStorage.getObjectDigest(this.containerName, objectId, this.digestType, true);
            if (!objectDigest.equals(actualObjectDigest)) {
                this.conflictsReported.set(true);
                this.alertService.createAlert(VitamLogLevel.ERROR, String.format("Object with id %s (%s) already exists and cannot be updated. Existing file digest=%s, input digest=%s", objectId, this.containerName, actualObjectDigest, objectDigest));
                throw new NonUpdatableContentAddressableStorageException("Object with id " + objectId + " already exists and cannot be updated. Existing object digest: " + actualObjectDigest + ". Digest of new objet to write " + objectDigest);
            }
            this.writtenObjects.add(new StorageBulkPutResultEntry(objectId, objectDigest, size));
            LOGGER.warn("Non rewritable object updated with same content. Ignoring duplicate. Object Id {}/{}", (Object)this.containerName, (Object)objectId);
        }
        catch (NonUpdatableContentAddressableStorageException e) {
            LOGGER.error("Attempt to override object " + this.containerName + "/" + objectId, (Throwable)((Object)e));
            this.conflictsReported.set(true);
        }
        catch (ContentAddressableStorageException e) {
            LOGGER.error("Could not compute digest of object " + this.containerName + "/" + objectId, (Throwable)e);
            this.technicalExceptionsReported.set(true);
        }
        catch (RuntimeException e) {
            LOGGER.error("Unexpected error occurred during digest validation of object " + this.containerName + "/" + objectId, (Throwable)e);
            this.technicalExceptionsReported.set(true);
        }
    }

    public void awaitTermination() throws ContentAddressableStorageException {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Executor termination failed");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ContentAddressableStorageException("Thread interrupted", (Throwable)e);
        }
    }

    public boolean hasConflictsReported() {
        return this.conflictsReported.get();
    }

    public boolean hasTechnicalExceptionsReported() {
        return this.technicalExceptionsReported.get();
    }

    public List<StorageBulkPutResultEntry> getWrittenObjects() {
        return Collections.unmodifiableList(this.writtenObjects);
    }
}

