/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.engine.core.operation;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextException;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.common.CompressInformation;
import java.util.Collections;
import java.util.List;

public class OperationContextMonitor {
    public static final String ALL_PARAMS_ARE_REQUIRED = "All params are required";
    public static final String OperationContextFileName = "operation_context.json";
    private final StorageClientFactory storageClientFactory;

    public OperationContextMonitor(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public OperationContextMonitor() {
        this(StorageClientFactory.getInstance());
    }

    public static void compressInWorkspace(WorkspaceClientFactory workspaceClientFactory, String operationContainer, LogbookTypeProcess logbookTypeProcess, String ... files) throws OperationContextException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_ARE_REQUIRED, (Object[])new Object[]{operationContainer, logbookTypeProcess, files});
        if (files.length == 0) {
            throw new OperationContextException("files parameter is empty");
        }
        try (WorkspaceClient workspaceClient = workspaceClientFactory.getClient();){
            String outputFile = logbookTypeProcess.name() + "_" + operationContainer + ".zip";
            CompressInformation compressInformation = new CompressInformation();
            Collections.addAll(compressInformation.getFiles(), files);
            compressInformation.setOutputContainer(operationContainer);
            compressInformation.setOutputFile(outputFile);
            workspaceClient.compress(operationContainer, compressInformation);
        }
        catch (Exception e) {
            throw new OperationContextException(e);
        }
    }

    public void backup(String strategy, String operationContainer, LogbookTypeProcess logbookTypeProcess) throws OperationContextException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_ARE_REQUIRED, (Object[])new Object[]{strategy, operationContainer, logbookTypeProcess});
        ParametersChecker.checkParameter((String)"StorageClientFactory is required", (Object[])new Object[]{this.storageClientFactory});
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            String outputFile = logbookTypeProcess.name() + "_" + operationContainer + ".zip";
            ObjectDescription description = new ObjectDescription();
            description.setWorkspaceContainerGUID(operationContainer);
            description.setWorkspaceObjectURI(outputFile);
            storageClient.storeFileFromWorkspace(strategy, DataCategory.TMP, outputFile, description);
        }
        catch (Exception e) {
            throw new OperationContextException(e);
        }
    }

    @VisibleForTesting
    public JsonNode getInformation(String strategy, String operationContainer, LogbookTypeProcess logbookTypeProcess) throws OperationContextException, StorageNotFoundException {
        JsonNode jsonNode;
        block8: {
            ParametersChecker.checkParameter((String)ALL_PARAMS_ARE_REQUIRED, (Object[])new Object[]{strategy, operationContainer, logbookTypeProcess});
            StorageClient storageClient = this.storageClientFactory.getClient();
            try {
                String objectName = logbookTypeProcess.name() + "_" + operationContainer + ".zip";
                jsonNode = storageClient.getInformation(strategy, DataCategory.TMP, objectName, (List)Lists.newArrayList((Object[])new String[]{"default"}), false);
                if (storageClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (storageClient != null) {
                        try {
                            storageClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new OperationContextException(e);
                }
            }
            storageClient.close();
        }
        return jsonNode;
    }

    public boolean deleteBackup(String strategy, String operationContainer, LogbookTypeProcess logbookTypeProcess) throws OperationContextException {
        boolean bl;
        block8: {
            ParametersChecker.checkParameter((String)ALL_PARAMS_ARE_REQUIRED, (Object[])new Object[]{strategy, operationContainer, logbookTypeProcess});
            StorageClient storageClient = this.storageClientFactory.getClient();
            try {
                String objectName = logbookTypeProcess.name() + "_" + operationContainer + ".zip";
                bl = storageClient.delete(strategy, DataCategory.TMP, objectName);
                if (storageClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (storageClient != null) {
                        try {
                            storageClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new OperationContextException(e);
                }
            }
            storageClient.close();
        }
        return bl;
    }
}

