/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.utils;

import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.model.DatabaseCursor;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;

public class ArrayListScrollSpliterator<T>
extends Spliterators.AbstractSpliterator<List<T>> {
    private final SelectMultiQuery query;
    private final Function<SelectMultiQuery, RequestResponse<List<T>>> repository;
    private final int scrollTimeout;
    private final int limit;
    private long size;
    private DatabaseCursor hits;
    private RequestResponseOK<List<T>> requestResponse;
    private Iterator<List<T>> results;
    private String scrollId;

    public ArrayListScrollSpliterator(SelectMultiQuery query, Function<SelectMultiQuery, RequestResponse<List<T>>> repository, int scrollTimeout, int limit) {
        super(Long.MAX_VALUE, 321);
        this.query = query;
        this.repository = repository;
        this.scrollTimeout = scrollTimeout;
        this.limit = limit;
        this.size = 0L;
        this.scrollId = "START";
    }

    @Override
    public boolean tryAdvance(Consumer<? super List<T>> action) {
        if (this.requestResponse == null) {
            this.executeQuery();
        }
        if (this.results.hasNext()) {
            this.applyAndIncrementSize(action);
            return true;
        }
        if (this.size < this.hits.getTotal()) {
            this.executeQuery();
            this.applyAndIncrementSize(action);
            return true;
        }
        return false;
    }

    private void applyAndIncrementSize(Consumer<? super List<T>> action) {
        List<T> next = this.results.next();
        action.accept(next);
        this.size += (long)next.size();
    }

    @Override
    public long estimateSize() {
        if (this.requestResponse == null) {
            this.executeQuery();
        }
        return this.hits.getTotal();
    }

    private void executeQuery() {
        this.query.setScrollFilter(this.scrollId, this.scrollTimeout, this.limit);
        this.requestResponse = (RequestResponseOK)this.repository.apply(this.query);
        this.hits = this.requestResponse.getHits();
        this.results = this.requestResponse.getResults().iterator();
        this.scrollId = this.hits.getScrollId();
    }
}

