/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.translators.mongodb;

import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.parser.request.AbstractParser;
import fr.gouv.vitam.common.database.parser.request.multiple.InsertParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.translators.RequestToAbstract;
import fr.gouv.vitam.common.database.translators.mongodb.DeleteToMongodb;
import fr.gouv.vitam.common.database.translators.mongodb.InsertToMongodb;
import fr.gouv.vitam.common.database.translators.mongodb.QueryToMongodb;
import fr.gouv.vitam.common.database.translators.mongodb.SelectToMongodb;
import fr.gouv.vitam.common.database.translators.mongodb.UpdateToMongodb;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import java.util.List;
import java.util.Set;
import org.bson.conversions.Bson;

public abstract class RequestToMongodb
extends RequestToAbstract {
    public RequestToMongodb(AbstractParser<?> requestParser) {
        super(requestParser);
    }

    public static RequestToMongodb getRequestToMongoDb(AbstractParser<?> requestParser) {
        if (requestParser instanceof SelectParserMultiple) {
            return new SelectToMongodb(requestParser);
        }
        if (requestParser instanceof SelectParserSingle) {
            return new SelectToMongodb(requestParser);
        }
        if (requestParser instanceof InsertParserMultiple) {
            return new InsertToMongodb(requestParser);
        }
        if (requestParser instanceof UpdateParserMultiple) {
            return new UpdateToMongodb(requestParser);
        }
        return new DeleteToMongodb(requestParser);
    }

    public Bson getInitialRoots(String field) throws InvalidParseOperationException {
        Set roots = this.requestParser.getRequest().getRoots();
        return QueryToMongodb.getRoots(field, roots);
    }

    public Bson getRequest(Bson roots, Bson query) {
        return QueryToMongodb.getFullCommand(query, roots);
    }

    public Bson getNthQueries(int nth) throws IllegalAccessException, IllegalAccessError, InvalidParseOperationException {
        List list = this.requestParser.getRequest().getQueries();
        if (nth >= list.size()) {
            throw new IllegalAccessError("This Query has not enough item to get the position: " + nth);
        }
        Query query = (Query)list.get(nth);
        if (query.isFullText()) {
            throw new IllegalAccessException("This Query is to be computed by Elasticsearch: " + nth);
        }
        return QueryToMongodb.getCommand(query);
    }
}

