/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.translators.mongodb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.parser.request.GlobalDatasParser;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.BsonType;
import org.bson.conversions.Bson;

public class QueryToMongodb {
    private static final String INVALID_RANGE_REQUEST_COMMAND = "Invalid Range request command: ";
    private static final String COMMAND_NOT_ALLOWED_WITH_MONGO_DB = "Command not allowed with MongoDB: ";

    private QueryToMongodb() {
    }

    public static Bson getRoots(String field, Collection<String> roots) {
        if (roots.size() == 1) {
            return Filters.eq((String)field, (Object)roots.iterator().next());
        }
        Object[] values = new String[roots.size()];
        int i = 0;
        for (String node : roots) {
            values[i++] = node;
        }
        return Filters.in((String)field, (Object[])values);
    }

    public static Bson getFullCommand(Bson command, Bson roots) {
        return Filters.and((Bson[])new Bson[]{command, roots});
    }

    public static Bson getCommand(Query query) throws InvalidParseOperationException {
        BuilderToken.QUERY req = query.getQUERY();
        JsonNode content = query.getNode(req.exactToken());
        switch (req) {
            case AND: 
            case NOT: 
            case OR: {
                return QueryToMongodb.booleanCommand(query, req);
            }
            case EXISTS: 
            case MISSING: {
                return Filters.exists((String)content.asText(), (req == BuilderToken.QUERY.EXISTS ? 1 : 0) != 0);
            }
            case FLT: 
            case MLT: 
            case MATCH: 
            case MATCH_ALL: 
            case MATCH_PHRASE: 
            case MATCH_PHRASE_PREFIX: 
            case SEARCH: 
            case SUBOBJECT: {
                throw new InvalidParseOperationException(COMMAND_NOT_ALLOWED_WITH_MONGO_DB + req.exactToken());
            }
            case NIN: 
            case IN: {
                return QueryToMongodb.inCommand(req, content);
            }
            case RANGE: {
                return QueryToMongodb.rangeCommand(req, content);
            }
            case REGEX: {
                return QueryToMongodb.regexCommand(req, content);
            }
            case TERM: {
                return QueryToMongodb.termCommand(content);
            }
            case WILDCARD: {
                return QueryToMongodb.wildcardCommand(req, content);
            }
            case EQ: 
            case GT: 
            case GTE: 
            case LT: 
            case LTE: 
            case NE: {
                return QueryToMongodb.comparatorCommand(req, content);
            }
            case ISNULL: {
                return QueryToMongodb.isNullCommand(content);
            }
            case SIZE: {
                return QueryToMongodb.sizeCommand(req, content);
            }
            case GEOMETRY: 
            case BOX: 
            case POLYGON: 
            case CENTER: 
            case GEOINTERSECTS: 
            case GEOWITHIN: 
            case PATH: {
                return QueryToMongodb.pathCommand(content);
            }
            case NOP: {
                return new BasicDBObject();
            }
        }
        throw new InvalidParseOperationException("Invalid command: " + req.exactToken());
    }

    private static Bson isNullCommand(JsonNode content) {
        return Filters.type((String)content.asText(), (BsonType)BsonType.NULL);
    }

    private static Bson pathCommand(JsonNode content) {
        ArrayNode array = (ArrayNode)content;
        Object[] values = new String[array.size()];
        int i = 0;
        for (JsonNode node : array) {
            values[i++] = node.asText();
        }
        return Filters.in((String)"_id", (Object[])values);
    }

    private static Bson sizeCommand(BuilderToken.QUERY req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        return Filters.size((String)((String)element.getKey()), (int)((JsonNode)element.getValue()).asInt());
    }

    private static Bson comparatorCommand(BuilderToken.QUERY req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        Object value = GlobalDatasParser.getValue((JsonNode)element.getValue());
        switch (req) {
            case EQ: {
                return Filters.eq((String)((String)element.getKey()), (Object)value);
            }
            case GT: {
                return Filters.gt((String)((String)element.getKey()), (Object)value);
            }
            case GTE: {
                return Filters.gte((String)((String)element.getKey()), (Object)value);
            }
            case LT: {
                return Filters.lt((String)((String)element.getKey()), (Object)value);
            }
            case LTE: {
                return Filters.lte((String)((String)element.getKey()), (Object)value);
            }
        }
        return Filters.ne((String)((String)element.getKey()), (Object)value);
    }

    private static Bson wildcardCommand(BuilderToken.QUERY req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        String value = ((JsonNode)element.getValue()).asText();
        value = value.replace('?', '.').replace("*", ".*");
        return Filters.regex((String)((String)element.getKey()), (String)value);
    }

    private static Bson termCommand(JsonNode content) throws InvalidParseOperationException {
        Iterator iterator = content.fields();
        BasicDBObject bson = new BasicDBObject();
        while (iterator.hasNext()) {
            Map.Entry element = (Map.Entry)iterator.next();
            bson.append((String)element.getKey(), GlobalDatasParser.getValue((JsonNode)element.getValue()));
        }
        return bson;
    }

    private static Bson regexCommand(BuilderToken.QUERY req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        return Filters.regex((String)((String)element.getKey()), (String)((JsonNode)element.getValue()).asText());
    }

    private static Bson rangeCommand(BuilderToken.QUERY req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        String var = (String)element.getKey();
        BasicDBObject range = new BasicDBObject();
        Iterator iterator = ((JsonNode)element.getValue()).fields();
        while (iterator.hasNext()) {
            Map.Entry requestItem = (Map.Entry)iterator.next();
            try {
                String key = (String)requestItem.getKey();
                if (key.startsWith("$")) {
                    BuilderToken.RANGEARGS.valueOf((String)key.substring(1).toUpperCase());
                    range.append(key, GlobalDatasParser.getValue((JsonNode)requestItem.getValue()));
                    continue;
                }
                throw new InvalidParseOperationException(INVALID_RANGE_REQUEST_COMMAND + requestItem);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidParseOperationException(INVALID_RANGE_REQUEST_COMMAND + requestItem, (Throwable)e);
            }
        }
        return new BasicDBObject(var, (Object)range);
    }

    private static Bson inCommand(BuilderToken.QUERY req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        ArrayNode array = (ArrayNode)element.getValue();
        Object[] values = new Object[array.size()];
        int i = 0;
        for (JsonNode node : array) {
            values[i++] = GlobalDatasParser.getValue(node);
        }
        switch (req) {
            case NIN: {
                return Filters.nin((String)((String)element.getKey()), (Object[])values);
            }
        }
        return Filters.in((String)((String)element.getKey()), (Object[])values);
    }

    private static Bson booleanCommand(Query query, BuilderToken.QUERY req) throws InvalidParseOperationException {
        BooleanQuery nthrequest = (BooleanQuery)query;
        List sub = nthrequest.getQueries();
        switch (req) {
            case AND: {
                return Filters.and(QueryToMongodb.getCommands(sub));
            }
            case NOT: {
                if (sub.size() == 1) {
                    return Filters.nor((Bson[])new Bson[]{QueryToMongodb.getCommand((Query)sub.get(0))});
                }
                return Filters.nor((Bson[])new Bson[]{Filters.and(QueryToMongodb.getCommands(sub))});
            }
        }
        return Filters.or(QueryToMongodb.getCommands(sub));
    }

    protected static Iterable<Bson> getCommands(List<Query> queries) {
        return queries.stream().map(query -> {
            try {
                return QueryToMongodb.getCommand(query);
            }
            catch (InvalidParseOperationException e) {
                throw new RuntimeException("Invalid query", e);
            }
        }).collect(Collectors.toList());
    }
}

