/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ReadConcern;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.translators.mongodb.VitamDocumentCodec;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.configuration.DatabaseConnection;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public abstract class MongoDbAccess
implements DatabaseConnection {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MongoDbAccess.class);
    private MongoClient mongoClient;
    private MongoDatabase mongoDatabase;
    private MongoDatabase mongoAdmin;
    private String dbname;

    public MongoDbAccess(MongoClient mongoClient, String dbname) {
        ParametersChecker.checkParameter((String)"Parameter of MongoDbAccess", (Object[])new Object[]{mongoClient, dbname});
        this.mongoClient = mongoClient;
        this.mongoDatabase = mongoClient.getDatabase(dbname);
        this.mongoAdmin = mongoClient.getDatabase("admin");
        this.dbname = dbname;
    }

    public boolean checkConnection() {
        try {
            this.mongoClient.getDatabase(this.dbname).runCommand((Bson)new BasicDBObject("ping", (Object)"1"));
            return true;
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
            return false;
        }
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public MongoDbAccess setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
        return this;
    }

    public MongoDatabase getMongoDatabase() {
        return this.mongoDatabase;
    }

    public MongoDbAccess setMongoDatabase(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
        return this;
    }

    public MongoDatabase getMongoAdmin() {
        return this.mongoAdmin;
    }

    public MongoDbAccess setMongoAdmin(MongoDatabase mongoAdmin) {
        this.mongoAdmin = mongoAdmin;
        return this;
    }

    public void close() {
        this.mongoClient.close();
    }

    public String getInfo() {
        return this.dbname;
    }

    public static MongoClient createMongoClient(DbConfiguration configuration) {
        return MongoDbAccess.createMongoClient(configuration, Collections.emptyList());
    }

    public static MongoClient createMongoClient(DbConfiguration configuration, List<Class<?>> classList) {
        MongoClientSettings.Builder settingsBuilder = MongoDbAccess.getMongoClientSettingsBuilder(classList);
        List serverAddress = configuration.getMongoDbNodes().stream().map(node -> new ServerAddress(node.getDbHost(), node.getDbPort())).collect(Collectors.toList());
        settingsBuilder.applyToClusterSettings(builder -> builder.hosts(serverAddress));
        if (configuration.isDbAuthentication()) {
            MongoCredential credential = MongoCredential.createScramSha256Credential((String)configuration.getDbUserName(), (String)configuration.getDbName(), (char[])configuration.getDbPassword().toCharArray());
            settingsBuilder.credential(credential);
        }
        return MongoClients.create((MongoClientSettings)settingsBuilder.build());
    }

    public static MongoClientSettings.Builder getMongoClientSettingsBuilder(Class<?> ... classes) {
        return MongoDbAccess.getMongoClientSettingsBuilder(Arrays.asList(classes));
    }

    public static MongoClientSettings.Builder getMongoClientSettingsBuilder(List<Class<?>> classList) {
        MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder().writeConcern(WriteConcern.MAJORITY).readConcern(ReadConcern.MAJORITY).applyToSocketSettings(builder -> builder.connectTimeout(VitamConfiguration.getConnectTimeout().intValue(), TimeUnit.MILLISECONDS).readTimeout(VitamConfiguration.getReadTimeout().intValue(), TimeUnit.MILLISECONDS)).applyToConnectionPoolSettings(builder -> builder.minSize(1).maxConnecting(10).maxSize(VitamConfiguration.getNumberDbClientThread()).maxConnectionIdleTime((long)VitamConfiguration.getMaxDelayUnusedConnection().intValue(), TimeUnit.MILLISECONDS));
        if (CollectionUtils.isNotEmpty(classList)) {
            List codecs = classList.stream().map(clasz -> CodecRegistries.fromCodecs((Codec[])new Codec[]{new VitamDocumentCodec(clasz)})).collect(Collectors.toList());
            CodecRegistry vitamCodecRegistry = CodecRegistries.fromRegistries(codecs);
            CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{vitamCodecRegistry, MongoClientSettings.getDefaultCodecRegistry()});
            settingsBuilder.codecRegistry(codecRegistry);
        }
        return settingsBuilder;
    }

    public void setDatabase(String dbname) {
        this.mongoDatabase = this.mongoClient.getDatabase(dbname);
        this.dbname = dbname;
    }
}

