/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server.elasticsearch;

import fr.gouv.vitam.common.model.FacetBucket;
import fr.gouv.vitam.common.model.FacetResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.filter.Filters;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;

public class ElasticsearchFacetResultHelper {
    public static FacetResult transformFromEsAggregation(Aggregation aggregation) {
        String aggType;
        FacetResult facetResult = new FacetResult();
        facetResult.setName(aggregation.getName());
        switch (aggType = aggregation.getType()) {
            case "date_range": {
                facetResult.setBuckets(ElasticsearchFacetResultHelper.extractBucketRangeAggregation(aggregation));
                break;
            }
            case "sterms": 
            case "lterms": {
                facetResult.setBuckets(ElasticsearchFacetResultHelper.extractBucketTermsAggregation(aggregation));
                break;
            }
            case "filters": {
                facetResult.setBuckets(ElasticsearchFacetResultHelper.extractBucketFiltersAggregation(aggregation));
                break;
            }
            case "nested": {
                facetResult.setBuckets(ElasticsearchFacetResultHelper.extractBucketNestedAggregation(aggregation));
                break;
            }
        }
        return facetResult;
    }

    private static List<FacetBucket> extractBucketFiltersAggregation(Aggregation aggregation) {
        List buckets = ((Filters)aggregation).getBuckets();
        ArrayList<FacetBucket> facetBuckets = new ArrayList<FacetBucket>();
        buckets.forEach(bucket -> facetBuckets.add(new FacetBucket(bucket.getKeyAsString(), bucket.getDocCount())));
        return facetBuckets;
    }

    private static List<FacetBucket> extractBucketTermsAggregation(Aggregation aggregation) {
        List buckets = ((Terms)aggregation).getBuckets();
        ArrayList<FacetBucket> facetBuckets = new ArrayList<FacetBucket>();
        buckets.forEach(bucket -> facetBuckets.add(new FacetBucket(bucket.getKeyAsString(), bucket.getDocCount())));
        return facetBuckets;
    }

    private static List<FacetBucket> extractBucketNestedAggregation(Aggregation aggregation) {
        List aggregations = ((ParsedNested)aggregation).getAggregations().asList();
        if (aggregations.isEmpty()) {
            return Collections.emptyList();
        }
        Aggregation agg = (Aggregation)aggregations.get(0);
        return ElasticsearchFacetResultHelper.transformFromEsAggregation(agg).getBuckets();
    }

    private static List<FacetBucket> extractBucketRangeAggregation(Aggregation aggregation) {
        List buckets = ((Range)aggregation).getBuckets();
        ArrayList<FacetBucket> facetBuckets = new ArrayList<FacetBucket>();
        buckets.forEach(bucket -> facetBuckets.add(new FacetBucket(bucket.getKeyAsString(), bucket.getDocCount())));
        return facetBuckets;
    }
}

