/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexSettings;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchNode;
import fr.gouv.vitam.common.database.server.elasticsearch.VitamElasticListener;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamFatalRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.configuration.DatabaseConnection;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpHost;
import org.apache.http.util.Asserts;
import org.bson.Document;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.LatchedActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xcontent.XContentType;

public class ElasticsearchAccess
implements DatabaseConnection {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ElasticsearchAccess.class);
    public static final int DEFAULT_SCROLL_TIMEOUT = 60000;
    public static final int DEFAULT_LIMIT_SCROLL = 100;
    public static final String SCROLL_ACTIVATE_KEYWORD = "START";
    private static final String NUMBER_OF_SHARDS = "number_of_shards";
    private static final String NUMBER_OF_REPLICAS = "number_of_replicas";
    private static final String ES_CONFIGURATION_FILE = "/elasticsearch-configuration.json";
    private final AtomicReference<RestHighLevelClient> esClient = new AtomicReference();
    protected final String clusterName;
    protected final List<ElasticsearchNode> nodes;

    public ElasticsearchAccess(String clusterName, List<ElasticsearchNode> nodes) throws VitamException {
        ParametersChecker.checkParameter((String)"clusterName, elasticsearch nodes list are a mandatory parameters", (Object[])new Object[]{clusterName, nodes});
        if (nodes.isEmpty()) {
            throw new VitamException("elasticsearch nodes list is empty");
        }
        this.clusterName = clusterName;
        this.nodes = nodes;
    }

    public final GetAliasesResponse getAlias(ElasticsearchIndexAlias indexAlias) throws IOException {
        GetAliasesRequest request = new GetAliasesRequest(new String[]{indexAlias.getName()});
        request.indicesOptions(IndicesOptions.STRICT_EXPAND_OPEN);
        return this.getClient().indices().getAlias(request, RequestOptions.DEFAULT);
    }

    public final ElasticsearchIndexAlias createIndexWithoutAlias(ElasticsearchIndexAlias indexAlias, ElasticsearchIndexSettings indexSettings) throws DatabaseException {
        ElasticsearchIndexAlias newIndexName = indexAlias.createUniqueIndexName();
        this.createIndexWithOptionalAlias(null, newIndexName.getName(), indexSettings.loadMapping(), indexSettings.getShards(), indexSettings.getReplicas());
        return newIndexName;
    }

    private void createIndexWithOptionalAlias(String aliasName, String indexName, String mapping, Integer shards, Integer replicas) throws DatabaseException {
        try {
            CreateIndexRequest request = new CreateIndexRequest(indexName).settings(this.createIndexSettings(shards, replicas)).mapping(mapping, XContentType.JSON);
            if (aliasName != null) {
                request.alias(new Alias(aliasName));
            }
            request.setTimeout(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()));
            request.setMasterTimeout(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()));
            request.waitForActiveShards(ActiveShardCount.DEFAULT);
            VitamElasticListener listener = new VitamElasticListener();
            CountDownLatch latch = new CountDownLatch(1);
            LOGGER.debug("async request to create index [" + indexName + "]");
            this.getClient().indices().createAsync(request, RequestOptions.DEFAULT, (ActionListener)new LatchedActionListener((ActionListener)listener, latch));
            try {
                LOGGER.debug("request sent -> waiting for a response now");
                latch.await();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            Optional<Exception> hasException = Optional.ofNullable(listener.getException());
            if (hasException.isPresent()) {
                throw new IOException(hasException.get());
            }
            if (!listener.isAcknowledged() || !listener.isShardsAcknowledged()) {
                throw new DatabaseException("Could not create index " + indexName + ". acknowledged: " + listener.isAcknowledged() + ", shardsAcknowledged: " + listener.isShardsAcknowledged());
            }
        }
        catch (IOException e) {
            throw new DatabaseException("Could not create index " + indexName, (Throwable)e);
        }
    }

    public final boolean existsAlias(ElasticsearchIndexAlias indexAlias) throws DatabaseException {
        try {
            GetAliasesRequest request = new GetAliasesRequest(new String[]{indexAlias.getName()});
            request.local(true);
            request.indicesOptions(IndicesOptions.STRICT_EXPAND_OPEN);
            return this.getClient().indices().existsAlias(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new DatabaseException("Could not check alias existence " + indexAlias.getName(), (Throwable)e);
        }
    }

    public final boolean existsIndex(ElasticsearchIndexAlias index) throws DatabaseException {
        try {
            GetIndexRequest request = new GetIndexRequest(new String[]{index.getName()});
            request.local(true);
            request.indicesOptions(IndicesOptions.STRICT_EXPAND_OPEN);
            return this.getClient().indices().exists(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new DatabaseException("Could not check index existence " + index.getName(), (Throwable)e);
        }
    }

    public final void refreshIndex(ElasticsearchIndexAlias indexAlias) throws DatabaseException {
        RefreshResponse refreshResponse;
        LOGGER.debug("refreshIndex: " + indexAlias.getName());
        RefreshRequest request = new RefreshRequest(new String[]{indexAlias.getName()});
        request.indicesOptions(IndicesOptions.STRICT_EXPAND_OPEN);
        try {
            refreshResponse = this.getClient().indices().refresh(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new DatabaseException("Could not refresh index ", (Throwable)e);
        }
        LOGGER.debug("Refresh request executed with {} successful shards", (Object)refreshResponse.getSuccessfulShards());
        int failedShards = refreshResponse.getFailedShards();
        if (failedShards > 0) {
            DefaultShardOperationFailedException[] failures = refreshResponse.getShardFailures();
            StringBuilder sb = new StringBuilder();
            for (DefaultShardOperationFailedException failure : failures) {
                sb.append(failure.toString()).append("; ");
            }
            throw new DatabaseException(sb.toString());
        }
    }

    @VisibleForTesting
    protected void purgeIndexForTesting(ElasticsearchIndexAlias indexAlias, Integer tenantId) throws DatabaseException {
        TermQueryBuilder query = QueryBuilders.termQuery((String)"_tenant", (Object)tenantId);
        this.purgeIndexForTesting(indexAlias, (QueryBuilder)query);
    }

    @VisibleForTesting
    public final void purgeIndexForTesting(ElasticsearchIndexAlias indexAlias) throws DatabaseException {
        MatchAllQueryBuilder query = QueryBuilders.matchAllQuery();
        this.purgeIndexForTesting(indexAlias, (QueryBuilder)query);
    }

    private void purgeIndexForTesting(ElasticsearchIndexAlias indexAlias, QueryBuilder query) throws DatabaseException {
        try {
            if (this.existsAlias(indexAlias)) {
                DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexAlias.getName()});
                request.setConflicts("proceed");
                request.setQuery(query);
                request.setBatchSize(VitamConfiguration.getMaxElasticsearchBulk());
                request.setScroll(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds().intValue()));
                request.setTimeout(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()));
                request.setRefresh(true);
                BulkByScrollResponse bulkResponse = this.getClient().deleteByQuery(request, RequestOptions.DEFAULT);
                TimeValue timeTaken = bulkResponse.getTook();
                boolean timedOut = bulkResponse.isTimedOut();
                long totalDocs = bulkResponse.getTotal();
                long deletedDocs = bulkResponse.getDeleted();
                long batches = bulkResponse.getBatches();
                long noops = bulkResponse.getNoops();
                long versionConflicts = bulkResponse.getVersionConflicts();
                long bulkRetries = bulkResponse.getBulkRetries();
                long searchRetries = bulkResponse.getSearchRetries();
                TimeValue throttledMillis = bulkResponse.getStatus().getThrottled();
                TimeValue throttledUntilMillis = bulkResponse.getStatus().getThrottledUntil();
                LOGGER.debug("Purge alias (" + indexAlias.getName() + ") : timeTaken (" + timeTaken + "), timedOut (" + timedOut + "), totalDocs (" + totalDocs + "), deletedDocs (" + deletedDocs + "), batches (" + batches + "), noops (" + noops + "), versionConflicts (" + versionConflicts + ")bulkRetries (" + bulkRetries + "), searchRetries (" + searchRetries + "),  throttledMillis(" + throttledMillis + "), throttledUntilMillis(" + throttledUntilMillis + ")");
                List searchFailures = bulkResponse.getSearchFailures();
                if (CollectionUtils.isNotEmpty((Collection)searchFailures)) {
                    throw new DatabaseException("ES purge errors : in search phase > " + searchFailures);
                }
                List bulkFailures = bulkResponse.getBulkFailures();
                if (CollectionUtils.isNotEmpty((Collection)bulkFailures)) {
                    throw new DatabaseException("ES purge errors : in bulk phase > " + bulkFailures);
                }
            }
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public final <T> void indexEntry(ElasticsearchIndexAlias indexAlias, String id, VitamDocument<T> vitamDocument) throws DatabaseException {
        IndexResponse indexResponse;
        vitamDocument.remove("_id");
        vitamDocument.remove("_score");
        String source = BsonHelper.stringify(vitamDocument);
        IndexRequest request = ((IndexRequest)((IndexRequest)new IndexRequest(indexAlias.getName()).id(id).source(source, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).timeout(TimeValue.timeValueSeconds((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()))).opType(DocWriteRequest.OpType.INDEX);
        try {
            indexResponse = this.getClient().index(request, RequestOptions.DEFAULT);
        }
        catch (IOException | ElasticsearchException e) {
            throw new DatabaseException(e);
        }
        finally {
            vitamDocument.put("_id", id);
        }
        if (indexResponse.getResult() != DocWriteResponse.Result.CREATED) {
            throw new DatabaseException(String.format("Could not index document on ES. Id=%s, aliasName=%s, status=%s", id, indexAlias.getName(), indexResponse.status()));
        }
    }

    public void indexEntries(ElasticsearchIndexAlias indexAlias, Collection<? extends Document> documents, boolean withRefreshIndex) throws DatabaseException {
        UnmodifiableIterator idIterator = Iterators.partition(documents.iterator(), (int)VitamConfiguration.getMaxElasticsearchBulk());
        while (idIterator.hasNext()) {
            BulkResponse bulkResponse;
            BulkRequest bulkRequest = new BulkRequest();
            List docs = (List)idIterator.next();
            docs.forEach(document -> {
                String id = (String)document.remove((Object)"_id");
                try {
                    String source = BsonHelper.stringify(document);
                    bulkRequest.add(new IndexRequest(indexAlias.getName()).id(id).opType(DocWriteRequest.OpType.INDEX).source(source, XContentType.JSON));
                }
                finally {
                    document.put("_id", (Object)id);
                }
            });
            if (bulkRequest.numberOfActions() == 0) continue;
            try {
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                bulkResponse = this.getClient().bulk(bulkRequest, RequestOptions.DEFAULT);
            }
            catch (IOException | ElasticsearchException e) {
                throw new DatabaseException(e);
            }
            LOGGER.debug("Written document {}", (Object)bulkResponse.getItems().length);
            if (!bulkResponse.hasFailures()) continue;
            throw new DatabaseException("Bulk Request failure with error: " + bulkResponse.buildFailureMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void updateEntry(ElasticsearchIndexAlias indexAlias, String id, VitamDocument<T> vitamDocument) throws DatabaseException {
        try {
            IndexResponse indexResponse;
            vitamDocument.remove("_id");
            String document = BsonHelper.stringify(vitamDocument);
            IndexRequest request = ((IndexRequest)((IndexRequest)new IndexRequest(indexAlias.getName()).id(id).source(document, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).timeout(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()))).opType(DocWriteRequest.OpType.INDEX);
            try {
                indexResponse = this.getClient().index(request, RequestOptions.DEFAULT);
            }
            catch (IOException | ElasticsearchException e) {
                throw new DatabaseException(e);
            }
            if (indexResponse.getResult() != DocWriteResponse.Result.UPDATED) {
                throw new DatabaseException(String.format("Could not update document on ES. Id=%s, aliasName=%s, status=%s", id, indexAlias.getName(), indexResponse.status()));
            }
        }
        finally {
            vitamDocument.put("_id", id);
        }
    }

    public final SearchResponse search(ElasticsearchIndexAlias indexAlias, QueryBuilder query, QueryBuilder filter, String[] esProjection, List<SortBuilder<?>> sorts, int offset, Integer limit) throws DatabaseException, BadRequestException {
        return this.search(indexAlias, query, filter, esProjection, sorts, offset, limit, null, null, null, false);
    }

    public final SearchResponse searchCrossIndices(Set<ElasticsearchIndexAlias> indexAliases, QueryBuilder query, QueryBuilder filter, String[] esProjection, List<SortBuilder<?>> sorts, int offset, Integer limit, List<AggregationBuilder> facets, String scrollId, Integer scrollTimeout, boolean trackTotalHits) throws DatabaseException, BadRequestException {
        SearchResponse response;
        SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().explain(Boolean.valueOf(false)).query(query).size(VitamConfiguration.getElasticSearchScrollLimit().intValue());
        if (trackTotalHits) {
            searchSourceBuilder.trackTotalHits(true);
        }
        if (null != filter) {
            searchSourceBuilder.postFilter(filter);
        }
        if (sorts != null) {
            sorts.forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).sort(arg_0));
        }
        if (null != esProjection) {
            searchSourceBuilder.fetchSource(esProjection, null);
        }
        SearchRequest searchRequest = new SearchRequest().indices((String[])indexAliases.stream().map(ElasticsearchIndexAlias::getName).toArray(String[]::new)).source(searchSourceBuilder).searchType(SearchType.DFS_QUERY_THEN_FETCH);
        if (scrollId != null && !scrollId.isEmpty()) {
            int limitES = limit != null && limit > 0 ? limit : 100;
            int scrollTimeoutES = scrollTimeout != null && scrollTimeout > 0 ? scrollTimeout : 60000;
            searchRequest.scroll(TimeValue.timeValueMillis((long)scrollTimeoutES));
            searchSourceBuilder.size(limitES);
            try {
                if (scrollId.equals(SCROLL_ACTIVATE_KEYWORD)) {
                    response = this.getClient().search(searchRequest, RequestOptions.DEFAULT);
                }
                response = this.getClient().scroll(new SearchScrollRequest(scrollId).scroll(new TimeValue((long)scrollTimeoutES)), RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                throw new DatabaseException((Throwable)e);
            }
        } else {
            if (offset != -1) {
                searchSourceBuilder.from(offset);
            }
            if (limit != -1) {
                searchSourceBuilder.size(limit.intValue());
            }
            if (facets != null && !facets.isEmpty()) {
                facets.forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
            }
            searchSourceBuilder.query(query);
            LOGGER.debug("ESReq: {}", (Object)searchRequest);
            try {
                response = this.getClient().search(searchRequest, RequestOptions.DEFAULT);
            }
            catch (ElasticsearchException e) {
                if (e.status() == RestStatus.BAD_REQUEST) {
                    throw new BadRequestException((Throwable)e);
                }
                throw new DatabaseException((Throwable)e);
            }
            catch (IOException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        if (response.status() != RestStatus.OK) {
            throw new DatabaseException("Error " + response.status() + " from : " + searchRequest + ":" + query);
        }
        return response;
    }

    public final SearchResponse search(ElasticsearchIndexAlias indexAlias, QueryBuilder query, QueryBuilder filter, String[] esProjection, List<SortBuilder<?>> sorts, int offset, Integer limit, List<AggregationBuilder> facets, String scrollId, Integer scrollTimeout, boolean trackTotalHits) throws DatabaseException, BadRequestException {
        return this.searchCrossIndices(Set.of(indexAlias), query, filter, esProjection, sorts, offset, limit, facets, scrollId, scrollTimeout, trackTotalHits);
    }

    public void clearScroll(String scrollId) throws DatabaseException {
        ClearScrollRequest request = new ClearScrollRequest();
        request.addScrollId(scrollId);
        try {
            ClearScrollResponse response = this.getClient().clearScroll(request, RequestOptions.DEFAULT);
            boolean success = response.isSucceeded();
            int released = response.getNumFreed();
            Asserts.check((boolean)success, (String)("clear scroll" + scrollId + " ko"));
            LOGGER.debug("clear scroll " + scrollId + " > success :" + success + ", released: " + released);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    private RestHighLevelClient createClient() {
        HttpHost[] hosts = new HttpHost[this.nodes.size()];
        for (int i = 0; i < this.nodes.size(); ++i) {
            ElasticsearchNode elasticsearchNode = this.nodes.get(i);
            hosts[i] = new HttpHost(elasticsearchNode.getHostName(), elasticsearchNode.getHttpPort(), "http");
        }
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])hosts).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectionRequestTimeout(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()).setConnectTimeout(VitamConfiguration.getConnectTimeout().intValue()).setSocketTimeout(VitamConfiguration.getReadTimeout().intValue()));
        return new RestHighLevelClient(restClientBuilder);
    }

    public void close() {
        try {
            this.getClient().close();
        }
        catch (IOException e) {
            throw new VitamFatalRuntimeException((Throwable)e);
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestHighLevelClient getClient() {
        RestHighLevelClient client = this.esClient.get();
        if (null == client) {
            ElasticsearchAccess elasticsearchAccess = this;
            synchronized (elasticsearchAccess) {
                if (null == this.esClient.get()) {
                    client = this.createClient();
                    this.esClient.set(client);
                }
            }
        }
        return client;
    }

    public List<ElasticsearchNode> getNodes() {
        return this.nodes;
    }

    public boolean checkConnection() {
        boolean bl;
        block8: {
            RestHighLevelClient clientCheck = this.createClient();
            try {
                boolean bl2 = bl = !clientCheck.cluster().health(new ClusterHealthRequest(), RequestOptions.DEFAULT).isTimedOut();
                if (clientCheck == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (clientCheck != null) {
                        try {
                            clientCheck.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn((Throwable)e);
                    return false;
                }
            }
            clientCheck.close();
        }
        return bl;
    }

    public String getInfo() {
        return this.clusterName;
    }

    public final void createIndexAndAliasIfAliasNotExists(ElasticsearchIndexAlias indexAlias, ElasticsearchIndexSettings indexSettings) throws DatabaseException {
        LOGGER.debug("createIndexAndAliasIfAliasNotExists: {}", (Object)indexAlias.getName());
        if (this.existsAlias(indexAlias)) {
            return;
        }
        ElasticsearchIndexAlias indexName = indexAlias.createUniqueIndexName();
        this.createIndexWithOptionalAlias(indexAlias.getName(), indexName.getName(), indexSettings.loadMapping(), indexSettings.getShards(), indexSettings.getReplicas());
    }

    public final void switchIndex(ElasticsearchIndexAlias indexAlias, ElasticsearchIndexAlias indexNameToSwitchTo) throws DatabaseException, IOException {
        if (!this.existsAlias(indexAlias)) {
            throw new DatabaseException(String.format("Alias does not exist : %s", indexAlias.getName()));
        }
        if (!this.existsIndex(indexNameToSwitchTo)) {
            throw new DatabaseException(String.format("New index does not exist : %s", indexNameToSwitchTo.getName()));
        }
        GetAliasesResponse actualIndex = this.getClient().indices().getAlias(new GetAliasesRequest(new String[]{indexAlias.getName()}), RequestOptions.DEFAULT);
        Map aliases = actualIndex.getAliases();
        String oldIndexName = null;
        if (!aliases.isEmpty()) {
            oldIndexName = (String)aliases.keySet().iterator().next();
        }
        LOGGER.debug("Alias (" + indexAlias.getName() + ") map to index (" + oldIndexName + ")");
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        IndicesAliasesRequest.AliasActions addNewIndexAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(indexNameToSwitchTo.getName()).alias(indexAlias.getName());
        request.addAliasAction(addNewIndexAliasAction);
        IndicesAliasesRequest.AliasActions deleteOldIndexAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(oldIndexName).alias(indexAlias.getName());
        request.addAliasAction(deleteOldIndexAliasAction);
        request.timeout(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()));
        request.masterNodeTimeout(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()));
        AcknowledgedResponse response = this.getClient().indices().updateAliases(request, RequestOptions.DEFAULT);
        if (!response.isAcknowledged()) {
            throw new DatabaseException("Could not switch alias index " + indexAlias.getName() + " from " + oldIndexName + " to " + indexNameToSwitchTo);
        }
    }

    @VisibleForTesting
    public final void deleteIndexByAliasForTesting(ElasticsearchIndexAlias indexAlias) throws DatabaseException {
        GetAliasesResponse aliasResponse;
        try {
            aliasResponse = this.getAlias(indexAlias);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
        for (Map.Entry entry : aliasResponse.getAliases().entrySet()) {
            this.deleteIndexForTesting((String)entry.getKey());
        }
    }

    @VisibleForTesting
    public final void deleteIndexForTesting(ElasticsearchIndexAlias indexAlias) throws DatabaseException {
        this.deleteIndexForTesting(indexAlias.getName());
    }

    private void deleteIndexForTesting(String indexFullName) throws DatabaseException {
        DeleteIndexRequest request = new DeleteIndexRequest(indexFullName);
        request.timeout(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()));
        request.masterNodeTimeout(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()));
        request.indicesOptions(IndicesOptions.STRICT_EXPAND_OPEN);
        try {
            AcknowledgedResponse deleteIndexResponse = this.getClient().indices().delete(request, RequestOptions.DEFAULT);
            if (!deleteIndexResponse.isAcknowledged()) {
                throw new DatabaseException("Error while deleting index " + indexFullName + ". Not acknowledged");
            }
        }
        catch (Exception exception) {
            if (exception instanceof ElasticsearchException && ((ElasticsearchException)((Object)exception)).status() == RestStatus.NOT_FOUND) {
                return;
            }
            throw new DatabaseException("Error while deleting index " + indexFullName, (Throwable)exception);
        }
    }

    public void delete(ElasticsearchIndexAlias indexAlias, List<String> ids) throws DatabaseException {
        UnmodifiableIterator idIterator = Iterators.partition(ids.iterator(), (int)VitamConfiguration.getMaxElasticsearchBulk());
        while (idIterator.hasNext()) {
            BulkResponse bulkResponse;
            BulkRequest bulkRequest = new BulkRequest();
            for (String id : (List)idIterator.next()) {
                bulkRequest.add(new DeleteRequest(indexAlias.getName(), id));
            }
            WriteRequest.RefreshPolicy refreshPolicy = idIterator.hasNext() ? WriteRequest.RefreshPolicy.NONE : WriteRequest.RefreshPolicy.IMMEDIATE;
            bulkRequest.setRefreshPolicy(refreshPolicy);
            if (bulkRequest.numberOfActions() == 0) continue;
            try {
                bulkResponse = this.getClient().bulk(bulkRequest, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                throw new DatabaseException("Bulk delete exception", (Throwable)e);
            }
            if (!bulkResponse.hasFailures()) continue;
            throw new DatabaseException("ES delete in error: " + bulkResponse.buildFailureMessage());
        }
    }

    private Settings createIndexSettings(int shards, int replicas) throws IOException {
        return Settings.builder().loadFromStream(ES_CONFIGURATION_FILE, ElasticsearchAccess.class.getResourceAsStream(ES_CONFIGURATION_FILE), false).put(NUMBER_OF_SHARDS, shards).put(NUMBER_OF_REPLICAS, replicas).build();
    }
}

