/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mongodb.MongoException;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.builder.query.NopQuery;
import fr.gouv.vitam.common.database.builder.query.PathQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Delete;
import fr.gouv.vitam.common.database.builder.request.single.Insert;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.builder.request.single.Update;
import fr.gouv.vitam.common.database.collections.DynamicParserTokens;
import fr.gouv.vitam.common.database.collections.VitamCollection;
import fr.gouv.vitam.common.database.parser.request.adapter.SingleVarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.UpdateParserSingle;
import fr.gouv.vitam.common.database.server.DbRequestHelper;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.database.server.DocumentValidator;
import fr.gouv.vitam.common.database.server.MongoDbInMemory;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.database.server.mongodb.EmptyMongoCursor;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.database.translators.elasticsearch.QueryToElasticsearch;
import fr.gouv.vitam.common.database.translators.elasticsearch.SelectToElasticsearch;
import fr.gouv.vitam.common.database.translators.mongodb.QueryToMongodb;
import fr.gouv.vitam.common.database.translators.mongodb.SelectToMongodb;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.SetUtils;
import org.bson.conversions.Bson;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortBuilder;

public class DbRequestSingle {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DbRequestSingle.class);
    private final VitamCollection<VitamDocument<?>> vitamCollection;
    private final VarNameAdapter vaNameAdapter;
    private final OntologyLoader ontologyLoader;
    private final ElasticsearchIndexAlias elasticsearchIndexAlias;
    private long count = 0L;
    private long total = 0L;
    private long offset = 0L;
    private long limit = 0L;

    public DbRequestSingle(VitamCollection<VitamDocument<?>> collection, OntologyLoader ontologyLoader, ElasticsearchIndexAlias elasticsearchIndexAlias) {
        this.vitamCollection = collection;
        this.ontologyLoader = ontologyLoader;
        this.elasticsearchIndexAlias = elasticsearchIndexAlias;
        this.vaNameAdapter = new SingleVarNameAdapter();
    }

    public DbRequestResult execute(Select request) throws InvalidParseOperationException, DatabaseException, BadRequestException, InvalidCreateOperationException, VitamDBException, SchemaValidationException {
        DynamicParserTokens parserTokens = new DynamicParserTokens(this.vitamCollection.getVitamDescriptionResolver(), this.ontologyLoader.loadOntologies());
        return this.findDocuments((JsonNode)request.getFinalSelect(), parserTokens, true);
    }

    public DbRequestResult executeQueryWithoutRestrictionOnCurrentTenant(Select request) throws InvalidParseOperationException, DatabaseException, BadRequestException, InvalidCreateOperationException, VitamDBException, SchemaValidationException {
        DynamicParserTokens parserTokens = new DynamicParserTokens(this.vitamCollection.getVitamDescriptionResolver(), this.ontologyLoader.loadOntologies());
        return this.findDocuments((JsonNode)request.getFinalSelect(), parserTokens, false);
    }

    public DbRequestResult execute(Insert request, Integer version, DocumentValidator documentValidator) throws InvalidParseOperationException, DatabaseException, BadRequestException, InvalidCreateOperationException, VitamDBException, SchemaValidationException {
        ArrayNode data = request.getDatas();
        return this.insertDocuments(data, version, documentValidator);
    }

    public DbRequestResult execute(Delete request) throws InvalidParseOperationException, DatabaseException, BadRequestException, InvalidCreateOperationException, VitamDBException, SchemaValidationException {
        DynamicParserTokens parserTokens = new DynamicParserTokens(this.vitamCollection.getVitamDescriptionResolver(), this.ontologyLoader.loadOntologies());
        return this.deleteDocuments((JsonNode)request.getFinalDelete(), parserTokens);
    }

    public DbRequestResult execute(Update request, DocumentValidator documentValidator) throws InvalidParseOperationException, DatabaseException, BadRequestException, InvalidCreateOperationException, VitamDBException, SchemaValidationException {
        DynamicParserTokens parserTokens = new DynamicParserTokens(this.vitamCollection.getVitamDescriptionResolver(), this.ontologyLoader.loadOntologies());
        return this.updateDocuments((JsonNode)request.getFinalUpdate(), documentValidator, parserTokens);
    }

    private DbRequestResult insertDocuments(ArrayNode arrayNode, Integer version, DocumentValidator documentValidator) throws InvalidParseOperationException, SchemaValidationException, DatabaseException {
        ArrayList vitamDocumentList = new ArrayList();
        for (JsonNode objNode : arrayNode) {
            VitamDocument obj = (VitamDocument)((Object)JsonHandler.getFromJsonNode((JsonNode)objNode, this.vitamCollection.getClasz()));
            obj.remove("_score");
            obj.append("_v", version);
            if (this.vitamCollection.isMultiTenant()) {
                obj.append("_tenant", ParameterHelper.getTenantParameter());
            }
            if (!obj.containsKey("_id")) {
                GUID uuid = GUIDFactory.newGUID();
                obj.put("_id", uuid.toString());
            }
            documentValidator.validateDocument(JsonHandler.toJsonNode((Object)((Object)obj)));
            vitamDocumentList.add(obj);
        }
        MongoCollection<VitamDocument<?>> collection = this.vitamCollection.getCollection();
        try {
            collection.insertMany(vitamDocumentList);
        }
        catch (MongoException e) {
            throw new DatabaseException((Throwable)e);
        }
        this.insertToElasticsearch(vitamDocumentList);
        return new DbRequestResult().setCount(vitamDocumentList.size()).setTotal(vitamDocumentList.size());
    }

    private void insertToElasticsearch(List<VitamDocument<?>> vitamDocumentList) throws DatabaseException {
        if (this.vitamCollection.getEsClient() == null) {
            return;
        }
        this.vitamCollection.getEsClient().indexEntries(this.elasticsearchIndexAlias, vitamDocumentList, true);
    }

    private DbRequestResult findDocuments(JsonNode select, DynamicParserTokens parserTokens, boolean restrictOnCurrentTenant) throws DatabaseException, BadRequestException, VitamDBException {
        MongoCursor<VitamDocument<?>> cursor = this.search(select, parserTokens, restrictOnCurrentTenant);
        return new DbRequestResult().setCursor(cursor).setTotal(this.total > 0L ? this.total : this.count).setCount(this.count).setLimit(this.limit).setOffset(this.offset);
    }

    private MongoCursor<VitamDocument<?>> search(JsonNode select, DynamicParserTokens parserTokens, boolean restrictOnCurrentTenant) throws DatabaseException, BadRequestException, VitamDBException {
        try {
            SelectParserSingle parser = new SelectParserSingle(this.vaNameAdapter);
            parser.parse(select);
            if (restrictOnCurrentTenant && this.vitamCollection.isMultiTenant()) {
                parser.addCondition((Query)QueryHelper.eq((String)VitamFieldsHelper.tenant(), (long)ParameterHelper.getTenantParameter().intValue()));
            }
            if (this.vitamCollection.getEsClient() != null) {
                return this.selectElasticsearchExecute(parser, parserTokens);
            }
            return this.selectMongoDbExecute(parser);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error("find Document Exception", e);
            throw new DatabaseException(e);
        }
    }

    private MongoCursor<VitamDocument<?>> selectElasticsearchExecute(SelectParserSingle parser, DynamicParserTokens parserTokens) throws InvalidParseOperationException, InvalidCreateOperationException, DatabaseException, BadRequestException, VitamDBException {
        SelectToElasticsearch requestToEs = new SelectToElasticsearch(parser);
        QueryBuilder query = QueryToElasticsearch.getCommand(requestToEs.getNthQuery(0), parser.getAdapter(), parserTokens);
        List<SortBuilder<?>> sorts = requestToEs.getFinalOrderBy(this.vitamCollection.isUseScore(), parserTokens);
        this.offset = requestToEs.getFinalOffset();
        this.limit = requestToEs.getFinalLimit();
        SearchResponse elasticSearchResponse = this.search(query, null, sorts, requestToEs.getFinalOffset(), requestToEs.getFinalLimit());
        if (elasticSearchResponse.status() != RestStatus.OK) {
            return new EmptyMongoCursor();
        }
        SearchHits hits = elasticSearchResponse.getHits();
        if (hits.getTotalHits().value == 0L) {
            return new EmptyMongoCursor();
        }
        this.total = hits.getTotalHits().value;
        Iterator iterator = hits.iterator();
        this.count = hits.getHits().length;
        ArrayList<String> list = new ArrayList<String>((int)this.count);
        ArrayList<Float> listFloat = new ArrayList<Float>((int)this.count);
        while (iterator.hasNext()) {
            SearchHit hit = (SearchHit)iterator.next();
            list.add(hit.getId());
            listFloat.add(Float.valueOf(hit.getScore()));
        }
        parser.getRequest().setQuery((Query)new NopQuery());
        return this.selectMongoDbExecute(parser, list, listFloat);
    }

    private MongoCursor<VitamDocument<?>> selectMongoDbExecute(SelectParserSingle parser, List<String> list, List<Float> score) throws InvalidParseOperationException, VitamDBException {
        return DbRequestHelper.selectMongoDbExecuteThroughFakeMongoCursor(this.vitamCollection, parser, list, score);
    }

    private MongoCursor<VitamDocument<?>> selectMongoDbExecute(SelectParserSingle parser) throws InvalidParseOperationException {
        SelectToMongodb selectToMongoDb = new SelectToMongodb(parser);
        Bson initialCondition = QueryToMongodb.getCommand(selectToMongoDb.getSingleSelect().getQuery());
        Bson projection = selectToMongoDb.getFinalProjection();
        Bson orderBy = selectToMongoDb.getFinalOrderBy();
        int offset2 = selectToMongoDb.getFinalOffset();
        int limit2 = selectToMongoDb.getFinalLimit();
        MongoCollection<VitamDocument<?>> collection = this.vitamCollection.getCollection();
        FindIterable find = collection.find(initialCondition).skip(offset2);
        this.total = collection.countDocuments(initialCondition);
        if (projection != null) {
            find = find.projection(projection);
        }
        if (orderBy != null) {
            find = find.sort(orderBy);
        }
        if (limit2 > 0) {
            find = find.limit(limit2);
        }
        if (this.offset == 0L) {
            this.offset = offset2;
        }
        if (this.limit == 0L) {
            this.limit = limit2;
        }
        if (this.offset < this.total) {
            this.count = this.total - this.offset;
            if (this.count > this.limit) {
                this.count = this.limit;
            }
        }
        return find.iterator();
    }

    private SearchResponse search(QueryBuilder query, QueryBuilder filter, List<SortBuilder<?>> sorts, int offset, int limit) throws DatabaseException, BadRequestException {
        return this.vitamCollection.getEsClient().search(this.elasticsearchIndexAlias, query, filter, VitamDocument.ES_FILTER_OUT, sorts, offset, limit);
    }

    private DbRequestResult updateDocuments(JsonNode request, DocumentValidator documentValidator, DynamicParserTokens parserTokens) throws InvalidParseOperationException, DatabaseException, BadRequestException, InvalidCreateOperationException, VitamDBException, SchemaValidationException {
        UpdateParserSingle parser = new UpdateParserSingle(this.vaNameAdapter);
        parser.parse(request);
        if (this.vitamCollection.isMultiTenant()) {
            parser.addCondition((Query)QueryHelper.eq((String)VitamFieldsHelper.tenant(), (long)ParameterHelper.getTenantParameter().intValue()));
        }
        Select selectQuery = new Select();
        selectQuery.setQuery(parser.getRequest().getQuery());
        MongoCursor<VitamDocument<?>> searchResult = this.search((JsonNode)selectQuery.getFinalSelect(), parserTokens, true);
        if (searchResult == null || !searchResult.hasNext()) {
            throw new DatabaseException("Document not found");
        }
        ArrayList<VitamDocument> listDocuments = new ArrayList<VitamDocument>();
        while (searchResult.hasNext()) {
            listDocuments.add((VitamDocument)((Object)searchResult.next()));
        }
        searchResult.close();
        HashMap<String, List<String>> diffs = new HashMap<String, List<String>>();
        ArrayList listUpdatedDocuments = new ArrayList();
        MongoCollection<VitamDocument<?>> collection = this.vitamCollection.getCollection();
        for (VitamDocument document : listDocuments) {
            document.remove("_score");
            String documentId = document.getId();
            String documentBeforeUpdate = JsonHandler.prettyPrint((Object)((Object)document));
            VitamDocument updatedDocument = null;
            int nbTry = 0;
            boolean modified = false;
            boolean updated = false;
            while (!updated && nbTry < VitamConfiguration.getOptimisticLockRetryNumber()) {
                if (nbTry > 0) {
                    document = (VitamDocument)((Object)collection.find(Filters.eq((String)"_id", (Object)documentId)).first());
                    documentBeforeUpdate = JsonHandler.prettyPrint((Object)((Object)document));
                    if (null == document) {
                        throw new DatabaseException("[Optimistic_Lock]: Can not modify a deleted Document");
                    }
                }
                ++nbTry;
                JsonNode jsonDocument = JsonHandler.toJsonNode((Object)((Object)document));
                MongoDbInMemory mongoInMemory = new MongoDbInMemory(jsonDocument, parserTokens);
                ObjectNode updatedJsonDocument = (ObjectNode)mongoInMemory.getUpdateJson(request, false, this.vaNameAdapter);
                documentValidator.validateDocument((JsonNode)updatedJsonDocument);
                updatedDocument = document.newInstance((JsonNode)updatedJsonDocument);
                if (document.equals((Object)updatedDocument)) break;
                modified = true;
                updatedDocument.put("_v", document.getVersion() + 1);
                Bson condition = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)documentId), Filters.eq((String)"_v", (Object)document.getVersion())});
                try {
                    UpdateResult result = collection.replaceOne(condition, updatedDocument);
                    updated = result.getModifiedCount() == 1L;
                }
                catch (MongoException e) {
                    LOGGER.warn("Update Document error : " + e.getMessage());
                }
                if (updated) continue;
                LOGGER.error("[Optimistic_Lock]: optimistic lock occurs while update document with id (" + documentId + ") of the collection " + this.vitamCollection.getName() + " retry number = " + nbTry);
                try {
                    TimeUnit.MILLISECONDS.sleep(ThreadLocalRandom.current().nextInt(VitamConfiguration.getOptimisticLockSleepTime()));
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e1);
                    throw new DatabaseException((Throwable)e1);
                }
            }
            if (modified && !updated) {
                throw new DatabaseException("[Optimistic_Lock]: Can not modify Document");
            }
            if (!modified) continue;
            listUpdatedDocuments.add(updatedDocument);
            String documentAfterUpdate = JsonHandler.prettyPrint(updatedDocument);
            diffs.put(documentId, VitamDocument.getConcernedDiffLines(VitamDocument.getUnifiedDiff(documentBeforeUpdate, documentAfterUpdate)));
        }
        if (!listUpdatedDocuments.isEmpty()) {
            this.insertToElasticsearch(listUpdatedDocuments);
        }
        return new DbRequestResult().setCount(listUpdatedDocuments.size()).setTotal(listUpdatedDocuments.size()).setDiffs(diffs);
    }

    private DbRequestResult deleteDocuments(JsonNode request, DynamicParserTokens parserTokens) throws DatabaseException, BadRequestException, InvalidCreateOperationException, InvalidParseOperationException, VitamDBException {
        DeleteResult result;
        SelectParserSingle parser = new SelectParserSingle(this.vaNameAdapter);
        parser.parse(request);
        parser.addProjection(JsonHandler.createObjectNode(), JsonHandler.createObjectNode().put("_id", 1));
        MongoCursor<VitamDocument<?>> searchResult = this.search((JsonNode)parser.getRequest().getFinalSelect(), parserTokens, true);
        if (searchResult == null || !searchResult.hasNext()) {
            throw new DatabaseException("Document not found");
        }
        ArrayList<String> ids = new ArrayList<String>();
        while (searchResult.hasNext()) {
            String documentId = ((VitamDocument)((Object)searchResult.next())).getId();
            ids.add(documentId);
        }
        PathQuery newQuery = QueryHelper.path((String[])ids.toArray(new String[0]));
        searchResult.close();
        Bson filter = QueryToMongodb.getCommand((Query)newQuery);
        try {
            result = this.vitamCollection.getCollection().deleteMany(filter);
        }
        catch (MongoException e) {
            LOGGER.warn((Throwable)e);
            throw new DatabaseException((Throwable)e);
        }
        this.deleteFromElasticSearch(ids);
        return new DbRequestResult().setCount(result.getDeletedCount()).setTotal(result.getDeletedCount());
    }

    private void deleteFromElasticSearch(List<String> list) throws DatabaseException {
        if (this.vitamCollection.getEsClient() == null || list.isEmpty()) {
            return;
        }
        this.vitamCollection.getEsClient().delete(this.elasticsearchIndexAlias, list);
    }

    public void replaceDocument(JsonNode document, String identifierValue, String identifierKey, VitamCollection<VitamDocument<?>> vitamCollection) throws DatabaseException {
        this.replaceDocuments(Collections.singletonMap(identifierValue, document), identifierKey, vitamCollection);
    }

    public void replaceDocuments(Map<String, JsonNode> documentByIdentifiers, String identifierKey, VitamCollection<VitamDocument<?>> vitamCollection) throws DatabaseException {
        List dbDocuments;
        MongoCollection<VitamDocument<?>> collection = vitamCollection.getCollection();
        if (documentByIdentifiers.isEmpty()) {
            return;
        }
        Bson documentCondition = this.getDocumentSelectionQuery(documentByIdentifiers.keySet(), identifierKey, vitamCollection);
        Bson projection = Projections.include((String[])((String[])Set.of("_id", "_v", identifierKey).toArray(String[]::new)));
        try (MongoCursor documentsInDataBase = vitamCollection.getCollection().find(documentCondition).projection(projection).cursor();){
            dbDocuments = IteratorUtils.toList((Iterator)documentsInDataBase);
        }
        Map<String, VitamDocument> dbDocumentsByIdentifiers = dbDocuments.stream().collect(Collectors.toMap(doc -> (String)doc.get(identifierKey), doc -> doc));
        SetUtils.SetView missingIdentifiers = SetUtils.difference(documentByIdentifiers.keySet(), dbDocumentsByIdentifiers.keySet());
        if (!missingIdentifiers.isEmpty()) {
            throw new DatabaseException("Documents not found with " + identifierKey + " in [" + (Set)missingIdentifiers + "]");
        }
        ArrayList<ReplaceOneModel> replaceOneModels = new ArrayList<ReplaceOneModel>();
        ArrayList updatedDocuments = new ArrayList();
        for (String identifier : dbDocumentsByIdentifiers.keySet()) {
            VitamDocument dbDocument = dbDocumentsByIdentifiers.get(identifier);
            JsonNode document = documentByIdentifiers.get(identifier);
            ((ObjectNode)document).put("_id", dbDocument.getId());
            VitamDocument updatedDocument = dbDocument.newInstance(document);
            updatedDocument.put("_v", dbDocument.getVersion() + 1);
            updatedDocuments.add(updatedDocument);
            Bson condition = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)dbDocument.getId()), Filters.eq((String)"_v", (Object)dbDocument.getVersion())});
            replaceOneModels.add(new ReplaceOneModel(condition, updatedDocument));
        }
        try {
            BulkWriteResult bulkWriteResult = collection.bulkWrite(replaceOneModels, new BulkWriteOptions().ordered(false));
            if (bulkWriteResult.getMatchedCount() != dbDocumentsByIdentifiers.size()) {
                throw new DatabaseException(String.format("Error while bulk update document count : %s != size : %s :", bulkWriteResult.getModifiedCount(), dbDocumentsByIdentifiers.size()));
            }
        }
        catch (MongoException e) {
            throw new DatabaseException("Could not update documents in DB", (Throwable)e);
        }
        this.insertToElasticsearch(updatedDocuments);
    }

    private Bson getDocumentSelectionQuery(Collection<String> identifierValues, String identifierKey, VitamCollection<VitamDocument<?>> vitamCollection) {
        if (vitamCollection.isMultiTenant()) {
            return Filters.and((Bson[])new Bson[]{Filters.in((String)identifierKey, identifierValues), Filters.eq((String)"_tenant", (Object)ParameterHelper.getTenantParameter())});
        }
        return Filters.in((String)identifierKey, identifierValues);
    }
}

