/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request.multiple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.RequestMultiple;
import fr.gouv.vitam.common.database.parser.query.QueryParserHelper;
import fr.gouv.vitam.common.database.parser.query.helper.QueryDepthHelper;
import fr.gouv.vitam.common.database.parser.request.AbstractParser;
import fr.gouv.vitam.common.database.parser.request.GlobalDatasParser;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.Map;

public abstract class RequestParserMultiple
extends AbstractParser<RequestMultiple> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RequestParserMultiple.class);
    private static final int DEFAULT_RELATIVE_DEPTH = 1000;
    protected int lastDepth = 0;

    public RequestParserMultiple() {
        this.request = this.getNewRequest();
        this.adapter = new VarNameAdapter();
    }

    public RequestParserMultiple(VarNameAdapter adapter) {
        this.request = this.getNewRequest();
        this.adapter = adapter;
    }

    private void internalParse() throws InvalidParseOperationException {
        GlobalDatasParser.sanityRequestCheck(this.sourceRequest);
        if (this.request != null) {
            ((RequestMultiple)this.request).reset();
        } else {
            this.request = this.getNewRequest();
        }
        this.lastDepth = 0;
        this.hasFullTextQuery = false;
        if (this.rootNode == null || this.rootNode.isMissingNode()) {
            throw new InvalidParseOperationException("The current Node is missing(empty): RequestRoot");
        }
        this.rootParse(this.rootNode.get(BuilderToken.GLOBAL.ROOTS.exactToken()));
        this.queryParse(this.rootNode.get(BuilderToken.GLOBAL.QUERY.exactToken()));
        this.filterParse(this.rootNode.get(BuilderToken.GLOBAL.FILTER.exactToken()));
    }

    @Override
    protected void parseJson(JsonNode jsonRequest) throws InvalidParseOperationException {
        super.parseJson(jsonRequest);
        this.internalParse();
    }

    protected void parseQueryOnly(String query) throws InvalidParseOperationException {
        GlobalDatasParser.sanityRequestCheck(query);
        this.sourceRequest = query;
        if (this.request != null) {
            ((RequestMultiple)this.request).reset();
        } else {
            this.request = this.getNewRequest();
        }
        this.lastDepth = 0;
        this.hasFullTextQuery = false;
        this.rootNode = JsonHandler.getFromString((String)query);
        if (this.rootNode.isMissingNode()) {
            throw new InvalidParseOperationException("The current Node is missing(empty): RequestRoot");
        }
        this.rootParse((JsonNode)JsonHandler.createArrayNode());
        this.queryParse(this.rootNode);
        this.filterParse((JsonNode)JsonHandler.createObjectNode());
    }

    protected void rootParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            return;
        }
        GlobalDatas.sanityParametersCheck((String)rootNode.toString(), (int)1000);
        try {
            ((RequestMultiple)this.request).addRoots((ArrayNode)rootNode);
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Roots: " + rootNode, (Throwable)e);
        }
    }

    protected void filterParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            return;
        }
        GlobalDatas.sanityParametersCheck((String)rootNode.toString(), (int)10);
        try {
            this.parseOrderByFilter(rootNode);
            ((RequestMultiple)this.request).setFilter(rootNode);
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Filter: " + rootNode, (Throwable)e);
        }
    }

    protected void queryParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            return;
        }
        try {
            if (rootNode.isArray()) {
                int i = 0;
                for (JsonNode level : rootNode) {
                    this.analyzeRootQuery(level);
                    if (i == 1 && ((Query)((RequestMultiple)this.request).getQueries().get(i)).getQUERY() == BuilderToken.QUERY.PATH) {
                        throw new InvalidParseOperationException("Parse in error for Query since PATH is only allowed as first query: " + (i + 1));
                    }
                    ++i;
                }
            } else {
                this.analyzeRootQuery(rootNode);
            }
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Query: " + rootNode, (Throwable)e);
        }
    }

    protected void analyzeRootQuery(JsonNode command) throws InvalidParseOperationException, InvalidCreateOperationException {
        JsonNode jdepth;
        if (command == null) {
            throw new InvalidParseOperationException("Not correctly parsed");
        }
        this.hasFullTextCurrentQuery = false;
        int relativedepth = 1;
        int exactdepth = 0;
        boolean isDepth = false;
        if (command.has(BuilderToken.QUERYARGS.EXACTDEPTH.exactToken())) {
            jdepth = ((ObjectNode)command).remove(BuilderToken.QUERYARGS.EXACTDEPTH.exactToken());
            if (jdepth != null) {
                exactdepth = jdepth.asInt();
                if (exactdepth == -1) {
                    exactdepth = 100;
                }
                isDepth = true;
            }
            ((ObjectNode)command).remove(BuilderToken.QUERYARGS.DEPTH.exactToken());
        } else if (command.has(BuilderToken.QUERYARGS.DEPTH.exactToken())) {
            jdepth = ((ObjectNode)command).remove(BuilderToken.QUERYARGS.DEPTH.exactToken());
            if (jdepth != null) {
                relativedepth = jdepth.asInt();
                isDepth = true;
            }
        } else {
            relativedepth = 1000;
        }
        if (command.size() == 0) {
            return;
        }
        Map.Entry queryItem = JsonHandler.checkUnicity((String)"RootRequest", (JsonNode)command);
        Object query = null;
        if (((String)queryItem.getKey()).equalsIgnoreCase(BuilderToken.QUERY.PATH.exactToken())) {
            if (isDepth) {
                throw new InvalidParseOperationException("Invalid combined command Depth and Path: " + command);
            }
            int prevDepth = this.lastDepth;
            ArrayNode array = (ArrayNode)queryItem.getValue();
            query = QueryParserHelper.path((JsonNode)array, this.adapter);
            this.lastDepth = query.getExtraInfo();
            LOGGER.debug("Depth step: {}:{}", (Object)this.lastDepth, (Object)(this.lastDepth - prevDepth));
        } else {
            query = this.analyzeOneCommand((String)queryItem.getKey(), (JsonNode)queryItem.getValue());
            if (query == null) {
                return;
            }
            int prevDepth = this.lastDepth;
            if (exactdepth > 0) {
                this.lastDepth = exactdepth;
            } else if (relativedepth != 0) {
                this.lastDepth += relativedepth;
            }
            LOGGER.debug("Depth step: {}:{}:{}:{}:{}", new Object[]{this.lastDepth, this.lastDepth - prevDepth, relativedepth, exactdepth, isDepth});
        }
        if (this.adapter.metadataAdapter()) {
            QueryDepthHelper.HELPER.setDepths(query.setFullText(this.hasFullTextCurrentQuery), exactdepth, relativedepth);
        } else {
            query.setFullText(this.hasFullTextCurrentQuery);
            if (exactdepth != 0) {
                query.setExactDepthLimit(exactdepth);
            } else {
                query.setRelativeDepthLimit(relativedepth);
            }
        }
        this.hasFullTextQuery |= this.hasFullTextCurrentQuery;
        ((RequestMultiple)this.request).addQueries(new Query[]{query});
    }

    public String toString() {
        return ((RequestMultiple)this.request).toString() + "\n\tLastLevel: " + this.lastDepth;
    }

    @Override
    public RequestMultiple getRequest() {
        return (RequestMultiple)this.request;
    }

    @Override
    public final int getLastDepth() {
        return this.lastDepth;
    }

    @Override
    public boolean hintCache() {
        JsonNode jsonNode = ((RequestMultiple)this.request).getFilter().get(BuilderToken.SELECTFILTER.HINT.exactToken());
        if (jsonNode == null) {
            return false;
        }
        ArrayNode array = (ArrayNode)jsonNode;
        for (JsonNode node : array) {
            if (!BuilderToken.FILTERARGS.CACHE.exactToken().equals(node.asText())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hintNoTimeout() {
        JsonNode jsonNode = ((RequestMultiple)this.request).getFilter().get(BuilderToken.SELECTFILTER.HINT.exactToken());
        if (jsonNode != null) {
            ArrayNode array = (ArrayNode)jsonNode;
            for (JsonNode node : array) {
                if (!BuilderToken.FILTERARGS.NOTIMEOUT.exactToken().equals(node.asText())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public BuilderToken.FILTERARGS model() {
        JsonNode jsonNode = ((RequestMultiple)this.request).getFilter().get(BuilderToken.SELECTFILTER.HINT.exactToken());
        if (jsonNode != null) {
            ArrayNode array = (ArrayNode)jsonNode;
            for (JsonNode node : array) {
                if (BuilderToken.FILTERARGS.UNITS.exactToken().equals(node.asText())) {
                    return BuilderToken.FILTERARGS.UNITS;
                }
                if (!BuilderToken.FILTERARGS.OBJECTGROUPS.exactToken().equals(node.asText())) continue;
                return BuilderToken.FILTERARGS.OBJECTGROUPS;
            }
        }
        return BuilderToken.FILTERARGS.UNITS;
    }

    public boolean trackTotalHits() {
        JsonNode jsonNode = ((RequestMultiple)this.request).getFilter().get(BuilderToken.SELECTFILTER.TRACK_TOTAL_HITS.exactToken());
        return jsonNode != null && jsonNode.isBoolean() && jsonNode.booleanValue();
    }

    public String getFinalScrollId() {
        JsonNode node = ((RequestMultiple)this.request).getFilter().get(BuilderToken.SELECTFILTER.SCROLL_ID.exactToken());
        if (node != null) {
            return node.asText();
        }
        return "";
    }

    public int getFinalScrollTimeout() {
        JsonNode node = ((RequestMultiple)this.request).getFilter().get(BuilderToken.SELECTFILTER.SCROLL_TIMEOUT.exactToken());
        if (node != null) {
            return node.asInt();
        }
        return 0;
    }
}

