/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request.multiple;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.multiple.DeleteParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.InsertParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;

public class RequestParserHelper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RequestParserHelper.class);

    private RequestParserHelper() {
    }

    public static RequestParserMultiple getParser(JsonNode jsonRequest) throws InvalidParseOperationException {
        return RequestParserHelper.getParser(jsonRequest, new VarNameAdapter());
    }

    public static RequestParserMultiple getParser(JsonNode jsonRequest, VarNameAdapter varNameAdapter) throws InvalidParseOperationException {
        if (jsonRequest.get(BuilderToken.GLOBAL.PROJECTION.exactToken()) != null) {
            LOGGER.debug("SELECT");
            SelectParserMultiple selectParser = new SelectParserMultiple(varNameAdapter);
            selectParser.parse(jsonRequest);
            return selectParser;
        }
        if (jsonRequest.get(BuilderToken.GLOBAL.DATA.exactToken()) != null) {
            LOGGER.debug("INSERT");
            InsertParserMultiple insertParser = new InsertParserMultiple(varNameAdapter);
            insertParser.parse(jsonRequest);
            return insertParser;
        }
        if (jsonRequest.get(BuilderToken.GLOBAL.ACTION.exactToken()) != null) {
            LOGGER.debug("UPDATE");
            UpdateParserMultiple updateParser = new UpdateParserMultiple(varNameAdapter);
            updateParser.parse(jsonRequest);
            return updateParser;
        }
        LOGGER.debug("DELETE");
        DeleteParserMultiple deleteParser = new DeleteParserMultiple(varNameAdapter);
        deleteParser.parse(jsonRequest);
        return deleteParser;
    }
}

