/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request.adapter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import java.util.Iterator;
import java.util.Map;

public class VarNameAdapter {
    public boolean metadataAdapter() {
        return false;
    }

    public String getVariableName(String name) throws InvalidParseOperationException {
        if (name.charAt(0) == '_') {
            int pos = name.indexOf(46);
            String realname = pos > 1 ? name.substring(1, pos) : name.substring(1);
            if (!this.metadataAdapter() && ParserTokens.PROJECTIONARGS.notAllowedOnSetExternal(name)) {
                throw new InvalidParseOperationException("Illegal variable name found: " + name);
            }
            if (!this.metadataAdapter() && !ParserTokens.PROJECTIONARGS.isValid(realname)) {
                throw new InvalidParseOperationException("Illegal variable name found: " + name);
            }
        }
        return null;
    }

    public void setVarsValue(ObjectNode currentObject, JsonNode request) throws InvalidParseOperationException {
        Iterator iterator = request.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String name = (String)entry.getKey();
            String newname = this.getVariableName(name);
            if (newname != null) {
                name = newname;
            }
            currentObject.set(name, (JsonNode)entry.getValue());
        }
    }

    public void setVar(BuilderToken.QUERY req, ObjectNode currentObject, JsonNode request) throws InvalidParseOperationException {
        String variableName = request.asText();
        String val = this.getVariableName(variableName);
        if (val != null) {
            variableName = val;
        }
        currentObject.put(req.exactToken(), variableName);
    }

    public void setVarArray(ArrayNode array) throws InvalidParseOperationException {
        ArrayNode copy = array.deepCopy();
        array.removeAll();
        for (JsonNode value : copy) {
            String name = this.getVariableName(value.asText());
            if (name != null) {
                array.add(name);
                continue;
            }
            array.add(value.asText());
        }
    }

    public void checkNoParameter(JsonNode request) throws InvalidParseOperationException {
        Iterator iterator = request.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (((String)entry.getKey()).charAt(0) != '#' && ((JsonNode)entry.getValue()).asText().charAt(0) != '#') continue;
            throw new InvalidParseOperationException("Parameter using '#' not allowed in Rename action: " + request);
        }
    }
}

