/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;

public class GlobalDatasParser
extends GlobalDatas {
    private static final String DATE_INVALID = "Date invalid";
    public static final int DEFAULT_LIMIT_REQUEST = 100000000;
    public static int limitRequest = 100000000;
    public static final int NB_ACTIONS = 10000;
    public static final int DEFAULT_SCROLL_TIMEOUT = 60000;

    protected GlobalDatasParser() {
    }

    public static final void sanityRequestCheck(String arg) throws InvalidParseOperationException {
        GlobalDatas.sanityCheck((String)arg, (int)limitRequest);
    }

    public static final int getJsonNodedepth(JsonNode jsonNode) {
        ParametersChecker.checkParameter((String)"jsonNode is a mandatory parameter", (Object[])new Object[]{jsonNode});
        int depth = 0;
        boolean hasArrayNode = false;
        for (JsonNode node : jsonNode) {
            int tempDepth;
            if ((node instanceof ObjectNode || node instanceof ArrayNode) && (tempDepth = GlobalDatasParser.getJsonNodedepth(node)) > depth) {
                depth = tempDepth;
            }
            if (!(node instanceof ArrayNode)) continue;
            hasArrayNode = true;
        }
        if (hasArrayNode) {
            return depth;
        }
        return 1 + depth;
    }

    public static final Object getValue(JsonNode value) throws InvalidParseOperationException {
        if (value == null) {
            throw new InvalidParseOperationException("Not correctly parsed");
        }
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isFloat()) {
            return Float.valueOf(value.floatValue());
        }
        if (value.isInt()) {
            return value.asInt();
        }
        if (value.isDouble()) {
            return value.asDouble();
        }
        if (value.canConvertToLong()) {
            return value.asLong();
        }
        if (value.has("$date")) {
            try {
                return LocalDateUtil.getDate((String)value.get("$date").asText());
            }
            catch (ParseException e) {
                throw new InvalidParseOperationException(DATE_INVALID);
            }
        }
        if (value.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonNode item : (ArrayNode)value) {
                list.add(GlobalDatasParser.getValue(item));
            }
            return list;
        }
        return value.asText();
    }

    public static final ArrayNode getArray(JsonNode value) throws InvalidParseOperationException {
        if (value == null) {
            throw new InvalidParseOperationException("Not correctly parsed");
        }
        if (value instanceof ArrayNode) {
            return (ArrayNode)value;
        }
        ArrayNode node = JsonHandler.createArrayNode();
        if (value.isBoolean()) {
            return node.add(value.asBoolean());
        }
        if (value.isFloat()) {
            return node.add(value.floatValue());
        }
        if (value.isInt()) {
            return node.add(value.asInt());
        }
        if (value.isDouble()) {
            return node.add(value.asDouble());
        }
        if (value.canConvertToLong()) {
            return node.add(value.asLong());
        }
        if (value.has("$date")) {
            try {
                return node.add(LocalDateUtil.getFormattedDate((Date)LocalDateUtil.getDate((String)value.get("$date").asText())));
            }
            catch (ParseException e) {
                throw new InvalidParseOperationException(DATE_INVALID);
            }
        }
        return node.add(value.asText());
    }
}

