/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.query;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.query.NopQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.parser.query.CompareQuery;
import fr.gouv.vitam.common.database.parser.query.ExistsQuery;
import fr.gouv.vitam.common.database.parser.query.InQuery;
import fr.gouv.vitam.common.database.parser.query.MatchQuery;
import fr.gouv.vitam.common.database.parser.query.MltQuery;
import fr.gouv.vitam.common.database.parser.query.PathQuery;
import fr.gouv.vitam.common.database.parser.query.RangeQuery;
import fr.gouv.vitam.common.database.parser.query.SearchQuery;
import fr.gouv.vitam.common.database.parser.query.TermQuery;
import fr.gouv.vitam.common.database.parser.query.WildcardQuery;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.Map;

public class QueryParserHelper
extends QueryHelper {
    protected QueryParserHelper() {
    }

    public static final PathQuery path(JsonNode array, VarNameAdapter adapter) {
        return new PathQuery(BuilderToken.QUERY.PATH, array, adapter);
    }

    public static final CompareQuery eq(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new CompareQuery(BuilderToken.QUERY.EQ, command, adapter);
    }

    public static final CompareQuery ne(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new CompareQuery(BuilderToken.QUERY.NE, command, adapter);
    }

    public static final CompareQuery lt(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new CompareQuery(BuilderToken.QUERY.LT, command, adapter);
    }

    public static final CompareQuery lte(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new CompareQuery(BuilderToken.QUERY.LTE, command, adapter);
    }

    public static final CompareQuery gt(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new CompareQuery(BuilderToken.QUERY.GT, command, adapter);
    }

    public static final CompareQuery gte(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new CompareQuery(BuilderToken.QUERY.GTE, command, adapter);
    }

    public static final CompareQuery size(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new CompareQuery(BuilderToken.QUERY.SIZE, command, adapter);
    }

    public static final ExistsQuery exists(JsonNode command, VarNameAdapter adapter) throws InvalidCreateOperationException, InvalidParseOperationException {
        return new ExistsQuery(BuilderToken.QUERY.EXISTS, command, adapter);
    }

    public static final ExistsQuery missing(JsonNode command, VarNameAdapter adapter) throws InvalidCreateOperationException, InvalidParseOperationException {
        return new ExistsQuery(BuilderToken.QUERY.MISSING, command, adapter);
    }

    public static final ExistsQuery isNull(JsonNode command, VarNameAdapter adapter) throws InvalidCreateOperationException, InvalidParseOperationException {
        return new ExistsQuery(BuilderToken.QUERY.ISNULL, command, adapter);
    }

    public static final InQuery in(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new InQuery(BuilderToken.QUERY.IN, command, adapter);
    }

    public static final InQuery nin(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new InQuery(BuilderToken.QUERY.NIN, command, adapter);
    }

    public static final MatchQuery match(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new MatchQuery(BuilderToken.QUERY.MATCH, command, adapter);
    }

    public static final MatchQuery matchAll(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new MatchQuery(BuilderToken.QUERY.MATCH_ALL, command, adapter);
    }

    public static final MatchQuery matchPhrase(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new MatchQuery(BuilderToken.QUERY.MATCH_PHRASE, command, adapter);
    }

    public static final MatchQuery matchPhrasePrefix(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new MatchQuery(BuilderToken.QUERY.MATCH_PHRASE_PREFIX, command, adapter);
    }

    public static final SearchQuery regex(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new SearchQuery(BuilderToken.QUERY.REGEX, command, adapter);
    }

    public static final SearchQuery search(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new SearchQuery(BuilderToken.QUERY.SEARCH, command, adapter);
    }

    public static final SearchQuery nestedSearch(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new SearchQuery(BuilderToken.QUERY.SUBOBJECT, command, adapter);
    }

    public static final TermQuery term(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new TermQuery(BuilderToken.QUERY.TERM, command, adapter);
    }

    public static final WildcardQuery wildcard(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new WildcardQuery(BuilderToken.QUERY.WILDCARD, command, adapter);
    }

    public static final MltQuery flt(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new MltQuery(BuilderToken.QUERY.FLT, command, adapter);
    }

    public static final MltQuery mlt(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new MltQuery(BuilderToken.QUERY.MLT, command, adapter);
    }

    public static final RangeQuery range(JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException {
        return new RangeQuery(BuilderToken.QUERY.RANGE, command, adapter);
    }

    public static final NopQuery nop() throws InvalidCreateOperationException {
        return new NopQuery();
    }

    public static final Query query(String refCommand, JsonNode command, VarNameAdapter adapter) throws InvalidParseOperationException, InvalidCreateOperationException {
        BuilderToken.QUERY query = QueryParserHelper.getRequestId(refCommand);
        switch (query) {
            case FLT: 
            case MLT: 
            case MATCH: 
            case MATCH_ALL: 
            case MATCH_PHRASE: 
            case MATCH_PHRASE_PREFIX: 
            case NIN: 
            case IN: 
            case RANGE: 
            case REGEX: 
            case TERM: 
            case WILDCARD: 
            case EQ: 
            case NE: 
            case GT: 
            case GTE: 
            case LT: 
            case LTE: 
            case SEARCH: 
            case SIZE: 
            case SUBOBJECT: {
                GlobalDatas.sanityValueCheck((String)command.toString());
                break;
            }
        }
        Object dslQuery = null;
        Query[] subQueries = null;
        switch (query) {
            case AND: {
                subQueries = QueryParserHelper.analyzeArrayCommand(query, command, adapter);
                dslQuery = QueryParserHelper.and().add(subQueries);
                for (Query subQuery : subQueries) {
                    dslQuery.setFullText(dslQuery.isFullText() || QueryParserHelper.isCommandAsFullText(subQuery.getQUERY()));
                }
                break;
            }
            case NOT: {
                subQueries = QueryParserHelper.analyzeArrayCommand(query, command, adapter);
                dslQuery = QueryParserHelper.not().add(QueryParserHelper.analyzeArrayCommand(query, command, adapter));
                for (Query subQuery : subQueries) {
                    dslQuery.setFullText(dslQuery.isFullText() || QueryParserHelper.isCommandAsFullText(subQuery.getQUERY()));
                }
                break;
            }
            case OR: {
                subQueries = QueryParserHelper.analyzeArrayCommand(query, command, adapter);
                dslQuery = QueryParserHelper.or().add(QueryParserHelper.analyzeArrayCommand(query, command, adapter));
                for (Query subQuery : subQueries) {
                    dslQuery.setFullText(dslQuery.isFullText() || QueryParserHelper.isCommandAsFullText(subQuery.getQUERY()));
                }
                break;
            }
            case EXISTS: {
                dslQuery = QueryParserHelper.exists(command, adapter);
                break;
            }
            case MISSING: {
                dslQuery = QueryParserHelper.missing(command, adapter);
                break;
            }
            case ISNULL: {
                dslQuery = QueryParserHelper.isNull(command, adapter);
                break;
            }
            case FLT: {
                dslQuery = QueryParserHelper.flt(command, adapter);
                break;
            }
            case MLT: {
                dslQuery = QueryParserHelper.mlt(command, adapter);
                break;
            }
            case MATCH: {
                dslQuery = QueryParserHelper.match(command, adapter);
                break;
            }
            case MATCH_ALL: {
                dslQuery = QueryParserHelper.matchAll(command, adapter);
                break;
            }
            case MATCH_PHRASE: {
                dslQuery = QueryParserHelper.matchPhrase(command, adapter);
                break;
            }
            case MATCH_PHRASE_PREFIX: {
                dslQuery = QueryParserHelper.matchPhrasePrefix(command, adapter);
                break;
            }
            case NIN: {
                dslQuery = QueryParserHelper.nin(command, adapter);
                break;
            }
            case IN: {
                dslQuery = QueryParserHelper.in(command, adapter);
                break;
            }
            case RANGE: {
                dslQuery = QueryParserHelper.range(command, adapter);
                break;
            }
            case REGEX: {
                dslQuery = QueryParserHelper.regex(command, adapter);
                break;
            }
            case TERM: {
                dslQuery = QueryParserHelper.term(command, adapter);
                break;
            }
            case WILDCARD: {
                dslQuery = QueryParserHelper.wildcard(command, adapter);
                break;
            }
            case EQ: {
                dslQuery = QueryParserHelper.eq(command, adapter);
                break;
            }
            case NE: {
                dslQuery = QueryParserHelper.ne(command, adapter);
                break;
            }
            case GT: {
                dslQuery = QueryParserHelper.gt(command, adapter);
                break;
            }
            case GTE: {
                dslQuery = QueryParserHelper.gte(command, adapter);
                break;
            }
            case LT: {
                dslQuery = QueryParserHelper.lt(command, adapter);
                break;
            }
            case LTE: {
                dslQuery = QueryParserHelper.lte(command, adapter);
                break;
            }
            case SEARCH: {
                dslQuery = QueryParserHelper.search(command, adapter);
                break;
            }
            case SUBOBJECT: {
                dslQuery = QueryParserHelper.nestedSearch(command, adapter);
                break;
            }
            case SIZE: {
                dslQuery = QueryParserHelper.size(command, adapter);
                break;
            }
            case NOP: {
                dslQuery = null;
                break;
            }
            case GEOMETRY: 
            case BOX: 
            case POLYGON: 
            case CENTER: 
            case GEOINTERSECTS: 
            case GEOWITHIN: 
            case NEAR: {
                throw new InvalidParseOperationException("Unimplemented command: " + refCommand);
            }
            case PATH: {
                throw new InvalidParseOperationException("Invalid position for command: " + refCommand);
            }
            default: {
                throw new InvalidParseOperationException("Invalid command: " + refCommand);
            }
        }
        if (dslQuery != null) {
            dslQuery.setFullText(dslQuery.isFullText() || QueryParserHelper.isCommandAsFullText(query));
        }
        return dslQuery;
    }

    public static final BuilderToken.QUERY getRequestId(String queryroot) throws InvalidParseOperationException {
        BuilderToken.QUERY query;
        if (!queryroot.startsWith("$")) {
            throw new InvalidParseOperationException("Incorrect request $command: " + queryroot);
        }
        String command = queryroot.substring(1).toUpperCase();
        try {
            query = BuilderToken.QUERY.valueOf((String)command);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParseOperationException("Invalid request command: " + command, (Throwable)e);
        }
        return query;
    }

    public static final Query[] analyzeArrayCommand(BuilderToken.QUERY query, JsonNode commands, VarNameAdapter adapter) throws InvalidParseOperationException, InvalidCreateOperationException {
        Query[] queries;
        if (commands == null) {
            throw new InvalidParseOperationException("Not correctly parsed: " + query);
        }
        int nb = 0;
        if (commands.isArray()) {
            queries = new Query[commands.size()];
            for (JsonNode subcommand : commands) {
                Map.Entry requestItem = JsonHandler.checkUnicity((String)query.exactToken(), (JsonNode)subcommand);
                Query subquery = QueryParserHelper.query((String)requestItem.getKey(), (JsonNode)requestItem.getValue(), adapter);
                if (subquery == null) continue;
                queries[nb++] = subquery;
            }
            if (nb != queries.length) {
                Query[] newQueries = new Query[nb];
                for (int i = 0; i < nb; ++i) {
                    newQueries[i] = queries[i];
                }
                queries = newQueries;
            }
        } else {
            throw new InvalidParseOperationException("Boolean operator needs an array of expression: " + commands);
        }
        if (query == BuilderToken.QUERY.NOT) {
            if (queries.length == 1) {
                return queries;
            }
            Query[] and = new Query[]{QueryParserHelper.and().add(queries)};
            return and;
        }
        return queries;
    }

    protected static boolean isCommandAsFullText(BuilderToken.QUERY query) {
        switch (query) {
            case FLT: 
            case MLT: 
            case MATCH: 
            case MATCH_ALL: 
            case MATCH_PHRASE: 
            case MATCH_PHRASE_PREFIX: {
                return true;
            }
        }
        return false;
    }
}

