/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.query;

import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.logging.SysErrLogger;

public class ParserTokens
extends BuilderToken {
    public static final char DEFAULT_HASH_PREFIX_CHAR = '#';
    public static final char DEFAULT_UNDERSCORE_PREFIX_CHAR = '_';
    private static final String DEFAULT_HASH_PREFIX = "#";

    private ParserTokens() {
    }

    private static boolean isSingleProtectedVariable(String name) {
        switch (name) {
            case "Identifier": 
            case "PUID": {
                return true;
            }
        }
        return false;
    }

    public static enum PROJECTIONARGS {
        ID("id"),
        NBUNITS("nbunits"),
        NBOBJECTS("nbobjects"),
        DUA("dua"),
        ALL("all"),
        QUALIFIERS("qualifiers"),
        SIZE("size"),
        FORMAT("format"),
        TYPE("type"),
        TENANT("tenant"),
        OBJECT("object"),
        UNITUPS("unitups"),
        MIN("min"),
        MAX("max"),
        ALLUNITUPS("allunitups"),
        MANAGEMENT("management"),
        UNITTYPE("unitType"),
        UDS("uds"),
        OPERATIONS("operations"),
        OPI("opi"),
        ORIGINATING_AGENCY("originating_agency"),
        ORIGINATING_AGENCIES("originating_agencies"),
        STORAGE("storage"),
        VERSION("version"),
        ATOMIC_VERSION("atomic_version"),
        USAGE("usage"),
        SCORE("score"),
        LAST_PERSISTED_DATE("lastPersistedDate"),
        GRAPH("graph"),
        ELIMINATION("elimination"),
        GRAPH_LAST_PERISTED_DATE("graph_last_persisted_date"),
        PARENT_ORIGINATING_AGENCIES("parent_originating_agencies"),
        HISTORY("history"),
        SEDAVERSION("sedaVersion"),
        IMPLEMENTATIONVERSION("implementationVersion"),
        COMPUTEDINHERITEDRULES("computedInheritedRules"),
        VALIDCOMPUTEDINHERITEDRULES("validComputedInheritedRules"),
        APPROXIMATE_CREATION_DATE("approximate_creation_date"),
        APPROXIMATE_UPDATE_DATE("approximate_update_date"),
        BATCHID("batchId"),
        UPLOADPATH("uploadPath"),
        OPTS("opts"),
        MANAGEMENT_CONTRACT_ID("managementContractId");

        private static final String NOT_FOUND = "Not found";
        private final String exactToken;

        private PROJECTIONARGS(String realName) {
            this.exactToken = ParserTokens.DEFAULT_HASH_PREFIX + realName;
        }

        public static boolean isValid(String token) {
            return token.startsWith("_qualifiers.") || token.equals("mgt") || token.startsWith("_mgt.") || token.startsWith("_storage.");
        }

        public static PROJECTIONARGS parse(String name) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException(NOT_FOUND);
            }
            try {
                return PROJECTIONARGS.valueOf(name.toUpperCase());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(NOT_FOUND, e);
            }
        }

        public static boolean notAllowedOnSetExternal(String name) {
            if (name == null || name.isEmpty()) {
                return true;
            }
            return name.charAt(0) == '_';
        }

        public static boolean notAllowedOnSet(String name) {
            if (name == null || name.isEmpty()) {
                return false;
            }
            if (name.charAt(0) == '#') {
                int pos = name.indexOf(46);
                String realname = pos > 1 ? name.substring(1, pos) : name.substring(1);
                try {
                    PROJECTIONARGS proj = PROJECTIONARGS.valueOf(realname.toUpperCase());
                    switch (proj) {
                        case ALL: 
                        case FORMAT: 
                        case ID: 
                        case NBUNITS: 
                        case NBOBJECTS: 
                        case QUALIFIERS: 
                        case SIZE: 
                        case OBJECT: 
                        case UNITUPS: 
                        case ALLUNITUPS: 
                        case TENANT: 
                        case MIN: 
                        case MAX: 
                        case UNITTYPE: 
                        case ORIGINATING_AGENCY: 
                        case ORIGINATING_AGENCIES: 
                        case VERSION: 
                        case USAGE: 
                        case OPERATIONS: 
                        case OPI: 
                        case SCORE: 
                        case LAST_PERSISTED_DATE: 
                        case GRAPH: 
                        case GRAPH_LAST_PERISTED_DATE: 
                        case HISTORY: 
                        case ELIMINATION: 
                        case SEDAVERSION: 
                        case IMPLEMENTATIONVERSION: 
                        case STORAGE: 
                        case COMPUTEDINHERITEDRULES: {
                            return true;
                        }
                    }
                }
                catch (Exception e) {
                    SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
                }
            }
            return ParserTokens.isSingleProtectedVariable(name);
        }

        public final String exactToken() {
            return this.exactToken;
        }
    }
}

