/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.collections;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import fr.gouv.vitam.common.database.collections.VitamDescriptionResolver;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchAccess;

public class VitamCollection<T> {
    private final Class<T> clasz;
    private final VitamDescriptionResolver vitamDescriptionResolver;
    private String name;
    private MongoCollection<T> collection;
    private ElasticsearchAccess esClient;
    private final boolean isMultiTenant;
    private final boolean useScore;

    protected VitamCollection(Class<T> clasz, boolean isMultiTenant, boolean useScore, String prefix, VitamDescriptionResolver vitamDescriptionResolver) {
        this.clasz = clasz;
        this.vitamDescriptionResolver = vitamDescriptionResolver;
        this.name = prefix + clasz.getSimpleName();
        this.isMultiTenant = isMultiTenant;
        this.useScore = useScore;
    }

    public void initialize(MongoDatabase db, boolean recreate) {
        this.collection = db.getCollection(this.getName(), this.getClasz());
        if (recreate) {
            this.collection.createIndex(Indexes.hashed((String)"_id"));
        }
    }

    public void initialize(ElasticsearchAccess esClient) {
        this.esClient = esClient;
    }

    public String getName() {
        return this.name;
    }

    @VisibleForTesting
    public void setName(String name) {
        this.name = name;
    }

    public MongoCollection<T> getCollection() {
        return this.collection;
    }

    public Class<T> getClasz() {
        return this.clasz;
    }

    public ElasticsearchAccess getEsClient() {
        return this.esClient;
    }

    public boolean isMultiTenant() {
        return this.isMultiTenant;
    }

    public boolean isUseScore() {
        return this.useScore;
    }

    public VitamDescriptionResolver getVitamDescriptionResolver() {
        return this.vitamDescriptionResolver;
    }
}

