/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.collections;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class CachedOntologyLoader
implements OntologyLoader {
    private final LoadingCache<String, List<OntologyModel>> cache;
    private static final String GET_FROM_SAME_CACHE = "GET-FROM-SAME-CACHE-VALUE-ONTOLOGY";

    public CachedOntologyLoader(int maxEntriesInCache, int cacheTimeoutInSeconds, final OntologyLoader loadOntology) {
        CacheBuilder objectObjectCacheBuilder = CacheBuilder.newBuilder();
        objectObjectCacheBuilder.maximumSize((long)maxEntriesInCache);
        objectObjectCacheBuilder.expireAfterAccess((long)cacheTimeoutInSeconds, TimeUnit.SECONDS);
        objectObjectCacheBuilder.weakValues();
        this.cache = objectObjectCacheBuilder.build((CacheLoader)new CacheLoader<String, List<OntologyModel>>(){

            public List<OntologyModel> load(String key) {
                return loadOntology.loadOntologies();
            }
        });
    }

    public List<OntologyModel> loadOntologies() {
        String id = StringUtils.isBlank((CharSequence)VitamThreadUtils.getVitamSession().getRequestId()) ? GET_FROM_SAME_CACHE : VitamThreadUtils.getVitamSession().getRequestId();
        return (List)this.cache.getUnchecked((Object)id);
    }
}

