/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.api.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.api.VitamRepositoryStatus;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAliasResolver;
import fr.gouv.vitam.common.database.server.elasticsearch.model.ElasticsearchCollections;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.bson.Document;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.XContentType;

public class VitamElasticsearchRepository {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamElasticsearchRepository.class);
    public static final String IDENTIFIER = "Identifier";
    public static final String ID = "_id";
    private static final String ALL_PARAMS_REQUIRED = "All params are required";
    private static final String BULK_REQ_FAIL_WITH_ERROR = "Bulk Request failure with error: ";
    private static final String EV_DET_DATA = "evDetData";
    private static final String RIGHT_STATE_ID = "rightsStatementIdentifier";
    private static final String AG_ID_EXT = "agIdExt";
    private static final String EVENTS = "events";
    private final RestHighLevelClient client;
    private final ElasticsearchIndexAliasResolver elasticsearchIndexAliasResolver;

    public VitamElasticsearchRepository(RestHighLevelClient client, ElasticsearchIndexAliasResolver elasticsearchIndexAliasResolver) {
        this.client = client;
        this.elasticsearchIndexAliasResolver = elasticsearchIndexAliasResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VitamRepositoryStatus save(Document document) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{document});
        Document internalDocument = new Document((Map)document);
        Integer tenant = internalDocument.getInteger((Object)"_tenant");
        String id = (String)internalDocument.remove((Object)ID);
        Object score = internalDocument.remove((Object)"_score");
        try {
            IndexResponse indexResponse;
            String source = BsonHelper.stringify(internalDocument);
            String aliasName = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
            IndexRequest request = ((IndexRequest)((IndexRequest)new IndexRequest(aliasName).id(id).source(source, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).timeout(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()))).opType(DocWriteRequest.OpType.INDEX);
            try {
                indexResponse = this.client.index(request, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                throw new DatabaseException((Throwable)e);
            }
            if (indexResponse.getResult() == DocWriteResponse.Result.CREATED) {
                VitamRepositoryStatus vitamRepositoryStatus = VitamRepositoryStatus.CREATED;
                return vitamRepositoryStatus;
            }
            if (indexResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                VitamRepositoryStatus vitamRepositoryStatus = VitamRepositoryStatus.UPDATED;
                return vitamRepositoryStatus;
            }
            VitamRepositoryStatus vitamRepositoryStatus = this.handleFailures((DocWriteResponse)indexResponse);
            return vitamRepositoryStatus;
        }
        finally {
            internalDocument.put(ID, (Object)id);
            if (Objects.nonNull(score)) {
                internalDocument.put("_score", score);
            }
        }
    }

    private VitamRepositoryStatus handleFailures(DocWriteResponse indexResponse) throws DatabaseException {
        String error = null;
        ReplicationResponse.ShardInfo shardInfo = indexResponse.getShardInfo();
        if (shardInfo.getTotal() != shardInfo.getSuccessful()) {
            error = String.format("Exception occurred : total shards %s, successful shards %s", shardInfo.getTotal(), shardInfo.getSuccessful());
        }
        if (shardInfo.getFailed() > 0) {
            StringBuilder failures = new StringBuilder();
            for (ReplicationResponse.ShardInfo.Failure failure : shardInfo.getFailures()) {
                String reason = failure.reason();
                failures.append(reason).append(" ; ");
            }
            error = String.format("Exception occurred caused by : %s", failures.toString());
        }
        if (null == error) {
            error = String.format("Insert Documents Exception caused by : %s", indexResponse.getResult().toString());
        }
        LOGGER.error(error);
        throw new DatabaseException(error);
    }

    public void save(List<Document> documents) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{documents});
        if (documents.isEmpty()) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        documents.forEach(document -> {
            Document internalDocument = new Document((Map)document);
            Integer tenant = internalDocument.getInteger((Object)"_tenant");
            String id = (String)internalDocument.remove((Object)ID);
            internalDocument.remove((Object)"_score");
            internalDocument.remove((Object)"_unused");
            String source = BsonHelper.stringify(internalDocument);
            String aliasName = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
            bulkRequest.add(new IndexRequest(aliasName).id(id).source(source, XContentType.JSON));
        });
        if (bulkRequest.numberOfActions() != 0) {
            BulkResponse bulkResponse;
            try {
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                bulkResponse = this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                throw new DatabaseException((Throwable)e);
            }
            if (bulkResponse.hasFailures()) {
                LOGGER.error(BULK_REQ_FAIL_WITH_ERROR + bulkResponse.buildFailureMessage());
                throw new DatabaseException(bulkResponse.buildFailureMessage());
            }
        }
    }

    public void save(ElasticsearchCollections elasticsearchCollections, List<Document> documents) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{documents});
        BulkRequest bulkRequest = new BulkRequest();
        documents.forEach(document -> {
            Document internalDocument = new Document((Map)document);
            Integer tenant = internalDocument.getInteger((Object)"_tenant");
            String id = (String)internalDocument.remove((Object)ID);
            internalDocument.remove((Object)"_score");
            internalDocument.remove((Object)"_unused");
            String aliasName = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
            switch (elasticsearchCollections) {
                case OPERATION: {
                    this.transformDataForElastic(internalDocument);
                }
            }
            String source = BsonHelper.stringify(internalDocument);
            bulkRequest.add(new IndexRequest(aliasName).id(id).source(source, XContentType.JSON));
        });
        if (bulkRequest.numberOfActions() != 0) {
            BulkResponse bulkResponse;
            try {
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                bulkResponse = this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                throw new DatabaseException((Throwable)e);
            }
            if (bulkResponse.hasFailures()) {
                LOGGER.error(BULK_REQ_FAIL_WITH_ERROR + bulkResponse.buildFailureMessage());
                throw new DatabaseException(bulkResponse.buildFailureMessage());
            }
        }
    }

    private void transformDataForElastic(Document vitamDocument) {
        List eventDocuments;
        if (vitamDocument.get((Object)EV_DET_DATA) != null) {
            String evDetDataString = (String)vitamDocument.get((Object)EV_DET_DATA);
            LOGGER.debug(evDetDataString);
            try {
                JsonNode evDetData = JsonHandler.getFromString((String)evDetDataString);
                vitamDocument.remove((Object)EV_DET_DATA);
                vitamDocument.put(EV_DET_DATA, (Object)evDetData);
            }
            catch (InvalidParseOperationException e) {
                LOGGER.warn("EvDetData is not a json compatible field", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (vitamDocument.get((Object)AG_ID_EXT) != null) {
            String agidExt = (String)vitamDocument.get((Object)AG_ID_EXT);
            LOGGER.debug(agidExt);
            try {
                JsonNode agidExtNode = JsonHandler.getFromString((String)agidExt);
                vitamDocument.remove((Object)AG_ID_EXT);
                vitamDocument.put(AG_ID_EXT, (Object)agidExtNode);
            }
            catch (InvalidParseOperationException e) {
                LOGGER.warn("agidExtNode is not a json compatible field", (Throwable)e);
            }
        }
        if (vitamDocument.get((Object)RIGHT_STATE_ID) != null) {
            String rightsStatementIdentifier = (String)vitamDocument.get((Object)RIGHT_STATE_ID);
            LOGGER.debug(rightsStatementIdentifier);
            try {
                JsonNode rightsStatementIdentifierNode = JsonHandler.getFromString((String)rightsStatementIdentifier);
                vitamDocument.remove((Object)RIGHT_STATE_ID);
                vitamDocument.put(RIGHT_STATE_ID, (Object)rightsStatementIdentifierNode);
            }
            catch (InvalidParseOperationException e) {
                LOGGER.warn("rightsStatementIdentifier is not a json compatible field", (Throwable)e);
            }
        }
        if ((eventDocuments = (List)vitamDocument.get((Object)EVENTS)) != null) {
            for (Document eventDocument : eventDocuments) {
                Document eventEvDetDataDocument;
                if (eventDocument.getString((Object)EV_DET_DATA) != null) {
                    String eventEvDetDataString = eventDocument.getString((Object)EV_DET_DATA);
                    eventEvDetDataDocument = Document.parse((String)eventEvDetDataString);
                    eventDocument.remove((Object)EV_DET_DATA);
                    eventDocument.put(EV_DET_DATA, (Object)eventEvDetDataDocument);
                }
                if (eventDocument.getString((Object)RIGHT_STATE_ID) != null) {
                    String eventrightsStatementIdentifier = eventDocument.getString((Object)RIGHT_STATE_ID);
                    eventEvDetDataDocument = Document.parse((String)eventrightsStatementIdentifier);
                    eventDocument.remove((Object)RIGHT_STATE_ID);
                    eventDocument.put(RIGHT_STATE_ID, (Object)eventEvDetDataDocument);
                }
                if (eventDocument.getString((Object)AG_ID_EXT) == null) continue;
                String eventagIdExt = eventDocument.getString((Object)AG_ID_EXT);
                eventEvDetDataDocument = Document.parse((String)eventagIdExt);
                eventDocument.remove((Object)AG_ID_EXT);
                eventDocument.put(AG_ID_EXT, (Object)eventEvDetDataDocument);
            }
        }
        vitamDocument.remove((Object)EVENTS);
        vitamDocument.put(EVENTS, (Object)eventDocuments);
    }

    public void remove(String id, Integer tenant) throws DatabaseException {
        DeleteResponse deleteResponse;
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (String[])new String[]{id});
        String index = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
        DeleteRequest request = (DeleteRequest)((DeleteRequest)new DeleteRequest(index).id(id).timeout(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()))).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try {
            deleteResponse = this.client.delete(request, RequestOptions.DEFAULT);
        }
        catch (IOException | ElasticsearchException e) {
            if (e instanceof ElasticsearchException && ((ElasticsearchException)e).status() == RestStatus.NOT_FOUND) {
                return;
            }
            throw new DatabaseException(e);
        }
        DocWriteResponse.Result result = deleteResponse.getResult();
        switch (result) {
            case DELETED: 
            case NOT_FOUND: {
                break;
            }
            default: {
                this.handleFailures((DocWriteResponse)deleteResponse);
            }
        }
    }

    public long purge(Integer tenant) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{tenant});
        String index = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
        TermQueryBuilder qb = QueryBuilders.termQuery((String)"_tenant", (Object)tenant);
        return VitamElasticsearchRepository.handlePurge(this.client, index, (QueryBuilder)qb);
    }

    private static long handlePurge(RestHighLevelClient client, String index, QueryBuilder qb) throws DatabaseException {
        try {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{index});
            request.setConflicts("proceed");
            request.setQuery(qb);
            request.setBatchSize(VitamConfiguration.getMaxElasticsearchBulk());
            request.setScroll(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds().intValue()));
            request.setTimeout(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()));
            request.setRefresh(true);
            BulkByScrollResponse bulkResponse = client.deleteByQuery(request, RequestOptions.DEFAULT);
            TimeValue timeTaken = bulkResponse.getTook();
            boolean timedOut = bulkResponse.isTimedOut();
            long totalDocs = bulkResponse.getTotal();
            long deletedDocs = bulkResponse.getDeleted();
            long batches = bulkResponse.getBatches();
            long noops = bulkResponse.getNoops();
            long versionConflicts = bulkResponse.getVersionConflicts();
            long bulkRetries = bulkResponse.getBulkRetries();
            long searchRetries = bulkResponse.getSearchRetries();
            TimeValue throttledMillis = bulkResponse.getStatus().getThrottled();
            TimeValue throttledUntilMillis = bulkResponse.getStatus().getThrottledUntil();
            LOGGER.debug("Purge : timeTaken (" + timeTaken + "), timedOut (" + timedOut + "), totalDocs (" + totalDocs + "), deletedDocs (" + deletedDocs + "), batches (" + batches + "), noops (" + noops + "), versionConflicts (" + versionConflicts + ")bulkRetries (" + bulkRetries + "), searchRetries (" + searchRetries + "),  throttledMillis(" + throttledMillis + "), throttledUntilMillis(" + throttledUntilMillis + ")");
            List searchFailures = bulkResponse.getSearchFailures();
            if (CollectionUtils.isNotEmpty((Collection)searchFailures)) {
                throw new DatabaseException("ES purge errors : in search phase");
            }
            List bulkFailures = bulkResponse.getBulkFailures();
            if (CollectionUtils.isNotEmpty((Collection)bulkFailures)) {
                throw new DatabaseException("ES purge errors : in bulk phase");
            }
            return bulkResponse.getDeleted();
        }
        catch (IOException e) {
            throw new DatabaseException("Purge Exception", (Throwable)e);
        }
    }

    public long purge() throws DatabaseException {
        String index = this.elasticsearchIndexAliasResolver.resolveIndexName(null).getName();
        MatchAllQueryBuilder qb = QueryBuilders.matchAllQuery();
        return VitamElasticsearchRepository.handlePurge(this.client, index, (QueryBuilder)qb);
    }

    public Optional<Document> getByID(String id, Integer tenant) throws DatabaseException {
        GetResponse response;
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (String[])new String[]{id});
        String index = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
        GetRequest request = new GetRequest(index).id(id).fetchSourceContext(FetchSourceContext.FETCH_SOURCE);
        try {
            response = this.client.get(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
        if (response.isExists()) {
            try {
                return Optional.of((Document)JsonHandler.getFromString((String)response.getSourceAsString(), Document.class));
            }
            catch (InvalidParseOperationException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        return Optional.empty();
    }

    public Optional<Document> getDocumentById(String id) throws DatabaseException {
        SearchResponse searchResponse;
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (String[])new String[]{id});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)ID, (String)id));
        sourceBuilder.from(0);
        sourceBuilder.size(1);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.source(sourceBuilder);
        try {
            searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
        SearchHit[] searchHitArray = searchResponse.getHits().getHits();
        int n = searchHitArray.length;
        int n2 = 0;
        if (n2 < n) {
            SearchHit hit = searchHitArray[n2];
            try {
                return Optional.of((Document)JsonHandler.getFromString((String)hit.getSourceAsString(), Document.class));
            }
            catch (InvalidParseOperationException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        return Optional.empty();
    }

    public Optional<Document> findByIdentifierAndTenant(String identifier, Integer tenant) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{tenant});
        try {
            String aliasName = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
            BoolQueryBuilder qb = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)IDENTIFIER, (String)identifier)).must((QueryBuilder)QueryBuilders.termQuery((String)"_tenant", (Object)tenant));
            return this.handleSearch(aliasName, (QueryBuilder)qb);
        }
        catch (IOException e) {
            throw new DatabaseException("Search by identifier and tenant exception", (Throwable)e);
        }
    }

    private Optional<Document> handleSearch(String index, QueryBuilder qb) throws IOException, DatabaseException {
        int n = 0;
        SearchResponse search = this.search(index, qb);
        SearchHit[] searchHitArray = search.getHits().getHits();
        int n2 = searchHitArray.length;
        if (n < n2) {
            SearchHit hit = searchHitArray[n];
            try {
                return Optional.of((Document)JsonHandler.getFromString((String)hit.getSourceAsString(), Document.class));
            }
            catch (InvalidParseOperationException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        return Optional.empty();
    }

    public SearchResponse search(String index, QueryBuilder qb) throws IOException {
        SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().query(qb).size(10000).sort("_doc", SortOrder.ASC);
        SearchRequest searchRequest = new SearchRequest().indices(new String[]{index}).scroll(new TimeValue(60000L)).searchType(SearchType.DFS_QUERY_THEN_FETCH).source(searchSourceBuilder);
        return this.client.search(searchRequest, RequestOptions.DEFAULT);
    }

    public Optional<Document> findByIdentifier(String identifier) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (String[])new String[0]);
        String index = this.elasticsearchIndexAliasResolver.resolveIndexName(null).getName();
        try {
            return this.handleSearch(index, (QueryBuilder)QueryBuilders.termQuery((String)IDENTIFIER, (String)identifier));
        }
        catch (IOException e) {
            throw new DatabaseException("Search by identifier exception", (Throwable)e);
        }
    }

    public void delete(List<String> ids, int tenant) throws DatabaseException {
        String index = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
        UnmodifiableIterator idIterator = Iterators.partition(ids.iterator(), (int)VitamConfiguration.getMaxElasticsearchBulk());
        while (idIterator.hasNext()) {
            BulkResponse bulkResponse;
            BulkRequest bulkRequest = new BulkRequest();
            for (String id : (List)idIterator.next()) {
                bulkRequest.add(new DeleteRequest(index, id));
            }
            WriteRequest.RefreshPolicy refreshPolicy = idIterator.hasNext() ? WriteRequest.RefreshPolicy.NONE : WriteRequest.RefreshPolicy.IMMEDIATE;
            bulkRequest.setRefreshPolicy(refreshPolicy);
            if (bulkRequest.numberOfActions() == 0) continue;
            try {
                bulkResponse = this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                throw new DatabaseException("Bulk delete exception", (Throwable)e);
            }
            if (!bulkResponse.hasFailures()) continue;
            throw new DatabaseException("ES delete in error: " + bulkResponse.buildFailureMessage());
        }
    }
}

