/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.api;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.api.impl.VitamElasticsearchRepository;
import fr.gouv.vitam.common.database.api.impl.VitamMongoRepository;
import fr.gouv.vitam.common.database.collections.VitamCollection;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAliasResolver;

public class VitamRepositoryFactory
implements VitamRepositoryProvider {
    private static final VitamRepositoryFactory instance = new VitamRepositoryFactory();

    private VitamRepositoryFactory() {
    }

    public static synchronized VitamRepositoryFactory get() {
        ParametersChecker.checkParameter((String)"VitamRepositoryFactory should be instantiated at startup", (Object[])new Object[]{instance});
        return instance;
    }

    @Override
    public VitamMongoRepository getVitamMongoRepository(VitamCollection collection) {
        return new VitamMongoRepository(collection.getCollection());
    }

    @Override
    public VitamElasticsearchRepository getVitamESRepository(VitamCollection collection, ElasticsearchIndexAliasResolver elasticsearchIndexAliasResolver) {
        return new VitamElasticsearchRepository(collection.getEsClient().getClient(), elasticsearchIndexAliasResolver);
    }
}

