/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.utils;

import fr.gouv.vitam.storage.engine.common.referential.model.OfferReference;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyNotFoundException;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyReferentOfferException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class StorageStrategyUtils {
    public static void checkStrategy(String storageStrategy, List<StorageStrategy> referentialStrategies, String variableName, boolean referentOffersMandatory) throws StorageStrategyNotFoundException, StorageStrategyReferentOfferException {
        long nbReferentialOffers;
        Optional<StorageStrategy> referentialStrategy = referentialStrategies.stream().filter(strategy -> storageStrategy.equals(strategy.getId())).findFirst();
        if (!referentialStrategy.isPresent()) {
            throw new StorageStrategyNotFoundException("Strategy was not found", storageStrategy, variableName);
        }
        if (referentOffersMandatory && (nbReferentialOffers = referentialStrategy.get().getOffers().stream().filter(OfferReference::isReferent).filter(OfferReference::isEnabled).count()) != 1L) {
            throw new StorageStrategyReferentOfferException(String.format("Strategy contains %s referent offer(s). The strategy must contains one and only one referent offer ", nbReferentialOffers), storageStrategy, variableName);
        }
    }

    public static List<String> loadOfferIds(String storageStrategyId, List<StorageStrategy> storageStrategies) throws StorageStrategyNotFoundException {
        Optional<StorageStrategy> storageStrategy = storageStrategies.stream().filter(strategy -> strategy.getId().equals(storageStrategyId)).findFirst();
        if (!storageStrategy.isPresent()) {
            throw new StorageStrategyNotFoundException(String.format("Could not find strategy %s", storageStrategyId));
        }
        return storageStrategy.get().getOffers().stream().filter(offer -> offer.isEnabled()).map(offer -> offer.getId()).collect(Collectors.toList());
    }

    public static boolean checkReferentOfferUsageInStrategiesValid(List<StorageStrategy> storageStrategies) {
        Map<String, String> referentOfferByStrategy = storageStrategies.stream().filter(strategy -> strategy.getOffers().stream().filter(OfferReference::isReferent).filter(OfferReference::isEnabled).map(OfferReference::getId).count() == 1L).collect(Collectors.toMap(StorageStrategy::getId, strategy -> strategy.getOffers().stream().filter(OfferReference::isReferent).filter(OfferReference::isEnabled).map(OfferReference::getId).findFirst().get()));
        return referentOfferByStrategy.keySet().size() == new HashSet<String>(referentOfferByStrategy.values()).size();
    }
}

