/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.referential;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.exception.StorageTechnicalException;
import fr.gouv.vitam.storage.engine.common.referential.StorageOfferProvider;
import fr.gouv.vitam.storage.engine.common.referential.StorageStrategyProvider;
import fr.gouv.vitam.storage.engine.common.referential.model.OfferReference;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageOffer;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class FileStorageProvider
implements StorageStrategyProvider,
StorageOfferProvider {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FileStorageProvider.class);
    private static final String STRATEGY_FILENAME = "static-strategy.json";
    private static final String OFFER_FILENAME = "static-offer.json";
    private static final String NO_STRATEGY_MSG = "No strategy found! At least a 'default' strategy is required";
    private static final String NO_DEFAULT_STRATEGY_MSG = "No 'default' strategy found! One and only one 'default' strategy is required";
    private static final String TOO_MANY_DEFAULT_STRATEGY_MSG = "More than one 'default' strategy found! One and only one 'default' strategy is required";
    private static final String NO_REFERENT_OFFER_MSG = "The 'default' strategy does not contains a 'referent' offer! One and only one 'referent' offer is required in the 'default' strategy";
    private static final String TOO_MANY_REFERENT_OFFERS_MSG = "The 'default' strategy contains more than one 'referent' offer! One and only one 'referent' offer is required in the 'default' strategy";
    private static final String OTHER_STRATEGY_TOO_MANY_REFERENT_OFFER_MSG = "One or more strategies (%s) contains more than one 'referent' offer! At most one 'referent' offer is valid in a strategy";
    private volatile Map<String, StorageOffer> storageOffers;
    private volatile Map<String, StorageStrategy> storageStrategies;

    FileStorageProvider() {
        this.initReferentials();
    }

    @Override
    public StorageStrategy getStorageStrategy(String idStrategy) throws StorageTechnicalException {
        if (this.storageStrategies == null) {
            try {
                this.loadReferential(ReferentialType.STRATEGY);
            }
            catch (InvalidParseOperationException | IOException exc) {
                throw new StorageTechnicalException(exc);
            }
        }
        if (this.storageStrategies.containsKey(idStrategy)) {
            return this.storageStrategies.get(idStrategy);
        }
        throw new StorageTechnicalException("Storage strategy '" + idStrategy + "' invalid");
    }

    @Override
    public StorageOffer getStorageOffer(String idOffer) throws StorageException {
        return this.getFilteredStorageOffer(idOffer, false);
    }

    @Override
    public StorageOffer getStorageOffer(String idOffer, boolean includeDisabled) throws StorageException {
        return this.getFilteredStorageOffer(idOffer, includeDisabled);
    }

    private StorageOffer getFilteredStorageOffer(String idOffer, boolean includeAllOfferState) throws StorageException {
        StorageOffer offer;
        if (this.storageOffers == null) {
            try {
                this.loadReferential(ReferentialType.OFFER);
            }
            catch (InvalidParseOperationException | IOException exc) {
                throw new StorageTechnicalException(exc);
            }
        }
        if ((offer = this.storageOffers.get(idOffer)) == null || !includeAllOfferState && !offer.isEnabled()) {
            throw new StorageNotFoundException(String.format("Storage offer with id %s is not found, disabled or not defined in strategy", idOffer));
        }
        return offer;
    }

    @Override
    public Map<String, StorageStrategy> getStorageStrategies() throws StorageTechnicalException {
        return this.storageStrategies;
    }

    private void initReferentials() {
        try {
            this.loadReferential(ReferentialType.STRATEGY);
        }
        catch (IOException exc) {
            LOGGER.warn("Couldn't load static-strategy.json file", (Throwable)exc);
        }
        catch (InvalidParseOperationException exc) {
            LOGGER.warn("Couldn't parse static-strategy.json file", (Throwable)exc);
        }
        try {
            this.loadReferential(ReferentialType.OFFER);
        }
        catch (IOException exc) {
            LOGGER.warn("Couldn't load static-offer.json file", (Throwable)exc);
        }
        catch (InvalidParseOperationException exc) {
            LOGGER.warn("Couldn't parse static-offer.json file", (Throwable)exc);
        }
    }

    private void loadReferential(ReferentialType type) throws IOException, InvalidParseOperationException {
        switch (type) {
            case STRATEGY: {
                this.loadStrategies();
                break;
            }
            case OFFER: {
                this.loadOffers();
                break;
            }
            default: {
                LOGGER.error("Referential loading not implemented for type: " + type);
            }
        }
    }

    private void loadStrategies() throws InvalidParseOperationException, FileNotFoundException {
        StorageStrategy[] storageStrategiesArray = (StorageStrategy[])JsonHandler.getFromFileLowerCamelCase((File)PropertiesUtils.findFile((String)STRATEGY_FILENAME), StorageStrategy[].class);
        if (storageStrategiesArray == null || storageStrategiesArray.length < 1) {
            throw new IllegalArgumentException(NO_STRATEGY_MSG);
        }
        List<StorageStrategy> storageStrategiesList = Arrays.asList(storageStrategiesArray);
        List defaultStrategies = storageStrategiesList.stream().filter(strategy -> VitamConfiguration.getDefaultStrategy().equals(strategy.getId())).collect(Collectors.toList());
        if (defaultStrategies.isEmpty()) {
            throw new IllegalArgumentException(NO_DEFAULT_STRATEGY_MSG);
        }
        if (defaultStrategies.size() > 1) {
            throw new IllegalArgumentException(TOO_MANY_DEFAULT_STRATEGY_MSG);
        }
        List referentOffers = ((StorageStrategy)defaultStrategies.get(0)).getOffers().stream().filter(OfferReference::isReferent).filter(OfferReference::isEnabled).collect(Collectors.toList());
        if (referentOffers.isEmpty()) {
            throw new IllegalArgumentException(NO_REFERENT_OFFER_MSG);
        }
        if (referentOffers.size() > 1) {
            throw new IllegalArgumentException(TOO_MANY_REFERENT_OFFERS_MSG);
        }
        Set invalidStrategies = storageStrategiesList.stream().filter(storageStrategy -> storageStrategy.getOffers().stream().filter(OfferReference::isReferent).filter(OfferReference::isEnabled).count() > 1L).map(StorageStrategy::getId).collect(Collectors.toSet());
        if (!invalidStrategies.isEmpty()) {
            throw new IllegalArgumentException(String.format(OTHER_STRATEGY_TOO_MANY_REFERENT_OFFER_MSG, String.join((CharSequence)",", invalidStrategies)));
        }
        if (!StorageStrategyUtils.checkReferentOfferUsageInStrategiesValid(storageStrategiesList)) {
            LOGGER.warn("One or more offers are referents in more than one strategy.");
        }
        this.storageStrategies = storageStrategiesList.stream().collect(Collectors.toMap(StorageStrategy::getId, storageStrategy -> storageStrategy));
        this.storageStrategies.values().forEach(StorageStrategy::postInit);
    }

    private void loadOffers() throws InvalidParseOperationException, FileNotFoundException {
        if (this.storageStrategies == null || this.storageStrategies.isEmpty()) {
            throw new InvalidParseOperationException("storageStrategies is null when loading storage offer");
        }
        StorageOffer[] storageOffersArray = (StorageOffer[])JsonHandler.getFromFileLowerCamelCase((File)PropertiesUtils.findFile((String)OFFER_FILENAME), StorageOffer[].class);
        this.storageOffers = new HashMap<String, StorageOffer>();
        for (StorageOffer offer : storageOffersArray) {
            boolean isEnabled = this.storageStrategies.values().stream().anyMatch(strategy -> strategy.isStorageOfferEnabled(offer.getId()));
            offer.setEnabled(isEnabled);
            this.storageOffers.put(offer.getId(), offer);
            this.storageStrategies.values().forEach(StorageStrategy::postInit);
        }
    }

    @VisibleForTesting
    void setStorageStrategies(Map<String, StorageStrategy> storageStrategies) {
        this.storageStrategies = storageStrategies;
    }

    @VisibleForTesting
    void setStorageOffer(StorageOffer offer) {
        if (offer == null) {
            this.storageOffers = null;
        } else {
            this.storageOffers.put(offer.getId(), offer);
        }
    }

    private static enum ReferentialType {
        STRATEGY,
        OFFER;

    }
}

