/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.metrics;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.common.metrics.AbstractCountingInputStreamMetrics;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import io.prometheus.client.Summary;
import java.io.InputStream;

public class UploadCountingInputStreamMetrics
extends AbstractCountingInputStreamMetrics {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(UploadCountingInputStreamMetrics.class);
    public static final Summary UPLOAD_BYTES = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("vitam_storage_upload_size_bytes")).labelNames(new String[]{"tenant", "strategy", "offer_id", "data_category", "origin", "attempt"})).help("Vitam storage upload objects to offers size in bytes per tenant, strategy, offer_id, data_category, origin (normal, bulk, offer_sync), and per attempt")).register();
    private final String attempt;

    public UploadCountingInputStreamMetrics(Integer tenant, String strategy, String offerId, String origin, DataCategory dataCategory, int attempt, InputStream inputStream) {
        super(tenant, strategy, offerId, origin, dataCategory, inputStream);
        this.attempt = String.valueOf(attempt);
    }

    @Override
    protected void onEndOfFileReached() {
        try {
            ((Summary.Child)UPLOAD_BYTES.labels(new String[]{this.tenant, this.strategy, this.offerId, this.origin, this.dataCategory, this.attempt})).observe((double)super.getByteCount());
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
        }
    }
}

