/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.metrics;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.common.metrics.AbstractCountingInputStreamMetrics;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import io.prometheus.client.Summary;
import java.io.InputStream;

public class DownloadCountingInputStreamMetrics
extends AbstractCountingInputStreamMetrics {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DownloadCountingInputStreamMetrics.class);
    public static final Summary DOWNLOAD_BYTES = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("vitam_storage_download_size_bytes")).labelNames(new String[]{"tenant", "strategy", "offer_id", "origin", "data_category"})).help("Vitam storage download objects from offers size in bytes per tenant, strategy, offer_id, origin of request  (normal, traceability, offer_sync) and data_category")).register();

    public DownloadCountingInputStreamMetrics(Integer tenant, String strategy, String offerId, String origin, DataCategory dataCategory, InputStream inputStream) {
        super(tenant, strategy, offerId, origin, dataCategory, inputStream);
    }

    @Override
    protected void onEndOfFileReached() {
        try {
            ((Summary.Child)DOWNLOAD_BYTES.labels(new String[]{this.tenant, this.strategy, this.offerId, this.origin, this.dataCategory})).observe((double)super.getByteCount());
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
        }
    }
}

