/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.time;

import fr.gouv.vitam.common.LocalDateUtil;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import org.junit.rules.ExternalResource;

public class LogicalClockRule
extends ExternalResource {
    protected void after() {
        LocalDateUtil.resetClock();
    }

    public void logicalSleep(int amount, ChronoUnit unit) {
        LocalDateUtil.setClock((Clock)Clock.offset(LocalDateUtil.getClock(), Duration.of(amount, unit)));
    }

    public void freezeTime() {
        LocalDateUtil.setClock((Clock)Clock.fixed(LocalDateUtil.now().toInstant(ZoneOffset.UTC), ZoneOffset.UTC));
    }

    public void freezeTime(LocalDateTime localDateTime) {
        LocalDateUtil.setClock((Clock)Clock.fixed(localDateTime.toInstant(ZoneOffset.UTC), ZoneOffset.UTC));
    }

    public void resumeTime() {
        Duration shift = Duration.between(Clock.systemUTC().instant(), LocalDateUtil.getClock().instant());
        LocalDateUtil.setClock((Clock)Clock.offset(Clock.systemUTC(), shift));
    }
}

