/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.mongo;

import com.google.common.collect.Sets;
import com.mongodb.MongoClientSettings;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.rules.ExternalResource;

public class MongoRule
extends ExternalResource {
    public static final String VITAM_DB = "vitam-test";
    public static final String MONGO_HOST = "localhost";
    public static final String VITAM_SEQUENCE = "VitamSequence";
    public static final String COUNTER = "Counter";
    public static final String ID = "_id";
    private static final int dataBasePort = 27017;
    private final MongoClient mongoClient;
    private final String dbName;
    private final Set<String> collectionsToBePurged;
    private boolean clientClosed = false;

    public MongoRule(MongoClientSettings.Builder mongoClientSettingsBuilder, String ... collectionsToBePurged) {
        this(VITAM_DB, mongoClientSettingsBuilder, collectionsToBePurged);
    }

    public MongoRule(String dbName, MongoClientSettings.Builder mongoClientSettingsBuilder, String ... collectionsToBePurged) {
        this.collectionsToBePurged = null != collectionsToBePurged ? Sets.newHashSet((Object[])collectionsToBePurged) : new HashSet<String>();
        mongoClientSettingsBuilder.applyToClusterSettings(builder -> builder.hosts(List.of(new ServerAddress(MONGO_HOST, 27017))));
        this.mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettingsBuilder.build());
        this.dbName = dbName;
    }

    public static String getDatabaseName() {
        return VITAM_DB;
    }

    protected void after() {
        if (!this.clientClosed) {
            this.purge(this.dbName, this.collectionsToBePurged);
        }
    }

    private void purge(String database, Collection<String> collectionsToBePurged) {
        for (String collectionName : collectionsToBePurged) {
            if (VITAM_SEQUENCE.equals(collectionName)) {
                this.mongoClient.getDatabase(database).getCollection(collectionName).updateMany(Filters.exists((String)ID), Updates.set((String)COUNTER, (Object)0));
                continue;
            }
            this.mongoClient.getDatabase(database).getCollection(collectionName).deleteMany((Bson)new Document());
        }
    }

    public MongoRule addCollectionToBePurged(String collectionName) {
        this.collectionsToBePurged.add(collectionName);
        return this;
    }

    public void handleAfterClass() {
        this.after();
        this.close();
    }

    public void handleAfter() {
        this.after();
    }

    public static int getDataBasePort() {
        return 27017;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public MongoDatabase getMongoDatabase() {
        return this.mongoClient.getDatabase(this.dbName);
    }

    public MongoCollection<Document> getMongoCollection(String collectionName) {
        return this.mongoClient.getDatabase(this.dbName).getCollection(collectionName);
    }

    public <TDocument> MongoCollection<TDocument> getMongoCollection(String collectionName, Class<TDocument> clazz) {
        return this.mongoClient.getDatabase(this.dbName).getCollection(collectionName, clazz);
    }

    public void handleAfter(Set<String> collections) {
        this.purge(this.dbName, collections);
    }

    public void close() {
        this.mongoClient.close();
        this.clientClosed = true;
    }
}

