/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.mockito;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;

public class UnorderedListMatcher<T extends Comparable<? super T>>
implements ArgumentMatcher<List<T>> {
    private final List<T> left;

    public UnorderedListMatcher(List<T> expected) {
        this.left = expected;
    }

    public boolean matches(List<T> right) {
        if (this.left == null) {
            return right == null;
        }
        if (CollectionUtils.size(this.left) != CollectionUtils.size(right)) {
            return false;
        }
        ArrayList<T> leftSet = new ArrayList<T>(this.left);
        ArrayList<T> rightSet = new ArrayList<T>(right);
        leftSet.sort(Comparator.naturalOrder());
        rightSet.sort(Comparator.naturalOrder());
        return leftSet.equals(rightSet);
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> List<T> eqUnorderedList(T ... items) {
        return (List)ArgumentMatchers.argThat(new UnorderedListMatcher<T>(Arrays.asList(items)));
    }
}

