/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.junit;

import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Arrays;

public class FakeInputStream
extends InputStream {
    private static final int BYTE_VALUE_LIMIT = 126;
    private long limit;
    private long read = 0L;
    private final boolean block;
    private final SecureRandom random = new SecureRandom();
    private final boolean useRandom;

    public FakeInputStream(long limit) {
        this(limit, true, false);
    }

    public FakeInputStream(long limit, boolean block) {
        this(limit, block, false);
    }

    public FakeInputStream(long limit, boolean block, boolean useRandom) {
        this.limit = limit;
        this.block = block;
        this.useRandom = useRandom;
    }

    private final byte getValue() {
        if (this.useRandom) {
            return (byte)this.random.nextInt(126);
        }
        return 42;
    }

    @Override
    public int read() {
        if (this.limit <= 0L) {
            return -1;
        }
        --this.limit;
        ++this.read;
        return this.getValue();
    }

    @Override
    public int available() {
        if (this.limit > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.limit;
    }

    @Override
    public void close() {
        this.limit = 0L;
    }

    private int readBlockUnitary(byte[] b, int off, int len) {
        for (int i = 0; i < len; ++i) {
            int val = this.read();
            if (val < 0) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            b[off + i] = (byte)val;
        }
        return len;
    }

    private int readBlock(byte[] b, int off, int len) {
        if (this.limit <= 0L) {
            return -1;
        }
        int max = Math.min(this.available(), len);
        this.limit -= (long)max;
        this.read += (long)max;
        if (!this.useRandom) {
            Arrays.fill(b, off, off + max, this.getValue());
        } else {
            for (int i = 0; i < max; ++i) {
                b[off + i] = this.getValue();
            }
        }
        return max;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.block) {
            return this.readBlock(b, off, len);
        }
        return this.readBlockUnitary(b, off, len);
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public long readCount() {
        return this.read;
    }
}

