/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.workspace.client;

import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class DeferredFileBufferingInputStream
extends ProxyInputStream {
    private File tmpFile;
    private boolean closed = false;

    public DeferredFileBufferingInputStream(InputStream sourceInputStream, long sourceSize, int maxInMemoryBufferSize, File tmpDirectory) throws IOException {
        super(null);
        try {
            ExactSizeInputStream exactSizeInputStream = new ExactSizeInputStream(sourceInputStream, sourceSize);
            if (sourceSize <= (long)maxInMemoryBufferSize) {
                this.tmpFile = null;
                this.in = ByteArrayOutputStream.toBufferedInputStream((InputStream)exactSizeInputStream, (int)((int)sourceSize));
            } else {
                this.tmpFile = File.createTempFile(GUIDFactory.newGUID().toString(), ".tmp", tmpDirectory);
                FileUtils.copyToFile((InputStream)exactSizeInputStream, (File)this.tmpFile);
                this.in = new BufferedInputStream(Files.newInputStream(this.tmpFile.toPath(), StandardOpenOption.READ));
            }
        }
        catch (IOException e) {
            IOUtils.closeQuietly((InputStream)this.in);
            FileUtils.deleteQuietly((File)this.tmpFile);
            throw e;
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.in.close();
            if (this.tmpFile != null) {
                Files.delete(this.tmpFile.toPath());
            }
            this.closed = true;
        }
    }
}

