/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.swift;

import fr.gouv.vitam.common.storage.exception.StreamAlreadyConsumedException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class VitamAutoCloseInputStream
extends ProxyInputStream {
    public VitamAutoCloseInputStream(InputStream in) {
        super(in);
    }

    public void close() throws IOException {
        this.in.close();
        this.in = new AlreadyConsumedInputStream();
    }

    protected void afterRead(int n) throws IOException {
        if (n == -1) {
            this.close();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public class AlreadyConsumedInputStream
    extends InputStream {
        @Override
        public int read() throws IOException {
            throw new StreamAlreadyConsumedException("Already closed !");
        }

        @Override
        public int available() throws IOException {
            throw new StreamAlreadyConsumedException("Already closed !");
        }

        @Override
        public long skip(long n) throws IOException {
            throw new StreamAlreadyConsumedException("Already closed !");
        }

        @Override
        public void reset() throws IOException {
            throw new StreamAlreadyConsumedException("Already closed !");
        }

        @Override
        public void close() {
        }
    }
}

