/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.swift;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import org.apache.http.HttpResponse;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

public class SwiftPreventKeepAliveStrategy
extends DefaultClientConnectionReuseStrategy {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SwiftPreventKeepAliveStrategy.class);

    public boolean keepAlive(HttpResponse response, HttpContext context) {
        boolean serverAllowsKeepAlive;
        HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received \"{}\" for request \"{}\" - {} - {}", new Object[]{response.getStatusLine(), coreContext.getConnection(), coreContext.getTargetHost(), coreContext.getRequest().getRequestLine()});
        }
        if (serverAllowsKeepAlive = super.keepAlive(response, context)) {
            LOGGER.debug("Preventing keep-alive");
        }
        return false;
    }
}

