/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.swift;

import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.swift.VitamEndpointUrlResolver;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.apache.http.ssl.SSLContexts;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.api.identity.EndpointURLResolver;
import org.openstack4j.core.transport.Config;
import org.openstack4j.model.common.Identifier;
import org.openstack4j.model.identity.v3.Token;
import org.openstack4j.openstack.OSFactory;
import org.openstack4j.openstack.internal.OSClientSession;

public class SwiftKeystoneFactoryV3
implements Supplier<OSClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SwiftKeystoneFactoryV3.class);
    private final StorageConfiguration configuration;
    private final Config configOS4J;
    private final Identifier domainIdentifier;
    private final Identifier projectIdentifier;
    private final AtomicReference<Token> atomicToken = new AtomicReference<Object>(null);
    private final AtomicBoolean oneThread = new AtomicBoolean(true);
    private final Object monitor = new Object();

    public SwiftKeystoneFactoryV3(StorageConfiguration configuration) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        this.domainIdentifier = Identifier.byName((String)configuration.getSwiftDomain());
        this.projectIdentifier = Identifier.byName((String)configuration.getSwiftProjectName());
        this.configOS4J = Config.newConfig().withEndpointURLResolver((EndpointURLResolver)new VitamEndpointUrlResolver(configuration)).withConnectionTimeout(configuration.getSwiftConnectionTimeout()).withReadTimeout(configuration.getSwiftReadTimeout()).withMaxConnections(configuration.getSwiftMaxConnections()).withMaxConnectionsPerRoute(configuration.getSwiftMaxConnectionsPerRoute());
        if (configuration.getSwiftKeystoneAuthUrl().startsWith("https")) {
            File file = new File(configuration.getSwiftTrustStore());
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(file, configuration.getSwiftTrustStorePassword().toCharArray()).build();
            this.configOS4J.withSSLContext(sslContext);
        }
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSClient.OSClientV3 get() {
        Token currentToken = this.atomicToken.get();
        Date nearTime = LocalDateUtil.getDate((LocalDateTime)LocalDateUtil.now().plusSeconds(this.configuration.getSwiftHardRenewTokenDelayBeforeExpireTime()));
        if (currentToken == null || currentToken.getExpires().before(nearTime)) {
            Object object = this.monitor;
            synchronized (object) {
                currentToken = this.atomicToken.get();
                if (currentToken == null) {
                    OSClient.OSClientV3 osClientV3 = this.renewToken();
                    currentToken = osClientV3.getToken();
                    this.atomicToken.set(currentToken);
                    return osClientV3;
                }
            }
        }
        Date farTime = LocalDateUtil.getDate((LocalDateTime)LocalDateUtil.now().plusSeconds(this.configuration.getSwiftSoftRenewTokenDelayBeforeExpireTime()));
        if (currentToken.getExpires().before(farTime) && this.oneThread.compareAndSet(true, false)) {
            try {
                OSClient.OSClientV3 osClientV3 = this.renewToken();
                currentToken = osClientV3.getToken();
                this.atomicToken.set(currentToken);
                OSClient.OSClientV3 oSClientV3 = osClientV3;
                return oSClientV3;
            }
            finally {
                this.oneThread.set(true);
            }
        }
        OSClientSession.OSClientSessionV3 currentClient = (OSClientSession.OSClientSessionV3)OSClientSession.OSClientSessionV3.getCurrent();
        if (null != currentClient && currentToken.equals(currentClient.getToken())) {
            return currentClient;
        }
        return OSFactory.clientFromToken((Token)currentToken, (Config)this.configOS4J);
    }

    private OSClient.OSClientV3 renewToken() {
        Stopwatch times = Stopwatch.createStarted();
        LOGGER.info("No token or token is expired, let's get authenticate again");
        try {
            OSClient.OSClientV3 oSClientV3 = (OSClient.OSClientV3)((IOSClientBuilder.V3)((IOSClientBuilder.V3)OSFactory.builderV3().endpoint(this.configuration.getSwiftKeystoneAuthUrl())).credentials(this.configuration.getSwiftUser(), this.configuration.getSwiftPassword(), this.domainIdentifier).scopeToProject(this.projectIdentifier, this.domainIdentifier).withConfig(this.configOS4J)).authenticate();
            return oSClientV3;
        }
        finally {
            PerformanceLogger.getInstance().log("STP_AUTHENTICATION", "AUTHENTICATE", "RENEW_TOKEN", times.elapsed(TimeUnit.MILLISECONDS));
        }
    }
}

