/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.swift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.MetadatasObject;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.common.retryable.RetryableOnException;
import fr.gouv.vitam.common.retryable.RetryableParameters;
import fr.gouv.vitam.common.storage.ContainerInformation;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.cas.container.api.ContentAddressableStorageAbstract;
import fr.gouv.vitam.common.storage.cas.container.api.MetadatasStorageObject;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectContent;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectListingListener;
import fr.gouv.vitam.common.storage.constants.ErrorMessage;
import fr.gouv.vitam.common.storage.swift.SwiftPreventKeepAliveStrategy;
import fr.gouv.vitam.common.storage.swift.VitamAutoCloseInputStream;
import fr.gouv.vitam.common.storage.swift.VitamSwiftObjectStorageService;
import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageDigestMismatchException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.message.BasicHeader;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.exceptions.ConnectionException;
import org.openstack4j.connectors.httpclient.HttpClientFactory;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payloads;
import org.openstack4j.model.storage.object.SwiftObject;
import org.openstack4j.model.storage.object.options.ObjectListOptions;
import org.openstack4j.model.storage.object.options.ObjectLocation;
import org.openstack4j.model.storage.object.options.ObjectPutOptions;

public class Swift
extends ContentAddressableStorageAbstract {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(Swift.class);
    public static final String X_OBJECT_META_DIGEST = "X-Object-Meta-Digest";
    public static final String X_OBJECT_META_DIGEST_TYPE = "X-Object-Meta-Digest-Type";
    public static final String X_OBJECT_MANIFEST = "X-Object-Manifest";
    public static final String X_NEWEST = "X-Newest";
    private final Supplier<OSClient> osClient;
    private final Long swiftLimit;
    private final int swiftNbRetries;
    private final int swiftWaitingTimeInMilliseconds;
    private final int swiftRandomRangeSleepInMilliseconds;

    public Swift(Supplier<OSClient> osClient, StorageConfiguration configuration) {
        this(osClient, configuration, VitamConfiguration.getSwiftFileLimit());
    }

    @VisibleForTesting
    public Swift(Supplier<OSClient> osClient, StorageConfiguration configuration, Long swiftLimit) {
        super(configuration);
        this.osClient = osClient;
        this.swiftLimit = swiftLimit;
        this.swiftNbRetries = configuration.getSwiftNbRetries();
        this.swiftWaitingTimeInMilliseconds = configuration.getSwiftWaitingTimeInMilliseconds();
        this.swiftRandomRangeSleepInMilliseconds = configuration.getSwiftRandomRangeSleepInMilliseconds();
        Swift.customizeOpenstack4jHttpClient(configuration);
    }

    private static void customizeOpenstack4jHttpClient(StorageConfiguration configuration) {
        HttpClientFactory.registerInterceptor((httpClientBuilder, requestConfig, config) -> {
            if (configuration.isSwiftDisableKeepAlive()) {
                httpClientBuilder.setDefaultHeaders(List.of(new BasicHeader("Connection", "Close")));
                httpClientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)new SwiftPreventKeepAliveStrategy());
            }
        });
    }

    @Override
    public void createContainer(String containerName) throws ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        ActionResponse response = this.osClient.get().objectStorage().containers().create(containerName);
        if (!response.isSuccess()) {
            LOGGER.error("Error when try to create container with name: {}", (Object)containerName);
            LOGGER.error("Reason: {}", (Object)response.getFault());
            throw new ContentAddressableStorageServerException("Error when try to create container: " + response.getFault());
        }
        if (response.isSuccess() && response.getCode() == 202) {
            LOGGER.warn("Container " + containerName + " already exists");
        }
    }

    @Override
    public boolean isExistingContainer(String containerName) {
        if (super.isExistingContainerInCache(containerName)) {
            return true;
        }
        Map metadata = this.osClient.get().objectStorage().containers().getMetadata(containerName);
        boolean exists = metadata.size() > 2;
        this.cacheExistsContainer(containerName, exists);
        return exists;
    }

    @Override
    public void writeObject(String containerName, String objectName, InputStream inputStream, DigestType digestType, long size) throws ContentAddressableStorageException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        try {
            if (size > this.swiftLimit) {
                this.bigFile(containerName, objectName, inputStream, size);
            } else {
                this.smallFile(containerName, objectName, inputStream);
            }
        }
        catch (IOException | ConnectionException e) {
            throw new ContentAddressableStorageException("Could not put object " + containerName + "/" + objectName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bigFile(String containerName, String objectName, InputStream stream, long size) throws ContentAddressableStorageException, IOException {
        Stopwatch times = Stopwatch.createStarted();
        Stopwatch segmentTime = Stopwatch.createUnstarted();
        try {
            long segmentSize;
            int segmentIndex = 1;
            for (long remainingSize = size; remainingSize > 0L; remainingSize -= segmentSize) {
                segmentSize = Math.min(this.swiftLimit, remainingSize);
                String segmentName = objectName + "/" + String.format("%08d", segmentIndex);
                BoundedInputStream segmentInputStream = new BoundedInputStream(stream, segmentSize);
                segmentInputStream.setPropagateClose(false);
                try (ExactSizeInputStream exactSizeInputStream = new ExactSizeInputStream((InputStream)segmentInputStream, segmentSize);){
                    VitamAutoCloseInputStream autoCloseInputStream = new VitamAutoCloseInputStream((InputStream)exactSizeInputStream);
                    segmentTime.start();
                    ObjectPutOptions objectPutOptions = ObjectPutOptions.create();
                    objectPutOptions.getOptions().putAll(this.enrichHeadersRequestWithVitamCookie(new HashMap<String, String>()));
                    LOGGER.info("Uploading segment: " + segmentName);
                    this.getObjectStorageService().put(containerName, segmentName, Payloads.create((InputStream)((Object)autoCloseInputStream)), objectPutOptions);
                    PerformanceLogger.getInstance().log("STP_Offer_" + this.getConfiguration().getProvider(), containerName, "REAL_SWIFT_PUT_OBJECT_SEGMENT", segmentTime.elapsed(TimeUnit.MILLISECONDS));
                    segmentTime.reset();
                }
                ++segmentIndex;
            }
            ObjectPutOptions objectPutOptions = ObjectPutOptions.create();
            String largeObjectPrefix = this.getLargeObjectPrefix(containerName, objectName);
            objectPutOptions.getOptions().put(X_OBJECT_MANIFEST, largeObjectPrefix);
            this.enrichHeadersRequestWithVitamCookie(objectPutOptions.getOptions());
            this.getObjectStorageService().put(containerName, objectName, Payloads.create((InputStream)new NullInputStream(0L)), objectPutOptions);
        }
        finally {
            StreamUtils.closeSilently((InputStream)stream);
            PerformanceLogger.getInstance().log("STP_Offer_" + this.getConfiguration().getProvider(), containerName, "REAL_SWIFT_PUT_OBJECT", times.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private String getLargeObjectPrefix(String containerName, String objectName) {
        return containerName + "/" + objectName + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void smallFile(String containerName, String objectName, InputStream stream) throws ContentAddressableStorageException {
        Stopwatch times = Stopwatch.createStarted();
        try {
            VitamAutoCloseInputStream autoCloseInputStream = new VitamAutoCloseInputStream(stream);
            ObjectPutOptions objectPutOptions = ObjectPutOptions.create();
            this.enrichHeadersRequestWithVitamCookie(objectPutOptions.getOptions());
            this.getObjectStorageService().put(containerName, objectName, Payloads.create((InputStream)((Object)autoCloseInputStream)), objectPutOptions);
        }
        finally {
            PerformanceLogger.getInstance().log("STP_Offer_" + this.getConfiguration().getProvider(), containerName, "REAL_SWIFT_PUT_OBJECT", times.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void checkObjectDigestAndStoreDigest(String containerName, String objectName, String objectDigest, DigestType digestType, long size) throws ContentAddressableStorageException {
        this.checkObjectDigest(containerName, objectName, digestType, objectDigest);
        this.updateMetadataObject(containerName, objectName, digestType, objectDigest, size);
    }

    private void checkObjectDigest(String containerName, String objectName, DigestType digestType, String objectDigest) throws ContentAddressableStorageException {
        for (int i = 0; i < this.swiftNbRetries; ++i) {
            boolean forceCheckInAllReplicas = i > 0;
            boolean isLastRetry = i == this.swiftNbRetries - 1;
            try {
                this.checkObjectDigest(containerName, objectName, digestType, objectDigest, forceCheckInAllReplicas);
                return;
            }
            catch (ContentAddressableStorageDigestMismatchException | ContentAddressableStorageNotFoundException e) {
                if (forceCheckInAllReplicas || isLastRetry) {
                    throw e;
                }
                LOGGER.warn("Object digest check failed. Retrying with X-Newest...", e);
                continue;
            }
            catch (ContentAddressableStorageException e) {
                if (isLastRetry) {
                    throw e;
                }
                LOGGER.warn("Object digest computation failed. Retrying after a delay...", (Throwable)e);
                this.sleepBeforeRetry();
            }
        }
    }

    private void checkObjectDigest(String containerName, String objectName, DigestType digestType, String objectDigest, boolean checkAllReplicas) throws ContentAddressableStorageException {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (checkAllReplicas) {
            headers.put(X_NEWEST, "true");
        }
        try (InputStream stream = this.getObjectStorageService().download(containerName, objectName, this.enrichHeadersRequestWithVitamCookie(headers)).getInputStream();){
            Digest digest = new Digest(digestType);
            digest.update(stream);
            String computedDigest = digest.toString();
            if (computedDigest.equals(objectDigest)) {
                LOGGER.debug("Object {}/{} digest {} checked successfully", new Object[]{containerName, objectName, computedDigest});
                return;
            }
            throw new ContentAddressableStorageDigestMismatchException("Illegal state for container " + containerName + " and  object " + objectName + ". Stream digest " + objectDigest + " is not equal to computed digest " + computedDigest);
        }
        catch (ContentAddressableStorageNotFoundException e) {
            throw new ContentAddressableStorageNotFoundException(String.format("Inconsistent object swift state. Written object %s/%s not found...", containerName, objectName), (Throwable)e);
        }
        catch (IOException e) {
            throw new ContentAddressableStorageException("Cannot check digest for object " + containerName + "/" + objectName, (Throwable)e);
        }
    }

    private void updateMetadataObject(String containerName, String objectName, DigestType digestType, String digest, long size) throws ContentAddressableStorageException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (size > this.swiftLimit) {
            headers.put(X_OBJECT_MANIFEST, this.getLargeObjectPrefix(containerName, objectName));
        }
        headers.put(X_OBJECT_META_DIGEST, digest);
        headers.put(X_OBJECT_META_DIGEST_TYPE, digestType.getName());
        this.enrichHeadersRequestWithVitamCookie(headers);
        RetryableOnException retryableOnException = new RetryableOnException(this.getRetryableParameters());
        retryableOnException.exec(() -> {
            this.getObjectStorageService().updateMetadata(ObjectLocation.create((String)containerName, (String)objectName), headers);
            return null;
        });
        PerformanceLogger.getInstance().log("STP_Offer_" + this.getConfiguration().getProvider(), containerName, "STORE_DIGEST_IN_METADATA", stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Override
    public String getObjectDigest(String containerName, String objectName, DigestType digestType, boolean noCache) throws ContentAddressableStorageException {
        if (noCache) {
            return this.computeObjectDigest(containerName, objectName, digestType);
        }
        Map<String, String> metadata = this.getObjectMetadata(containerName, objectName);
        if (this.checkDigestProperty(metadata) && this.checkDigestTypeProperty(metadata, digestType)) {
            return metadata.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(X_OBJECT_META_DIGEST)).map(Map.Entry::getValue).findFirst().get();
        }
        LOGGER.warn(String.format("Could not retrieve cached digest for object '%s' in container '%s'", objectName, containerName));
        Pair<String, Long> objectDigestAndSize = this.computeObjectDigestAndSize(containerName, objectName, digestType);
        this.updateMetadataObject(containerName, objectName, digestType, (String)objectDigestAndSize.getLeft(), (Long)objectDigestAndSize.getRight());
        return (String)objectDigestAndSize.getLeft();
    }

    /*
     * Exception decompiling
     */
    private Map<String, String> getObjectMetadata(String containerName, String objectName) throws ContentAddressableStorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkDigestTypeProperty(Map<String, String> metadata, DigestType digestType) {
        return metadata.entrySet().stream().anyMatch(e -> ((String)e.getKey()).equalsIgnoreCase(X_OBJECT_META_DIGEST_TYPE) && ((String)e.getValue()).equals(digestType.getName()));
    }

    private boolean checkDigestProperty(Map<String, String> metadata) {
        return metadata.entrySet().stream().anyMatch(e -> ((String)e.getKey()).equalsIgnoreCase(X_OBJECT_META_DIGEST) && e.getValue() != null);
    }

    @Override
    public ObjectContent getObject(String containerName, String objectName) throws ContentAddressableStorageException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        for (int i = 0; i < this.swiftNbRetries; ++i) {
            boolean forceCheckInAllReplicas = i > 0;
            boolean isLastRetry = i == this.swiftNbRetries - 1;
            try {
                HashMap<String, String> headers = new HashMap<String, String>();
                if (forceCheckInAllReplicas) {
                    headers.put(X_NEWEST, "true");
                }
                return this.getObjectStorageService().download(containerName, objectName, this.enrichHeadersRequestWithVitamCookie(headers));
            }
            catch (ContentAddressableStorageNotFoundException e) {
                if (forceCheckInAllReplicas || isLastRetry) {
                    throw e;
                }
                LOGGER.warn("Object not found. Retrying with X-Newest...", (Throwable)e);
                continue;
            }
            catch (ContentAddressableStorageException e) {
                if (isLastRetry) {
                    throw e;
                }
                LOGGER.warn("Object digest computation failed. Retrying after a delay...", (Throwable)e);
                this.sleepBeforeRetry();
            }
        }
        throw new IllegalStateException("Unreachable statement");
    }

    @Override
    public void deleteObject(String containerName, String objectName) throws ContentAddressableStorageException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        RetryableOnException retryableOnException = new RetryableOnException(this.getRetryableParameters());
        retryableOnException.exec(() -> {
            ArrayList swiftObjects = new ArrayList();
            this.listObjectSegments(containerName, objectName, swiftObjects::add);
            this.getObjectStorageService().deleteFullObject(containerName, objectName, swiftObjects.stream().map(ObjectEntry::getObjectId).collect(Collectors.toList()), this.enrichHeadersRequestWithVitamCookie(new HashMap<String, String>()));
            return null;
        });
    }

    @Override
    public boolean isExistingObject(String containerName, String objectName) throws ContentAddressableStorageException {
        RetryableOnException retryableOnException = new RetryableOnException(this.getRetryableParameters());
        Optional object = (Optional)retryableOnException.exec(() -> this.getObjectStorageService().getObjectInformation(containerName, objectName, this.enrichHeadersRequestWithVitamCookie(new HashMap<String, String>())));
        return object.isPresent();
    }

    @Override
    public ContainerInformation getContainerInformation(String containerName) throws ContentAddressableStorageNotFoundException {
        ParametersChecker.checkParameter((String)"Container name may not be null", (String[])new String[]{containerName});
        ContainerInformation containerInformation = new ContainerInformation();
        Map metadata = this.osClient.get().objectStorage().containers().getMetadata(containerName);
        if (metadata.size() <= 2) {
            throw new ContentAddressableStorageNotFoundException(ErrorMessage.CONTAINER_NOT_FOUND + containerName);
        }
        containerInformation.setUsableSpace(-1L);
        return containerInformation;
    }

    @Override
    public MetadatasObject getObjectMetadata(String containerName, String objectId, boolean noCache) throws ContentAddressableStorageException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectId});
        MetadatasStorageObject result = new MetadatasStorageObject();
        RetryableOnException retryableOnException = new RetryableOnException(this.getRetryableParameters());
        Optional object = (Optional)retryableOnException.exec(() -> this.getObjectStorageService().getObjectInformation(containerName, objectId, this.enrichHeadersRequestWithVitamCookie(new HashMap<String, String>())));
        if (object.isEmpty()) {
            throw new ContentAddressableStorageNotFoundException("The Object" + objectId + " can not be found for container " + containerName);
        }
        result.setType(containerName.split("_")[1]);
        result.setObjectName(objectId);
        result.setDigest(this.getObjectDigest(containerName, objectId, VitamConfiguration.getDefaultDigestType(), noCache));
        result.setFileSize(((SwiftObject)object.get()).getSizeInBytes());
        result.setLastModifiedDate(((SwiftObject)object.get()).getLastModified().toString());
        return result;
    }

    @Override
    public void listContainer(String containerName, ObjectListingListener objectListingListener) throws ContentAddressableStorageException, IOException {
        List swiftObjects;
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        String lastEntryName = null;
        long lastEntryTotalSize = 0L;
        String nextMarker = null;
        do {
            RetryableOnException retryable;
            ObjectListOptions objectListOptions = ObjectListOptions.create().limit(this.getConfiguration().getSwiftListObjectBulkSize());
            if (nextMarker != null) {
                objectListOptions.marker(nextMarker);
            }
            if ((swiftObjects = (List)(retryable = new RetryableOnException(this.getRetryableParameters())).exec(() -> this.getObjectStorageService().list(containerName, objectListOptions, this.enrichHeadersRequestWithVitamCookie(new HashMap<String, String>())))).isEmpty()) break;
            for (SwiftObject swiftObject : swiftObjects) {
                if (swiftObject.getName().contains("/")) {
                    if (lastEntryName != null && swiftObject.getName().startsWith(lastEntryName + "/")) {
                        lastEntryTotalSize += swiftObject.getSizeInBytes();
                        LOGGER.debug("Found large object segment " + containerName + "/" + swiftObject.getName() + ". Segment size: " + swiftObject.getSizeInBytes() + " bytes");
                        continue;
                    }
                    LOGGER.warn("Found orphan large object segment without matching object manifest " + containerName + "/" + swiftObject.getName());
                    continue;
                }
                if (lastEntryName != null) {
                    objectListingListener.handleObjectEntry(new ObjectEntry(lastEntryName, lastEntryTotalSize));
                }
                lastEntryName = swiftObject.getName();
                lastEntryTotalSize = swiftObject.getSizeInBytes();
            }
        } while ((nextMarker = ((SwiftObject)swiftObjects.get(swiftObjects.size() - 1)).getName()) != null);
        if (lastEntryName != null) {
            objectListingListener.handleObjectEntry(new ObjectEntry(lastEntryName, lastEntryTotalSize));
        }
    }

    private void listObjectSegments(String containerName, String objectName, ObjectListingListener objectListingListener) throws ContentAddressableStorageException {
        List swiftObjects;
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        String nextMarker = null;
        do {
            RetryableOnException retryable;
            ObjectListOptions objectListOptions = ObjectListOptions.create().path(objectName + "/").limit(this.getConfiguration().getSwiftListObjectBulkSize());
            if (nextMarker != null) {
                objectListOptions.marker(nextMarker);
            }
            if ((swiftObjects = (List)(retryable = new RetryableOnException(this.getRetryableParameters())).exec(() -> this.getObjectStorageService().list(containerName, objectListOptions, this.enrichHeadersRequestWithVitamCookie(new HashMap<String, String>())))).isEmpty()) break;
            for (SwiftObject swiftObject : swiftObjects) {
                try {
                    objectListingListener.handleObjectEntry(new ObjectEntry(swiftObject.getName(), swiftObject.getSizeInBytes()));
                }
                catch (IOException e) {
                    throw new ContentAddressableStorageException("A problem occured while reading segments in the container : " + containerName);
                }
            }
        } while ((nextMarker = ((SwiftObject)swiftObjects.get(swiftObjects.size() - 1)).getName()) != null);
    }

    public void close() {
    }

    private VitamSwiftObjectStorageService getObjectStorageService() {
        return new VitamSwiftObjectStorageService(this.osClient);
    }

    private RetryableParameters getRetryableParameters() {
        return new RetryableParameters(this.swiftNbRetries, this.swiftWaitingTimeInMilliseconds, this.swiftWaitingTimeInMilliseconds, this.swiftRandomRangeSleepInMilliseconds, TimeUnit.MILLISECONDS, VitamLogLevel.ERROR);
    }

    public Supplier<OSClient> getOsClient() {
        return this.osClient;
    }

    private Map<String, String> enrichHeadersRequestWithVitamCookie(Map<String, String> headers) {
        if (this.getConfiguration().getEnableCustomHeaders() == null) {
            LOGGER.debug("The vitam enable custom header property used by offers is not filled!");
        } else if (this.getConfiguration().getEnableCustomHeaders().booleanValue()) {
            LOGGER.debug("The vitam enable custom header used by offers is enabled!");
            if (this.getConfiguration().getCustomHeaders() == null || this.getConfiguration().getCustomHeaders().isEmpty()) {
                LOGGER.warn("No vitam custom headers have been filled!");
            } else {
                this.getConfiguration().getCustomHeaders().forEach(cookie -> headers.put(cookie.getKey(), cookie.getValue()));
            }
        } else {
            LOGGER.debug("The vitam enable custom header property used by offers is disabled!");
        }
        return headers;
    }

    private void sleepBeforeRetry() throws ContentAddressableStorageException {
        int randomRangeSleep = this.swiftRandomRangeSleepInMilliseconds == 0 ? 0 : ThreadLocalRandom.current().nextInt(this.swiftRandomRangeSleepInMilliseconds);
        try {
            Thread.sleep(randomRangeSleep + this.swiftWaitingTimeInMilliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ContentAddressableStorageException("Interrupted thread", (Throwable)e);
        }
    }
}

