/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.filesystem.v2;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.storage.filesystem.v2.HashFileSystem;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;

public class HashFileSystemHelper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(HashFileSystem.class);
    private final String rootPath;
    private final FileSystem fs = FileSystems.getDefault();
    private final String SEPARATOR = this.fs.getSeparator();
    private static final String CONTAINER_SUBDIRECTORY = "container";

    public HashFileSystemHelper(String rootPath) {
        ParametersChecker.checkParameter((String)"rootPath must be defined", (String[])new String[]{rootPath});
        if (rootPath.equals(this.SEPARATOR)) {
            throw new IllegalArgumentException("The storage Path can't be /");
        }
        this.rootPath = rootPath;
    }

    public Path getPathContainer(String containerName) {
        return this.fs.getPath(this.rootPath, CONTAINER_SUBDIRECTORY, containerName);
    }

    public List<String> splitObjectId(String objectId) throws ContentAddressableStorageServerException {
        if (objectId.matches(this.SEPARATOR)) {
            throw new ContentAddressableStorageServerException("objectId " + objectId + " contains " + this.SEPARATOR + " character which is forbidden ");
        }
        Digest d = new Digest(DigestType.SHA256);
        String digest = d.update(objectId.getBytes()).digestHex();
        LinkedList<String> r = new LinkedList<String>();
        for (int i = 0; i < 4; ++i) {
            r.add(digest.substring(i, i + 1));
        }
        return r;
    }

    public Path getPathObject(String container, String objectId) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        if (!this.isContainer(container)) {
            throw new ContentAddressableStorageNotFoundException("Container " + container + " doesn't exist");
        }
        LinkedList<String> subDirectoriesComponentList = new LinkedList<String>();
        for (String id : this.splitObjectId(objectId)) {
            subDirectoriesComponentList.add(id);
        }
        subDirectoriesComponentList.add(objectId);
        String[] subDirectoriesComponentArray = subDirectoriesComponentList.toArray(new String[0]);
        return this.fs.getPath(this.getPathContainer(container).toString(), subDirectoriesComponentArray);
    }

    public void createContainer(String container) throws ContentAddressableStorageServerException {
        ParametersChecker.checkParameter((String)"Container can't be null", (String[])new String[]{container});
        this.createDirectories(this.getPathContainer(container));
    }

    public boolean isContainer(String subpath) {
        ParametersChecker.checkParameter((String)"Subpath can't be null", (String[])new String[]{subpath});
        return this.getPathContainer(subpath).toFile().isDirectory();
    }

    public void createDirectories(Path path) throws ContentAddressableStorageServerException {
        if (path.toFile().isDirectory()) {
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            LOGGER.warn("Path " + path.toString() + " already exists", (Throwable)e);
        }
        catch (IOException e) {
            throw new ContentAddressableStorageServerException("Can't create the directory " + path, (Throwable)e);
        }
    }
}

