/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.external.client;

import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.external.client.DefaultClient;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;

public class VitamRestTestClient
extends DefaultClient {
    public VitamRestTestClient(VitamClientFactoryInterface<?> factory) {
        super(factory);
    }

    public VitamRestTest given() {
        return new VitamRestTest(this);
    }

    public static class VitamRestTest {
        final MultivaluedHashMap<String, Object> headers = new MultivaluedHashMap();
        Object body;
        MediaType contentType;
        List<String> pathParameters = new ArrayList<String>();
        Response.Status expectedStatus;
        MediaType acceptMediaType = MediaType.APPLICATION_JSON_TYPE;
        final VitamRestTestClient client;

        VitamRestTest(VitamRestTestClient client) {
            this.client = client;
        }

        public String toString() {
            return "VitamRestTest: { " + "Headers: { " + this.headers + " } " + ", Body: { value: " + (this.body != null) + ", type: " + this.contentType + " } " + ", pathParameters: \"" + this.pathParameters + "\"" + ", expectedStatus: " + this.expectedStatus + ", acceptedMediaType: " + this.acceptMediaType + ", " + this.client.toString() + " }";
        }

        private void reset() {
            this.body = null;
            this.contentType = null;
            this.headers.clear();
            this.pathParameters.clear();
            this.expectedStatus = null;
            this.acceptMediaType = MediaType.APPLICATION_JSON_TYPE;
        }

        public VitamRestTest then() {
            return this;
        }

        public VitamRestTest when() {
            return this;
        }

        public VitamRestTest status(Response.Status status) {
            this.expectedStatus = status;
            return this;
        }

        public VitamRestTest statusCode(int statusCode) {
            this.expectedStatus = Response.Status.fromStatusCode((int)statusCode);
            return this;
        }

        public VitamRestTest accept(MediaType accept) {
            this.acceptMediaType = accept;
            return this;
        }

        public VitamRestTest body(Object body, MediaType mediaType) {
            this.body = body;
            this.contentType = mediaType;
            return this;
        }

        public VitamRestTest addHeader(String key, String value) {
            this.headers.add((Object)key, (Object)value);
            return this;
        }

        public VitamRestTest addPathParameter(String name, String value) {
            this.pathParameters.add("/" + name + "/" + value);
            return this;
        }

        private void checkStatus(int status) throws VitamClientInternalException {
            if (this.expectedStatus != null && status != this.expectedStatus.getStatusCode()) {
                throw new VitamClientInternalException(String.format("Status %d (%s) is not the one expected %d (%s)", status, Response.Status.fromStatusCode((int)status).getReasonPhrase(), this.expectedStatus.getStatusCode(), this.expectedStatus.getReasonPhrase()));
            }
        }

        private String getFinalPath(String path) {
            StringBuilder finalPath = new StringBuilder(path);
            for (String subpath : this.pathParameters) {
                finalPath.append(subpath);
            }
            return finalPath.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(VitamRequestBuilder requestBuilder, String path) throws VitamClientInternalException {
            int n;
            Response response = null;
            try {
                String finalPath = this.getFinalPath(path);
                response = this.client.make(requestBuilder.withPath(finalPath).withHeaders(this.headers).withBody(this.body).withContentType(this.contentType).withAccept(this.acceptMediaType));
                int status = response.getStatus();
                this.checkStatus(status);
                this.reset();
                n = status;
            }
            catch (Throwable throwable) {
                this.client.consumeAnyEntityAndClose(response);
                throw throwable;
            }
            this.client.consumeAnyEntityAndClose(response);
            return n;
        }

        public int get(String path) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.get(), path);
        }

        public int delete(String path) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.delete(), path);
        }

        public int head(String path) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.head(), path);
        }

        public int options(String path) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.options(), path);
        }

        public int post(String path) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.post(), path);
        }

        public int put(String path) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.put(), path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T execute(VitamRequestBuilder requestBuilder, String path, Class<T> entityTpe) throws VitamClientInternalException {
            Object object;
            Response response = null;
            try {
                String finalPath = this.getFinalPath(path);
                response = this.client.make(requestBuilder.withPath(finalPath).withHeaders(this.headers).withBody(this.body).withContentType(this.contentType).withAccept(this.acceptMediaType));
                int status = response.getStatus();
                this.checkStatus(status);
                this.reset();
                object = response.readEntity(entityTpe);
            }
            catch (Throwable throwable) {
                this.client.consumeAnyEntityAndClose(response);
                throw throwable;
            }
            this.client.consumeAnyEntityAndClose(response);
            return (T)object;
        }

        public <T> T get(String path, Class<T> entityTpe) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.get(), path, entityTpe);
        }

        public <T> T delete(String path, Class<T> entityTpe) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.delete(), path, entityTpe);
        }

        public <T> T options(String path, Class<T> entityTpe) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.options(), path, entityTpe);
        }

        public <T> T post(String path, Class<T> entityTpe) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.post(), path, entityTpe);
        }

        public <T> T put(String path, Class<T> entityTpe) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.put(), path, entityTpe);
        }
    }
}

