/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import com.mongodb.client.MongoCursor;
import fr.gouv.vitam.common.FileUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.index.model.ReindexationResult;
import fr.gouv.vitam.common.database.index.model.SwitchIndexResult;
import fr.gouv.vitam.common.database.parameter.IndexParameters;
import fr.gouv.vitam.common.database.parameter.SwitchIndexParameters;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.parameter.VitamParameter;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.security.SafeFileChecker;
import fr.gouv.vitam.common.server.application.VitamHttpHeader;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.common.timestamp.TimeStampSignature;
import fr.gouv.vitam.common.timestamp.TimeStampSignatureWithKeystore;
import fr.gouv.vitam.common.timestamp.TimestampGenerator;
import fr.gouv.vitam.logbook.administration.audit.core.LogbookAuditAdministration;
import fr.gouv.vitam.logbook.administration.audit.exception.LogbookAuditException;
import fr.gouv.vitam.logbook.administration.core.LfcTraceabilityType;
import fr.gouv.vitam.logbook.administration.core.LogbookAdministration;
import fr.gouv.vitam.logbook.administration.core.LogbookLFCAdministration;
import fr.gouv.vitam.logbook.common.exception.TraceabilityException;
import fr.gouv.vitam.logbook.common.model.AuditLogbookOptions;
import fr.gouv.vitam.logbook.common.model.LifecycleTraceabilityStatus;
import fr.gouv.vitam.logbook.common.model.LogbookLifeCycleObjectGroupModel;
import fr.gouv.vitam.logbook.common.model.LogbookLifeCycleUnitModel;
import fr.gouv.vitam.logbook.common.model.RawLifecycleByLastPersistedDateRequest;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleObjectGroupParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParametersBulk;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.server.LogbookDbAccess;
import fr.gouv.vitam.logbook.common.server.config.ElasticsearchLogbookIndexManager;
import fr.gouv.vitam.logbook.common.server.config.LogbookConfiguration;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycle;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbAccessFactory;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import fr.gouv.vitam.logbook.common.server.database.collections.request.LogbookVarNameAdapter;
import fr.gouv.vitam.logbook.common.server.exception.LogbookAlreadyExistsException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookDatabaseException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookNotFoundException;
import fr.gouv.vitam.logbook.lifecycles.api.LogbookLifeCycles;
import fr.gouv.vitam.logbook.lifecycles.core.LogbookLifeCyclesImpl;
import fr.gouv.vitam.logbook.operations.api.LogbookOperations;
import fr.gouv.vitam.logbook.operations.core.AlertLogbookOperationsDecorator;
import fr.gouv.vitam.logbook.operations.core.LogbookOperationsImpl;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

@Path(value="/logbook/v1")
@Tag(name="Logbook")
public class LogbookResource
extends ApplicationStatusResource {
    private static final String LOGBOOK = "logbook";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookResource.class);
    private static final int OVERFLOW_LIMIT = 10000;
    public static final String CODE_VITAM = "code_vitam";
    private final LogbookOperations logbookOperation;
    private final LogbookLifeCycles logbookLifeCycle;
    private final LogbookDbAccess mongoDbAccess;
    private final LogbookAdministration logbookAdministration;
    private final LogbookLFCAdministration logbookLFCAdministration;
    private final LogbookAuditAdministration logbookAuditAdministration;
    private static final String MISSING_THE_TENANT_ID_X_TENANT_ID = "Missing the tenant ID (X-Tenant-Id) or wrong object Type";
    private static final String AUDIT_TRACEABILITY_URI = "/auditTraceability";

    public LogbookResource(LogbookConfiguration configuration, OntologyLoader ontologyLoader, ElasticsearchLogbookIndexManager indexManager) {
        TimeStampSignatureWithKeystore timeStampSignature;
        LogbookConfiguration logbookConfiguration = configuration.isDbAuthentication() ? new LogbookConfiguration(configuration.getMongoDbNodes(), configuration.getDbName(), configuration.getClusterName(), configuration.getElasticsearchNodes(), true, configuration.getDbUserName(), configuration.getDbPassword()) : new LogbookConfiguration(configuration.getMongoDbNodes(), configuration.getDbName(), configuration.getClusterName(), configuration.getElasticsearchNodes());
        this.mongoDbAccess = LogbookMongoDbAccessFactory.create((LogbookConfiguration)logbookConfiguration, (OntologyLoader)ontologyLoader, (ElasticsearchLogbookIndexManager)indexManager);
        this.logbookOperation = new AlertLogbookOperationsDecorator((LogbookOperations)new LogbookOperationsImpl(this.mongoDbAccess, indexManager), configuration.getAlertEvents());
        try {
            File file = PropertiesUtils.findFile((String)configuration.getP12LogbookFile());
            timeStampSignature = new TimeStampSignatureWithKeystore(file, configuration.getP12LogbookPassword().toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            LOGGER.error("unable to instantiate TimeStampGenerator", (Throwable)e);
            throw new RuntimeException(e);
        }
        TimestampGenerator timestampGenerator = new TimestampGenerator((TimeStampSignature)timeStampSignature);
        WorkspaceClientFactory clientFactory = WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM);
        WorkspaceClientFactory.changeMode((String)configuration.getWorkspaceUrl(), (WorkspaceType)WorkspaceType.VITAM);
        this.logbookAdministration = new LogbookAdministration(this.logbookOperation, timestampGenerator, configuration.getOperationTraceabilityTemporizationDelay(), configuration.getOperationTraceabilityMaxRenewalDelay(), configuration.getOperationTraceabilityMaxRenewalDelayUnit(), configuration.getOperationTraceabilityThreadPoolSize().intValue());
        ProcessingManagementClientFactory processClientFactory = ProcessingManagementClientFactory.getInstance();
        ProcessingManagementClientFactory.changeConfigurationUrl((String)configuration.getProcessingUrl());
        this.logbookLifeCycle = new LogbookLifeCyclesImpl(this.mongoDbAccess);
        this.logbookLFCAdministration = new LogbookLFCAdministration(this.logbookOperation, this.logbookLifeCycle, processClientFactory, clientFactory, configuration.getLifecycleTraceabilityTemporizationDelay(), configuration.getLifecycleTraceabilityMaxRenewalDelay(), configuration.getLifecycleTraceabilityMaxRenewalDelayUnit(), configuration.getLifecycleTraceabilityMaxEntries());
        this.logbookAuditAdministration = new LogbookAuditAdministration(this.logbookOperation);
        LOGGER.debug("LogbookResource operation & lifecycles initialized");
    }

    @GET
    @Path(value="/operations/{id_op}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getOperation(@PathParam(value="id_op") String id, JsonNode queryDsl, @HeaderParam(value="X-Sliced-Operations") boolean sliced, @HeaderParam(value="X-Cross-Tenant") boolean crossTenant) {
        try {
            LogbookOperation result = this.logbookOperation.getById(id, queryDsl, sliced, crossTenant);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK(queryDsl).addResult((Object)result).setHttpCode(Response.Status.OK.getStatusCode())).build();
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (LogbookException | IllegalArgumentException exc) {
            LOGGER.error(exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
    }

    @POST
    @Path(value="/operations/{id_op}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createOperation(@PathParam(value="id_op") String operationId, LogbookOperationParameters[] operations) {
        Response finalResponse = Response.status((Response.Status)Response.Status.CREATED).build();
        try {
            LOGGER.debug(operationId);
            try {
                ParametersChecker.checkNullOrEmptyParameters((VitamParameter[])operations);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Operations is incorrect", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            this.logbookOperation.create(operationId, operations);
        }
        catch (LogbookAlreadyExistsException exc) {
            LOGGER.error((Throwable)exc);
            finalResponse = Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (LogbookDatabaseException exc) {
            LOGGER.error((Throwable)exc);
            finalResponse = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            finalResponse = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return finalResponse;
    }

    @PUT
    @Path(value="/operations/{id_op}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateOperation(@PathParam(value="id_op") String operationId, LogbookOperationParameters ... operations) {
        Response finalResponse = Response.status((Response.Status)Response.Status.OK).build();
        try {
            ParametersChecker.checkNullOrEmptyParameters((VitamParameter[])operations);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Operations is incorrect", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            this.logbookOperation.update(operationId, operations);
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            finalResponse = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (LogbookDatabaseException exc) {
            LOGGER.error((Throwable)exc);
            finalResponse = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            finalResponse = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return finalResponse;
    }

    @POST
    @Path(value="/operations/traceability")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response generateOperationTraceabilities(@HeaderParam(value="X-Tenant-Id") String xTenantId, List<Integer> tenants) {
        if (Strings.isNullOrEmpty((String)xTenantId)) {
            LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int tenantId = Integer.parseInt(xTenantId);
        if (!VitamConfiguration.getAdminTenant().equals(tenantId)) {
            LOGGER.error("Expecting admin tenant " + VitamConfiguration.getAdminTenant() + ", found: " + tenantId);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (CollectionUtils.isEmpty(tenants)) {
            LOGGER.error("Expecting non empty list of tenants to secure");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (tenants.contains(null)) {
            LOGGER.error("Null tenant to secure");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (new HashSet<Integer>(tenants).size() != tenants.size()) {
            LOGGER.error("Duplicate tenants to secure");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        SetUtils.SetView unknownTenants = SetUtils.difference(new HashSet<Integer>(tenants), new HashSet(VitamConfiguration.getTenants()));
        if (!unknownTenants.isEmpty()) {
            LOGGER.error("Unknown tenants to secure " + (Set)unknownTenants);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            List results = this.logbookAdministration.generateSecureLogbooks(tenants);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode()).addAllResults(results)).build();
        }
        catch (TraceabilityException e) {
            LOGGER.error("unable to generate traceability log", (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            VitamError vitamError = new VitamError(status.name()).setHttpCode(status.getStatusCode()).setMessage("Unable to generate traceability log").setDescription("Unable to generate traceability log");
            return Response.status((Response.Status)status).entity((Object)vitamError).build();
        }
    }

    @GET
    @Path(value="/operations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response selectOperation(JsonNode query, @HeaderParam(value="X-Sliced-Operations") boolean sliced, @HeaderParam(value="X-Cross-Tenant") boolean crossTenant) {
        try {
            RequestResponseOK response = this.logbookOperation.selectOperationsAsRequestResponse(query, sliced, crossTenant);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response.setHttpCode(Response.Status.OK.getStatusCode())).build();
        }
        catch (VitamDBException ve) {
            LOGGER.error((Throwable)ve);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(ve.getMessage()).setDescription(status.getReasonPhrase())).build();
        }
        catch (LogbookException | IllegalArgumentException exc) {
            LOGGER.error(exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
    }

    @GET
    @Path(value="/lastOperationByType")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getLastOperationByType(String operationType) {
        try {
            Optional result = this.logbookOperation.findLastOperationByType(operationType);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addAllResults(result.stream().collect(Collectors.toList()))).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookDatabaseException exc) {
            LOGGER.error(exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/operations/{id_op}/unitlifecycles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response getUnitLifeCyclesByOperation(@PathParam(value="id_op") String operationId, @HeaderParam(value="X-Event-Status") String evtStatus, JsonNode query) {
        File file = null;
        try {
            file = FileUtil.createFileInTempDirectoryWithPathCheck((String)operationId, (String)".jsonl");
            Select newQuery = this.addConditionToQuery(operationId, query);
            try (MongoCursor iterator = this.mongoDbAccess.getLogbookLifeCycleUnitsFull(this.fromLifeCycleStatusToUnitCollection(this.getSelectLifeCycleStatusCode(evtStatus)), newQuery);
                 FileOutputStream out = new FileOutputStream(file);
                 JsonLineWriter writer = new JsonLineWriter((OutputStream)out);){
                while (iterator.hasNext()) {
                    writer.addEntry((Object)JsonHandler.toJsonNode((Object)iterator.next()));
                }
            }
            Response response = Response.ok((Object)new FileInputStream(file)).build();
            return response;
        }
        catch (IllegalPathException | IllegalArgumentException exc) {
            LOGGER.error(exc);
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            return response;
        }
        catch (Exception exc) {
            LOGGER.error((Throwable)exc);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        finally {
            FileUtils.deleteQuietly((File)file);
        }
    }

    private Select addConditionToQuery(String operationId, JsonNode query) throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)new LogbookVarNameAdapter());
        parser.parse(query);
        parser.addCondition((Query)QueryHelper.or().add(new Query[]{QueryHelper.eq((String)LogbookMongoDbName.eventIdentifierProcess.getDbname(), (String)operationId)}).add(new Query[]{QueryHelper.eq((String)("events." + LogbookMongoDbName.eventIdentifierProcess.getDbname()), (String)operationId)}));
        return parser.getRequest();
    }

    @POST
    @Path(value="/operations/{id_op}/unitlifecycles/{id_lc}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createUnitLifeCyclesByOperation(@PathParam(value="id_op") String operationId, @PathParam(value="id_lc") String unitLcId, LogbookLifeCycleUnitParameters parameters) {
        try {
            try {
                ParametersChecker.checkNullOrEmptyParameters((VitamParameter)parameters);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("unit lifecycles is incorrect", (Throwable)e);
                Response.Status status = Response.Status.BAD_REQUEST;
                return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
            }
            this.logbookLifeCycle.createUnit(operationId, unitLcId, parameters);
        }
        catch (LogbookAlreadyExistsException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.CONFLICT;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (LogbookDatabaseException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @POST
    @Path(value="/operations/{id_op}/bulklifecycles/unit/temporary")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateUnitLifeCyclesUnitTemporaryByOperation(@PathParam(value="id_op") String operationId, List<LogbookLifeCycleParametersBulk> logbookLifeCycleParametersBulk) {
        this.logbookLifeCycle.updateLogbookLifeCycleBulk(LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS, logbookLifeCycleParametersBulk);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @POST
    @Path(value="/operations/{id_op}/bulklifecycles/got/temporary")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateUnitLifeCyclesGOTTemporaryByOperation(@PathParam(value="id_op") String operationId, List<LogbookLifeCycleParametersBulk> logbookLifeCycleParametersBulk) {
        this.logbookLifeCycle.updateLogbookLifeCycleBulk(LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS, logbookLifeCycleParametersBulk);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @POST
    @Path(value="/operations/{id_op}/bulklifecycles/unit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateUnitLifeCyclesUnitByOperation(@PathParam(value="id_op") String operationId, List<LogbookLifeCycleParametersBulk> logbookLifeCycleParametersBulk) {
        this.logbookLifeCycle.updateLogbookLifeCycleBulk(LogbookCollections.LIFECYCLE_UNIT, logbookLifeCycleParametersBulk);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @POST
    @Path(value="/operations/{id_op}/bulklifecycles/got")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateUnitLifeCyclesGOTByOperation(@PathParam(value="id_op") String operationId, List<LogbookLifeCycleParametersBulk> logbookLifeCycleParametersBulk) {
        this.logbookLifeCycle.updateLogbookLifeCycleBulk(LogbookCollections.LIFECYCLE_OBJECTGROUP, logbookLifeCycleParametersBulk);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Path(value="/operations/{id_op}/unitlifecycles/{id_lc}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateUnitLifeCyclesUnitTemporaryByOperation(@PathParam(value="id_op") String operationId, @PathParam(value="id_lc") String unitLcId, @HeaderParam(value="X-Event-Status") String evtStatus, LogbookLifeCycleUnitParameters parameters) {
        block10: {
            try {
                LifeCycleStatusCode lifeCycleStatus = this.getUpdateOrCommitLifeCycleStatusCode(evtStatus);
                if (LifeCycleStatusCode.LIFE_CYCLE_IN_PROCESS.equals((Object)lifeCycleStatus)) {
                    try {
                        ParametersChecker.checkNullOrEmptyParameters((VitamParameter)parameters);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error("unit lifecycles is incorrect", (Throwable)e);
                        Response.Status status = Response.Status.BAD_REQUEST;
                        return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
                    }
                    this.logbookLifeCycle.updateUnit(operationId, unitLcId, parameters);
                    break block10;
                }
                if (null == parameters || parameters.getMapParameters().isEmpty()) {
                    this.logbookLifeCycle.commitUnit(operationId, unitLcId);
                } else {
                    this.logbookLifeCycle.updateUnit(operationId, unitLcId, parameters, true);
                }
            }
            catch (LogbookNotFoundException exc) {
                LOGGER.debug((Throwable)exc);
                Response.Status status = Response.Status.NOT_FOUND;
                return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
            }
            catch (LogbookDatabaseException exc) {
                LOGGER.error((Throwable)exc);
                Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
            }
            catch (IllegalArgumentException exc) {
                LOGGER.error((Throwable)exc);
                Response.Status status = Response.Status.BAD_REQUEST;
                return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
            }
            catch (LogbookAlreadyExistsException exc) {
                LOGGER.error((Throwable)exc);
                Response.Status status = Response.Status.CONFLICT;
                return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/operations/{id_op}/unitlifecycles/{id_lc}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteUnitLifeCyclesByOperation(@PathParam(value="id_op") String operationId, @PathParam(value="id_lc") String unitLcId) {
        try {
            this.logbookLifeCycle.rollbackUnit(operationId, unitLcId);
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (LogbookDatabaseException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Deprecated
    @PUT
    @Path(value="/operations/{id_op}/unitlifecycles/{id_lc}/commit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response commitUnitLifeCyclesByOperation(@PathParam(value="id_op") String operationId, @PathParam(value="id_lc") String unitLcId) {
        LOGGER.debug("UnitLifeCycle commited: " + unitLcId);
        try {
            this.logbookLifeCycle.commitUnit(operationId, unitLcId);
        }
        catch (LogbookDatabaseException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (LogbookNotFoundException e) {
            LOGGER.debug((Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (LogbookAlreadyExistsException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/operations/{id_op}/unitlifecycles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response bulkCreateUnit(@PathParam(value="id_op") String idOp, String array) {
        try {
            ParametersChecker.checkParameter((String)"Logbook parameters", (String[])new String[]{array});
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Lifecycles is incorrect", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            LogbookLifeCycleUnitParameters[] arrayLifecycles = (LogbookLifeCycleUnitParameters[])JsonHandler.getFromString((String)array, LogbookLifeCycleUnitParameters[].class);
            this.logbookLifeCycle.createBulkLogbookLifecycle(idOp, (LogbookLifeCycleParameters[])arrayLifecycles);
        }
        catch (LogbookDatabaseException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (LogbookAlreadyExistsException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(e);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Path(value="/operations/{id_op}/lifecycles/objectgroup/bulk")
    @Consumes(value={"application/json"})
    public Response createLifeCycleObjectGroupBulk(@PathParam(value="id_op") String idOp, List<LogbookLifeCycleObjectGroupModel> logbookLifeCycleModels) {
        ParametersChecker.checkParameter((String)"Logbook parameters", (Object[])new Object[]{logbookLifeCycleModels});
        try {
            this.logbookLifeCycle.bulk(LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS, idOp, logbookLifeCycleModels);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Lifecycles is incorrect", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (DatabaseException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Path(value="/operations/{id_op}/lifecycles/unit/bulk")
    @Consumes(value={"application/json"})
    public Response createLifeCycleUnitBulk(@PathParam(value="id_op") String idOp, List<LogbookLifeCycleUnitModel> logbookLifeCycleModels) {
        ParametersChecker.checkParameter((String)"Logbook parameters", (Object[])new Object[]{logbookLifeCycleModels});
        try {
            this.logbookLifeCycle.bulk(LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS, idOp, logbookLifeCycleModels);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Lifecycles is incorrect", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (DatabaseException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Path(value="/operations/{id_op}/unitlifecycles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateBulkUnit(@PathParam(value="id_op") String idOp, String arrayNodeLifecycle) {
        try {
            LogbookLifeCycleUnitParameters[] arrayLifecycles = (LogbookLifeCycleUnitParameters[])JsonHandler.getFromString((String)arrayNodeLifecycle, LogbookLifeCycleUnitParameters[].class);
            this.logbookLifeCycle.updateBulkLogbookLifecycle(idOp, (LogbookLifeCycleParameters[])arrayLifecycles);
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (LogbookDatabaseException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (InvalidParseOperationException | IllegalArgumentException exc) {
            LOGGER.error(exc);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (LogbookAlreadyExistsException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/unitlifecycles/{id_lc}")
    @Produces(value={"application/json"})
    public Response getUnitLifeCycleById(@PathParam(value="id_lc") String unitLifeCycleId, @HeaderParam(value="X-Event-Status") String evtStatus, JsonNode queryDsl) throws VitamDBException {
        try {
            LifeCycleStatusCode lifeCycleStatusCode = this.getSelectLifeCycleStatusCode(evtStatus);
            LogbookLifeCycle result = this.logbookLifeCycle.selectLifeCycleById(unitLifeCycleId, queryDsl, false, this.fromLifeCycleStatusToUnitCollection(lifeCycleStatusCode));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK(queryDsl).addResult((Object)result).setHttpCode(Response.Status.OK.getStatusCode())).build();
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RequestResponseOK().addResult((Object)JsonHandler.createArrayNode()).setHits(0L, 0, 1).setHttpCode(Response.Status.NOT_FOUND.getStatusCode())).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookException exc) {
            LOGGER.error(exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
    }

    @HEAD
    @Path(value="/unitlifecycles/{id_lc}")
    public Response getUnitLifeCycleStatus(@PathParam(value="id_lc") String unitLifeCycleId) {
        try {
            LifeCycleStatusCode lifeCycleStatusCode = this.logbookLifeCycle.getUnitLifeCycleStatus(unitLifeCycleId);
            if (lifeCycleStatusCode != null) {
                return Response.status((Response.Status)Response.Status.OK).header("X-Event-Status", (Object)lifeCycleStatusCode.toString()).build();
            }
            throw new LogbookNotFoundException(String.format("No lifeCycle found for the given id (%s).", unitLifeCycleId));
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RequestResponseOK().addResult((Object)JsonHandler.createArrayNode()).setHits(0L, 0, 1).setHttpCode(Response.Status.NOT_FOUND.getStatusCode())).build();
        }
        catch (LogbookDatabaseException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
    }

    @GET
    @Path(value="/unitlifecycles")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getUnitLifeCycles(JsonNode queryDsl, @HeaderParam(value="X-Event-Status") String evtStatus) throws VitamDBException {
        try {
            LifeCycleStatusCode lifeCycleStatusCode = this.getSelectLifeCycleStatusCode(evtStatus);
            List result = this.logbookLifeCycle.selectLifeCycles(queryDsl, false, this.fromLifeCycleStatusToUnitCollection(lifeCycleStatusCode));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK(queryDsl).addAllResults(result).setHttpCode(Response.Status.OK.getStatusCode())).build();
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RequestResponseOK().addResult((Object)JsonHandler.createArrayNode()).setHits(0L, 0, 1).setHttpCode(Response.Status.NOT_FOUND.getStatusCode())).build();
        }
        catch (InvalidParseOperationException | LogbookException exc) {
            LOGGER.error(exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @POST
    @Path(value="/raw/unitlifecycles/bylastpersisteddate")
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/json"})
    public Response exportRawUnitLifecyclesByLastPersistedDate(RawLifecycleByLastPersistedDateRequest request) {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        CloseableIterator lfcIterator;
        File file;
        block11: {
            file = null;
            int softLimit = request.getLimit() + 10000;
            lfcIterator = this.logbookLifeCycle.getRawUnitLifecyclesByLastPersistedDate(request.getStartDate(), request.getEndDate(), softLimit);
            file = this.exportLifecyclesToTempFile(request.getLimit(), (CloseableIterator<JsonNode>)lfcIterator);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/octet-stream");
            headers.put(VitamHttpHeader.X_CONTENT_LENGTH.getName(), Long.toString(file.length()));
            vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse((InputStream)new FileInputStream(file), Response.Status.OK, headers);
            if (lfcIterator == null) break block11;
            lfcIterator.close();
        }
        FileUtils.deleteQuietly((File)file);
        return vitamAsyncInputStreamResponse;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (lfcIterator != null) {
                            try {
                                lfcIterator.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exc) {
                        FileUtils.deleteQuietly(file);
                        LOGGER.error((Throwable)exc);
                        Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                        return response;
                    }
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    FileUtils.deleteQuietly(file);
                }
            }
        }
    }

    @GET
    @Path(value="/raw/unitlifecycles/byid/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getRawUnitLifeCycleById(@PathParam(value="id") String id) {
        try {
            JsonNode result = this.logbookLifeCycle.getRawUnitLifeCycleById(id);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addResult((Object)result).setHttpCode(Response.Status.OK.getStatusCode())).build();
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RequestResponseOK().addResult((Object)JsonHandler.createArrayNode()).setHits(0L, 0, 1).setHttpCode(Response.Status.NOT_FOUND.getStatusCode())).build();
        }
        catch (InvalidParseOperationException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
    }

    @GET
    @Path(value="/raw/unitlifecycles/byids")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getRawUnitLifeCycleByIds(List<String> ids) {
        try {
            List results = this.logbookLifeCycle.getRawUnitLifeCycleByIds(ids);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addAllResults(results).setHttpCode(Response.Status.OK.getStatusCode())).build();
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RequestResponseOK().addResult((Object)JsonHandler.createArrayNode()).setHits(0L, 0, 1).setHttpCode(Response.Status.NOT_FOUND.getStatusCode())).build();
        }
        catch (InvalidParseOperationException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/operations/{id_op}/objectgrouplifecycles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response getObjectGroupLifeCyclesByOperation(@PathParam(value="id_op") String operationId, @HeaderParam(value="X-Event-Status") String evtStatus, JsonNode query) {
        File file = null;
        try {
            file = FileUtil.createFileInTempDirectoryWithPathCheck((String)operationId, (String)".jsonl");
            Select newQuery = this.addConditionToQuery(operationId, query);
            try (MongoCursor iterator = this.mongoDbAccess.getLogbookLifeCycleObjectGroupsFull(this.fromLifeCycleStatusToObjectGroupCollection(this.getSelectLifeCycleStatusCode(evtStatus)), newQuery);
                 FileOutputStream out = new FileOutputStream(file);
                 JsonLineWriter writer = new JsonLineWriter((OutputStream)out);){
                while (iterator.hasNext()) {
                    writer.addEntry((Object)JsonHandler.toJsonNode((Object)iterator.next()));
                }
            }
            Response response = Response.ok((Object)new FileInputStream(file)).build();
            return response;
        }
        catch (IllegalPathException | IllegalArgumentException exc) {
            LOGGER.error(exc);
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            return response;
        }
        catch (Exception exc) {
            LOGGER.error((Throwable)exc);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        finally {
            FileUtils.deleteQuietly((File)file);
        }
    }

    @POST
    @Path(value="/operations/{id_op}/objectgrouplifecycles/{id_lc}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createObjectGroupLifeCyclesByOperation(@PathParam(value="id_op") String operationId, @PathParam(value="id_lc") String objGrpId, LogbookLifeCycleObjectGroupParameters parameters) {
        try {
            try {
                ParametersChecker.checkNullOrEmptyParameters((VitamParameter)parameters);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("objectgrouplifecycles is incorrect", (Throwable)e);
                Response.Status status = Response.Status.BAD_REQUEST;
                return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
            }
            this.logbookLifeCycle.createObjectGroup(operationId, objGrpId, parameters);
        }
        catch (LogbookAlreadyExistsException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.CONFLICT;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (LogbookDatabaseException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Path(value="/operations/{id_op}/objectgrouplifecycles/{id_lc}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateObjectGroupLifeCyclesByOperation(@PathParam(value="id_op") String operationId, @PathParam(value="id_lc") String objGrpId, @HeaderParam(value="X-Event-Status") String evtStatus, LogbookLifeCycleObjectGroupParameters parameters) {
        block10: {
            try {
                LifeCycleStatusCode lifeCycleStatus = this.getUpdateOrCommitLifeCycleStatusCode(evtStatus);
                if (LifeCycleStatusCode.LIFE_CYCLE_IN_PROCESS.equals((Object)lifeCycleStatus)) {
                    try {
                        ParametersChecker.checkNullOrEmptyParameters((VitamParameter)parameters);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error("objectgrouplifecycles is incorrect", (Throwable)e);
                        Response.Status status = Response.Status.BAD_REQUEST;
                        return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
                    }
                    this.logbookLifeCycle.updateObjectGroup(operationId, objGrpId, parameters);
                    break block10;
                }
                if (null == parameters || parameters.getMapParameters().isEmpty()) {
                    this.logbookLifeCycle.commitObjectGroup(operationId, objGrpId);
                } else {
                    this.logbookLifeCycle.updateObjectGroup(operationId, objGrpId, parameters, true);
                }
            }
            catch (LogbookNotFoundException exc) {
                LOGGER.debug((Throwable)exc);
                Response.Status status = Response.Status.NOT_FOUND;
                return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
            }
            catch (LogbookDatabaseException exc) {
                LOGGER.error((Throwable)exc);
                Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
            }
            catch (IllegalArgumentException exc) {
                LOGGER.error((Throwable)exc);
                Response.Status status = Response.Status.BAD_REQUEST;
                return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
            }
            catch (LogbookAlreadyExistsException exc) {
                LOGGER.error((Throwable)exc);
                Response.Status status = Response.Status.CONFLICT;
                return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/operations/{id_op}/objectgrouplifecycles/{id_lc}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteObjectGroupLifeCyclesByOperation(@PathParam(value="id_op") String operationId, @PathParam(value="id_lc") String objGrpId) {
        try {
            this.logbookLifeCycle.rollbackObjectGroup(operationId, objGrpId);
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (LogbookDatabaseException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Deprecated
    @PUT
    @Path(value="/operations/{id_op}/objectgrouplifecycles/{id_lc}/commit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response commitObjectGroupLifeCyclesByOperation(@PathParam(value="id_op") String operationId, @PathParam(value="id_lc") String objGrpId) {
        LOGGER.debug("ObjectGroup commited: " + objGrpId);
        try {
            this.logbookLifeCycle.commitObjectGroup(operationId, objGrpId);
        }
        catch (LogbookDatabaseException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (LogbookNotFoundException e) {
            LOGGER.debug((Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (LogbookAlreadyExistsException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/operations/{id_op}/objectgrouplifecycles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response bulkCreateObjectGroup(@PathParam(value="id_op") String idOp, String array) {
        try {
            ParametersChecker.checkParameter((String)"Logbook parameters", (String[])new String[]{array});
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Lifecycles is incorrect", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            LogbookLifeCycleObjectGroupParameters[] arrayLifecycles = (LogbookLifeCycleObjectGroupParameters[])JsonHandler.getFromString((String)array, LogbookLifeCycleObjectGroupParameters[].class);
            this.logbookLifeCycle.createBulkLogbookLifecycle(idOp, (LogbookLifeCycleParameters[])arrayLifecycles);
        }
        catch (LogbookDatabaseException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (LogbookAlreadyExistsException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(e);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Path(value="/operations/{id_op}/objectgrouplifecycles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateBulkObjectGroup(@PathParam(value="id_op") String idOp, String arrayNodeLifecycle) {
        try {
            LogbookLifeCycleObjectGroupParameters[] arrayLifecycles = (LogbookLifeCycleObjectGroupParameters[])JsonHandler.getFromString((String)arrayNodeLifecycle, LogbookLifeCycleObjectGroupParameters[].class);
            this.logbookLifeCycle.updateBulkLogbookLifecycle(idOp, (LogbookLifeCycleParameters[])arrayLifecycles);
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (LogbookDatabaseException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (InvalidParseOperationException | IllegalArgumentException exc) {
            LOGGER.error(exc);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (LogbookAlreadyExistsException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/objectgrouplifecycles/{id_lc}")
    @Produces(value={"application/json"})
    public Response getObjectGroupLifeCycleById(@PathParam(value="id_lc") String objectGroupLifeCycleId, @HeaderParam(value="X-Event-Status") String evtStatus, JsonNode queryDsl) throws VitamDBException {
        try {
            LifeCycleStatusCode requiredLifeCycleStatus = this.getSelectLifeCycleStatusCode(evtStatus);
            LogbookLifeCycle result = this.logbookLifeCycle.selectLifeCycleById(objectGroupLifeCycleId, queryDsl, false, this.fromLifeCycleStatusToObjectGroupCollection(requiredLifeCycleStatus));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK(queryDsl).addResult((Object)result).setHttpCode(Response.Status.OK.getStatusCode())).build();
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RequestResponseOK().addResult((Object)JsonHandler.createArrayNode()).setHits(0L, 0, 1).setHttpCode(Response.Status.NOT_FOUND.getStatusCode())).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookException exc) {
            LOGGER.error(exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
    }

    @GET
    @Path(value="/objectgrouplifecycles")
    @Produces(value={"application/json"})
    public Response getObjectGroupLifeCycles(@HeaderParam(value="X-Event-Status") String evtStatus, JsonNode queryDsl) throws VitamDBException {
        try {
            LifeCycleStatusCode requiredLifeCycleStatus = this.getSelectLifeCycleStatusCode(evtStatus);
            List result = this.logbookLifeCycle.selectLifeCycles(queryDsl, false, this.fromLifeCycleStatusToObjectGroupCollection(requiredLifeCycleStatus));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK(queryDsl).addAllResults(result).setHttpCode(Response.Status.OK.getStatusCode())).build();
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RequestResponseOK(queryDsl).setHttpCode(Response.Status.NOT_FOUND.getStatusCode())).build();
        }
        catch (InvalidParseOperationException | LogbookException exc) {
            LOGGER.error(exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
    }

    @HEAD
    @Path(value="/objectgrouplifecycles/{id_lc}")
    public Response getObjectGroupLifeCycleStatus(@PathParam(value="id_lc") String objectGroupLifeCycleId) {
        try {
            LifeCycleStatusCode lifeCycleStatusCode = this.logbookLifeCycle.getObjectGroupLifeCycleStatus(objectGroupLifeCycleId);
            if (lifeCycleStatusCode != null) {
                return Response.status((Response.Status)Response.Status.OK).header("X-Event-Status", (Object)lifeCycleStatusCode.toString()).build();
            }
            throw new LogbookNotFoundException(String.format("No lifeCycle found for the given id %s.", objectGroupLifeCycleId));
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RequestResponseOK().addResult((Object)JsonHandler.createArrayNode()).setHits(0L, 0, 1).setHttpCode(Response.Status.NOT_FOUND.getStatusCode())).build();
        }
        catch (LogbookDatabaseException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @POST
    @Path(value="/raw/objectgrouplifecycles/bylastpersisteddate")
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/json"})
    public Response exportRawObjectGroupLifecyclesByLastPersistedDate(RawLifecycleByLastPersistedDateRequest request) {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        CloseableIterator lfcIterator;
        File file;
        block11: {
            int softLimit = request.getLimit() + 10000;
            file = null;
            lfcIterator = this.logbookLifeCycle.getRawObjectGroupLifecyclesByLastPersistedDate(request.getStartDate(), request.getEndDate(), softLimit);
            file = this.exportLifecyclesToTempFile(request.getLimit(), (CloseableIterator<JsonNode>)lfcIterator);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/octet-stream");
            headers.put(VitamHttpHeader.X_CONTENT_LENGTH.getName(), Long.toString(file.length()));
            vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse((InputStream)new FileInputStream(file), Response.Status.OK, headers);
            if (lfcIterator == null) break block11;
            lfcIterator.close();
        }
        FileUtils.deleteQuietly((File)file);
        return vitamAsyncInputStreamResponse;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (lfcIterator != null) {
                            try {
                                lfcIterator.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exc) {
                        LOGGER.error((Throwable)exc);
                        Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                        return response;
                    }
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    FileUtils.deleteQuietly(file);
                }
            }
        }
    }

    @GET
    @Path(value="/raw/objectgrouplifecycles/byid/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getRawObjectGroupLifeCycleById(@PathParam(value="id") String id) {
        try {
            JsonNode result = this.logbookLifeCycle.getRawObjectGroupLifeCycleById(id);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addResult((Object)result).setHttpCode(Response.Status.OK.getStatusCode())).build();
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RequestResponseOK().addResult((Object)JsonHandler.createArrayNode()).setHits(0L, 0, 1).setHttpCode(Response.Status.NOT_FOUND.getStatusCode())).build();
        }
        catch (InvalidParseOperationException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
    }

    @GET
    @Path(value="/raw/objectgrouplifecycles/byids")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getRawObjectGroupLifeCycleByIds(List<String> ids) {
        try {
            List results = this.logbookLifeCycle.getRawObjectGroupLifeCycleByIds(ids);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addAllResults(results).setHttpCode(Response.Status.OK.getStatusCode())).build();
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RequestResponseOK().addResult((Object)JsonHandler.createArrayNode()).setHits(0L, 0, 1).setHttpCode(Response.Status.NOT_FOUND.getStatusCode())).build();
        }
        catch (InvalidParseOperationException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
    }

    @Nonnull
    private File exportLifecyclesToTempFile(int limit, CloseableIterator<JsonNode> lfcIterator) throws IOException {
        try {
            File tmpFile;
            block15: {
                tmpFile = SafeFileChecker.checkSafeFilePath((String)VitamConfiguration.getVitamTmpFolder(), (String[])new String[]{GUIDFactory.newGUID().getId()});
                try (FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
                     JsonLineWriter jsonLineWriter = new JsonLineWriter((OutputStream)fileOutputStream);){
                    boolean maxEntriesReached;
                    int cpt;
                    String maxLastPersistedDate = null;
                    for (cpt = 0; lfcIterator.hasNext() && cpt < limit; ++cpt) {
                        JsonNode entry = (JsonNode)lfcIterator.next();
                        jsonLineWriter.addEntry((Object)entry);
                        maxLastPersistedDate = entry.get("_lastPersistedDate").asText();
                    }
                    boolean bl = maxEntriesReached = cpt >= limit;
                    if (!maxEntriesReached) break block15;
                    while (lfcIterator.hasNext()) {
                        JsonNode entry = (JsonNode)lfcIterator.next();
                        String entryLastPersistedDate = entry.get("_lastPersistedDate").asText();
                        if (!StringUtils.equals((CharSequence)maxLastPersistedDate, (CharSequence)entryLastPersistedDate)) {
                            break;
                        }
                        jsonLineWriter.addEntry((Object)entry);
                    }
                }
            }
            return tmpFile;
        }
        catch (IllegalPathException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/operations/{id_op}/unitlifecycles")
    public Response rollBackUnitLifeCyclesByOperation(@PathParam(value="id_op") String operationId) {
        try {
            this.logbookLifeCycle.rollBackUnitsByOperation(operationId);
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (LogbookDatabaseException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/operations/{id_op}/objectgrouplifecycles")
    public Response rollBackObjectGroupLifeCyclesByOperation(@PathParam(value="id_op") String operationId) {
        try {
            this.logbookLifeCycle.rollBackObjectGroupsByOperation(operationId);
        }
        catch (LogbookNotFoundException exc) {
            LOGGER.debug((Throwable)exc);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (LogbookDatabaseException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private LogbookCollections fromLifeCycleStatusToUnitCollection(LifeCycleStatusCode lifeCycleStatusCode) {
        if (lifeCycleStatusCode == LifeCycleStatusCode.LIFE_CYCLE_IN_PROCESS) {
            return LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS;
        }
        return LogbookCollections.LIFECYCLE_UNIT;
    }

    private LogbookCollections fromLifeCycleStatusToObjectGroupCollection(LifeCycleStatusCode lifeCycleStatusCode) {
        if (lifeCycleStatusCode == LifeCycleStatusCode.LIFE_CYCLE_IN_PROCESS) {
            return LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS;
        }
        return LogbookCollections.LIFECYCLE_OBJECTGROUP;
    }

    private LifeCycleStatusCode getUpdateOrCommitLifeCycleStatusCode(String evtStatusHeader) throws IllegalArgumentException {
        if (evtStatusHeader == null) {
            return LifeCycleStatusCode.LIFE_CYCLE_IN_PROCESS;
        }
        return LifeCycleStatusCode.valueOf((String)evtStatusHeader);
    }

    private LifeCycleStatusCode getSelectLifeCycleStatusCode(String evtStatusHeader) throws IllegalArgumentException {
        if (evtStatusHeader == null) {
            return LifeCycleStatusCode.LIFE_CYCLE_COMMITTED;
        }
        return LifeCycleStatusCode.valueOf((String)evtStatusHeader);
    }

    @POST
    @Path(value="/lifecycles/units/traceability")
    @Produces(value={"application/json"})
    public Response traceabilityLfcUnit(@HeaderParam(value="X-Tenant-Id") String xTenantId) {
        return this.traceabilityLFC(xTenantId, LfcTraceabilityType.Unit);
    }

    @POST
    @Path(value="/lifecycles/objectgroups/traceability")
    @Produces(value={"application/json"})
    public Response traceabilityLfcObjectGroup(@HeaderParam(value="X-Tenant-Id") String xTenantId) {
        return this.traceabilityLFC(xTenantId, LfcTraceabilityType.ObjectGroup);
    }

    private Response traceabilityLFC(String xTenantId, LfcTraceabilityType lfcTraceabilityType) {
        if (Strings.isNullOrEmpty((String)xTenantId)) {
            LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            Integer tenantId = Integer.parseInt(xTenantId);
            VitamThreadUtils.getVitamSession().setTenantId(tenantId);
            GUID guid = GUIDFactory.newOperationLogbookGUID((int)VitamThreadUtils.getVitamSession().getTenantId());
            VitamThreadUtils.getVitamSession().setRequestId(guid);
            if (this.logbookLFCAdministration.generateSecureLogbookLFC(guid, lfcTraceabilityType)) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addResult((Object)guid.getId()).setHits(1L, 0, 1).setHttpCode(Response.Status.OK.getStatusCode())).build();
            }
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)new RequestResponseOK().setHits(0L, 0, 0).setHttpCode(Response.Status.ACCEPTED.getStatusCode())).build();
        }
        catch (VitamException e) {
            LOGGER.error("unable to generate traceability log", (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            VitamError vitamError = new VitamError(status.name()).setHttpCode(status.getStatusCode()).setMessage("Unable to generate traceability log").setDescription("Unable to generate traceability log");
            return Response.status((Response.Status)status).entity((Object)vitamError).build();
        }
    }

    @GET
    @Path(value="/lifecycles/traceability/check/{id}")
    @Produces(value={"application/json"})
    public Response checkLifecycleTraceabilityStatus(@PathParam(value="id") String operationId) {
        try {
            VitamThreadUtils.getVitamSession().setRequestId(operationId);
            LifecycleTraceabilityStatus status = this.logbookLFCAdministration.checkLifecycleTraceabilityStatus(operationId);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().addResult((Object)status).setHits(1L, 0, 1).setHttpCode(Response.Status.OK.getStatusCode())).build();
        }
        catch (WorkflowNotFoundException | LogbookNotFoundException exc) {
            LOGGER.debug(exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new VitamError(Response.Status.NOT_FOUND.name()).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(Response.Status.NOT_FOUND.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        catch (InvalidCreateOperationException | VitamException e) {
            LOGGER.error("unable to check lifecycle traceability status", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new RequestResponseOK().setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())).build();
        }
    }

    @Path(value="/reindex")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response reindex(IndexParameters indexParameters) {
        try {
            ParametersChecker.checkParameter((String)"Parameters are mandatory", (Object[])new Object[]{indexParameters});
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)new VitamError(Response.Status.PRECONDITION_FAILED.name()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(Response.Status.PRECONDITION_FAILED.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        ReindexationResult result = this.logbookOperation.reindex(indexParameters);
        Response response = null;
        if (CollectionUtils.isEmpty((Collection)result.getIndexKO())) {
            response = Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
        } else if (CollectionUtils.isNotEmpty((Collection)result.getIndexOK())) {
            Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)result).build();
        } else {
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)result).build();
        }
        return response;
    }

    @Path(value="/alias")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response changeIndexes(SwitchIndexParameters switchIndexParameters) {
        try {
            ParametersChecker.checkParameter((String)"parameter is mandatory", (Object[])new Object[]{switchIndexParameters});
            ParametersChecker.checkParameter((String)"alias parameter is mandatory", (String[])new String[]{switchIndexParameters.getAlias()});
            ParametersChecker.checkParameter((String)"indexName parameter is mandatory", (String[])new String[]{switchIndexParameters.getIndexName()});
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)new VitamError(Response.Status.PRECONDITION_FAILED.name()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(Response.Status.PRECONDITION_FAILED.getReasonPhrase()).setDescription(exc.getMessage())).build();
        }
        try {
            SwitchIndexResult switchIndexResult = this.logbookOperation.switchIndex(switchIndexParameters.getAlias(), switchIndexParameters.getIndexName());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)switchIndexResult).build();
        }
        catch (DatabaseException exc) {
            VitamError error = VitamCodeHelper.toVitamError((VitamCode)VitamCode.METADATA_SWITCH_INDEX_ERROR, (String)exc.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build();
        }
    }

    @Path(value="/auditTraceability")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response launchTraceabilityAudit(AuditLogbookOptions options) {
        try {
            int foundOperations = this.logbookAuditAdministration.auditTraceability(options.getType(), options.getAmount(), options.getUnit());
            LOGGER.info(String.format("Found %s operations during last %d %s : %d", options.getType(), options.getAmount(), options.getUnit(), foundOperations));
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)new RequestResponseOK().setHttpCode(Response.Status.ACCEPTED.getStatusCode())).build();
        }
        catch (LogbookAuditException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new VitamError(Response.Status.INTERNAL_SERVER_ERROR.name()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())).build();
        }
    }

    @DELETE
    @Path(value="/objectgrouplifecycles/bulkDelete")
    @Produces(value={"application/json"})
    public Response deleteObjectGroups(List<String> objectGroupIds) {
        JsonNode jsonNode;
        try {
            jsonNode = JsonHandler.toJsonNode(objectGroupIds);
            this.logbookLifeCycle.deleteLifeCycleObjectGroups(objectGroupIds);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (DatabaseException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new VitamError(Response.Status.INTERNAL_SERVER_ERROR.name()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK(jsonNode).setHits((long)objectGroupIds.size(), 0, 1).setHttpCode(Response.Status.OK.getStatusCode())).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/lifeCycleUnits/bulkDelete")
    public Response deleteUnits(List<String> unitsIdentifier) {
        JsonNode jsonNode;
        try {
            jsonNode = JsonHandler.toJsonNode(unitsIdentifier);
            this.logbookLifeCycle.deleteLifeCycleUnits(unitsIdentifier);
        }
        catch (DatabaseException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new VitamError(Response.Status.INTERNAL_SERVER_ERROR.name()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK(jsonNode).setHits((long)unitsIdentifier.size(), 0, 1).setHttpCode(Response.Status.OK.getStatusCode())).build();
    }

    @Path(value="/lastLifeCycleTraceabilityOperation/{eventType}")
    @GET
    @Produces(value={"application/json"})
    public Response findLastLifecycleTraceabilityOperation(@PathParam(value="eventType") String eventType) {
        try {
            LogbookOperation lastLifecycleTraceabilityOperation = this.logbookOperation.findLastLifecycleTraceabilityOperation(eventType, true);
            RequestResponseOK requestResponseOK = new RequestResponseOK();
            requestResponseOK.setHttpCode(Response.Status.OK.getStatusCode());
            if (lastLifecycleTraceabilityOperation != null) {
                requestResponseOK.addResult((Object)lastLifecycleTraceabilityOperation);
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)requestResponseOK).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new VitamError(Response.Status.INTERNAL_SERVER_ERROR.name()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())).build();
        }
    }
}

